/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ivt.CreditLevelFactory;
import com.kingdee.eas.fm.ivt.CreditLevelInfo;
import com.kingdee.eas.fm.ivt.app.AbstractCreditLevelControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLevelControllerBean
extends AbstractCreditLevelControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.CreditLevelControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditLevelInfo creditLevelInfo = (CreditLevelInfo)model;
        if (creditLevelInfo.getId() == null && "001".equals(creditLevelInfo.getNumber().trim()) && this.checkIsExists(ctx)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"2_CreditLevelControllerBean", (Locale)ctx.getLocale()));
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _startingLevel(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        this.updateStartState(ctx, idSet, 1);
    }

    @Override
    protected void _unStartingLevel(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        this.updateStartState(ctx, idSet, 0);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLevelInfo creditLevelInfo = CreditLevelFactory.getLocalInstance(ctx).getCreditLevelInfo(pk);
        if (this.isUsed(ctx, creditLevelInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"3_CreditLevelControllerBean", (Locale)ctx.getLocale()));
        }
        if ("001".equals(creditLevelInfo.getNumber())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"4_CreditLevelControllerBean", (Locale)ctx.getLocale()));
        }
        super._delete(ctx, pk);
    }

    private void updateStartState(Context ctx, Set idSet, int state) throws BOSException {
        Iterator idIterator = idSet.iterator();
        StringBuffer idStringBuffer = new StringBuffer("(");
        while (idIterator.hasNext()) {
            idStringBuffer.append("'");
            idStringBuffer.append(idIterator.next());
            idStringBuffer.append("'");
            idStringBuffer.append(",");
        }
        idStringBuffer.append("''");
        idStringBuffer.append(")");
        StringBuffer sqLStringBuffer = new StringBuffer();
        sqLStringBuffer.append(" update T_IVT_CreditLevel  set FIsStart = ");
        sqLStringBuffer.append(state);
        sqLStringBuffer.append(" where FId in ");
        sqLStringBuffer.append(idStringBuffer);
        try {
            DbUtil.execute((Context)ctx, (String)sqLStringBuffer.toString());
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"5_CreditLevelControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    private boolean checkIsExists(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        return this.exists(ctx, filterInfo);
    }

    protected void _addNewCreditLevel(Context ctx, String chLoanID, String creditLevelID) throws BOSException {
        if (chLoanID == null || chLoanID.trim().length() <= 0 || creditLevelID == null || creditLevelID.trim().length() <= 0) {
            return;
        }
        StringBuffer sqLStringBuffer = new StringBuffer();
        sqLStringBuffer.append("insert INTO  T_IVT_CreditLevelRelation (FChLoanID,FCreditLevelID) values ('");
        sqLStringBuffer.append(chLoanID).append("','");
        sqLStringBuffer.append(creditLevelID).append("'");
        sqLStringBuffer.append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sqLStringBuffer.toString());
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"5_CreditLevelControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    protected void _updateCreditLevel(Context ctx, String chLoanID, String creditLevelID) throws BOSException {
        if (chLoanID == null || chLoanID.trim().length() <= 0 || creditLevelID == null || creditLevelID.trim().length() <= 0) {
            return;
        }
        StringBuffer sqLStringBuffer = new StringBuffer();
        sqLStringBuffer.append("update T_IVT_CreditLevelRelation (FChLoanID,FCreditLevelID) = ('");
        sqLStringBuffer.append(chLoanID).append("','");
        sqLStringBuffer.append(creditLevelID).append("'");
        sqLStringBuffer.append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sqLStringBuffer.toString());
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"5_CreditLevelControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    @Override
    protected CreditLevelInfo _getDefaultCreditLevel(Context ctx) throws BOSException {
        try {
            return this.getCreditLevelInfo(ctx, (IObjectPK)new ObjectUuidPK("V6HwRAEaEADgAAkhwKgSDf3ednU="));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isUsed(Context ctx, CreditLevelInfo creditLevelInfo) throws BOSException {
        MetaDataPK PK = new MetaDataPK("com.kingdee.eas.fm.ivt.app", "ChLoanQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)PK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creditLevel.id", (Object)creditLevelInfo.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        exec.setObjectView(entityViewInfo);
        IRowSet rs = null;
        try {
            rs = exec.executeQuery();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rs.size() != 0;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = null;
        dataBaseInfo = (DataBaseInfo)model;
        this.setNumberFromCodingRule(ctx, dataBaseInfo, this.getCurrentOrgId(ctx));
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        super._update(ctx, pk, model);
    }
}

