/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.app.AbstractEntRepaymentBillControllerBean;
import com.kingdee.eas.fm.ivt.app.EntRepaymentSubsidiaryBookProvider;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EntRepaymentBillControllerBean
extends AbstractEntRepaymentBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.EntRepaymentBillControllerBean");
    private Map botpRelationShip = new HashMap();

    @Override
    protected Map _getInitEditData(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxRepaySeq = 0;
        BigDecimal accumulativeRepayTotalAmt = null;
        java.util.Date lastRepayDate = null;
        HashMap<String, Serializable> returnValue = new HashMap<String, Serializable>();
        String sql = "select FRepaySeq,frepayTotalAmt,frepayDate from t_ivt_entrepaymentbill where FRepaySeq = ( select isnull(max(FRepaySeq),0) from t_ivt_entrepaymentbill where floanbillidid = ?) and floanbillidid = ? ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            pstmt.setString(2, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxRepaySeq = rs.getInt(1);
                accumulativeRepayTotalAmt = rs.getBigDecimal(2);
                Date d = rs.getDate(3);
                lastRepayDate = new java.util.Date(d.getTime());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        returnValue.clear();
        if (maxRepaySeq == 0) {
            accumulativeRepayTotalAmt = Constants.ZERO;
        }
        returnValue.put("maxseq", new Integer(++maxRepaySeq));
        returnValue.put("accoumulateamt", accumulativeRepayTotalAmt);
        returnValue.put("lastrepaydate", lastRepayDate);
        return returnValue;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        EntRepaymentBillInfo repayInfo = (EntRepaymentBillInfo)info;
        if (repayInfo.getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        if (repayInfo.getBizDate() == null) {
            repayInfo.setBizDate(DateUtil.getDayBegin());
        }
        try {
            FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)repayInfo, (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ec) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, info);
        return super._addnew(ctx, info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        EntRepaymentBillInfo oldInfo;
        EntRepaymentBillInfo edit = (EntRepaymentBillInfo)info;
        if (!edit.getIsModifyOper()) {
            this.checkSubmit(ctx, (EntRepaymentBillInfo)info);
        }
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((EntRepaymentBillInfo)info));
        if (null != edit.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(edit.getId())) && (oldInfo = this.getEntRepaymentBillInfo(ctx, "select * where id='" + edit.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        ((EntRepaymentBillInfo)info).setBillStatus(IvtBillStatusEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, info);
        EntRepaymentBillInfo sumbittedInfo = this.getEntRepaymentBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        if (!edit.getIsModifyOper()) {
            this._afterSubmit(ctx, info, pk);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loanBillID.isHistoryLoan"));
        EntRepaymentBillInfo tmp = this.getEntRepaymentBillInfo(ctx, pk, sic);
        if (!tmp.getLoanBillID().isIsHistoryLoan()) {
            this.updateFpItem(ctx, pk);
        }
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT003")) {
            HashSet<String> idset = new HashSet<String>();
            idset.add(pk.toString());
            this.audit(ctx, idset);
            this.book(ctx, idset);
        }
        this.reverseLoanRepay(ctx, ((EntRepaymentBillInfo)info).getSourceBillId(), "1");
        return pk;
    }

    private void updateFpItem(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    private void checkSubmit(Context ctx, EntRepaymentBillInfo info) throws EASBizException, BOSException {
        String sql = "select fid from t_ivt_entrepaymentbill  where floanbillidid = ? and frepayseq = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getLoanBillID().getId().toString(), new Integer(info.getRepaySeq())});
            if (rs.next()) {
                throw new CHLoanException(CHLoanException.REPAYSEQ_ERROR, new Object[]{new Integer(info.getRepaySeq())});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void reCalcInfo(Context ctx, EntRepaymentBillInfo info) throws EASBizException, BOSException {
        String loanid = info.getLoanBillID().getId().toString();
        Map repayRecord = this.getInitEditData(ctx, (IObjectPK)new ObjectUuidPK(loanid));
        Integer maxSeq = (Integer)repayRecord.get("maxseq");
        java.util.Date lastRepayDate = (java.util.Date)repayRecord.get("lastrepaydate");
        if (lastRepayDate != null && info.getRepayDate().before(lastRepayDate)) {
            throw new CHLoanException(CHLoanException.REPAY_DATE_ERROR1);
        }
        ChLoanInfo loanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanid));
        if (info.getRepayAmt().compareTo(loanInfo.getLoanBalance()) != 0) {
            BigDecimal tmp = loanInfo.getLoanBalance().subtract(loanInfo.getFloorAmt());
            if (info.getRepayAmt().compareTo(tmp) > 0 && loanInfo.getLoanTotalAmt().compareTo(loanInfo.getFloorAmt()) != 0) {
                throw new CHLoanException(CHLoanException.REPAY_AMT_ERROR2);
            }
        }
        info.setRepaySeq(maxSeq);
    }

    private void _afterSubmit(Context ctx, IObjectValue info, IObjectPK pk) throws BOSException, EASBizException {
        EntRepaymentBillInfo entRepaymentBillInfo = (EntRepaymentBillInfo)info;
        this._reverseChLoan(ctx, entRepaymentBillInfo);
        if (!entRepaymentBillInfo.isIsHistroyBill()) {
            // empty if block
        }
        this._saveBOTPRelationShip(ctx, entRepaymentBillInfo, pk);
    }

    private void _saveBOTPRelationShip(Context ctx, EntRepaymentBillInfo entRepaymentBillInfo, IObjectPK pk) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(entRepaymentBillInfo.getLoanBillID().getId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    private void _reverseChLoan(Context ctx, EntRepaymentBillInfo info) throws BOSException {
        BigDecimal repayAmt = info.getRepayAmt();
        String sql = "update  t_ivt_chloan set floanbalance = floanbalance - ? , fisreturned = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{repayAmt, info.getLoanBillID().getId().toString()});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntRepaymentBillInfo entRepaymentBillInfo = this.getEntRepaymentBillInfo(ctx, pk);
        if (!entRepaymentBillInfo.isIsHistroyBill()) {
            this._deleteAccrualBill(ctx, pk);
        }
        this._addLoanReAmt(ctx, entRepaymentBillInfo);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        this._deleteBankLoan(ctx, entRepaymentBillInfo);
        super._delete(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)entRepaymentBillInfo, (String)entRepaymentBillInfo.getCompany().getId().toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        this.reverseLoanRepay(ctx, entRepaymentBillInfo.getSourceBillId(), "0");
    }

    private void _deleteBankLoan(Context ctx, EntRepaymentBillInfo entRepaymentBillInfo) {
    }

    private void reverseLoanRepay(Context ctx, String LoanRepayID, String isCreate) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)LoanRepayID)) {
            String sql = "Update T_FIN_LoanRepaymentApply set FIsCreateRepayBill =? where Fid=?";
            FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, LoanRepayID});
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            EntRepaymentBillInfo info = (EntRepaymentBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dDAPTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT009")) {
            for (int i = 0; i < sourceBillCollection.size(); ++i) {
                ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
                LoanInterestBillInfo intRe = this.findLoanInterestBillInfo(ctx, (IObjectPK)srcBillPK);
                if (intRe == null || intRe.isFivouchered() || intRe.getInterestAcctual().compareTo(Constants.ZERO) == 0 && intRe.getPunishInterestActual().compareTo(Constants.ZERO) == 0) continue;
                try {
                    LoanInterestBillFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw new FMException(FMException.EASBIZADDBOT, new Object[]{e.getMessage()});
                }
            }
        }
        return dDAPTransformResult;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        LoanInterestBillInfo intRe;
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT009") && (intRe = this.findLoanInterestBillInfo(ctx, sourceBillPk)) != null && intRe.isFivouchered()) {
            LoanInterestBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    private LoanInterestBillInfo findLoanInterestBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        LoanInterestBillCollection intCol = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    private Set findLoanInterestBillInfo(Context ctx, Set repayIDSet) throws BOSException {
        HashSet<String> idReturn = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repayIDSet, CompareType.INCLUDE));
        evi.setFilter(f);
        LoanInterestBillCollection intCol = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            for (int i = 0; i < intCol.size(); ++i) {
                idReturn.add(intCol.get(i).getId().toString());
            }
        }
        return idReturn;
    }

    private Set findLoanInterestBillInfo2(Context ctx, Set repayIDSet) throws BOSException, EASBizException {
        HashSet<String> idReturn = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repayIDSet, CompareType.INCLUDE));
        evi.setFilter(f);
        LoanInterestBillCollection intCol = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            for (int i = 0; i < intCol.size(); ++i) {
                if (intCol.get(i).isIsCancel()) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"6_EntRepaymentBillControllerBean", (Locale)ctx.getLocale())));
                }
                idReturn.add(intCol.get(i).getId().toString());
            }
        }
        return idReturn;
    }

    private void _addLoanReAmt(Context ctx, EntRepaymentBillInfo entRepaymentBillInfo) throws BOSException {
        String sql = " update t_ivt_chloan  set floanbalance =  floanbalance + ?  where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{entRepaymentBillInfo.getRepayAmt(), entRepaymentBillInfo.getLoanBillID().getId().toString()});
        if (entRepaymentBillInfo.getRepaySeq() == 1) {
            sql = " update t_ivt_chloan  set fisreturned =  0  where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{entRepaymentBillInfo.getLoanBillID().getId().toString()});
        }
    }

    private void _deleteAccrualBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LoanInterestBillFactory.getLocalInstance(ctx).deleteRaleted(pk);
    }

    private void antiBook(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
    }

    private void doBook(Context ctx, EntRepaymentBillInfo entRepaymentBillInfo, IObjectPK pk) throws BOSException, EASBizException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(pk.toString(), EntRepaymentSubsidiaryBookProvider.class.getName());
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntRepaymentBillCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getBillStatus() == IvtBillStatusEnum.AUDIT) continue;
            if (col.get(i).getBillStatus() == IvtBillStatusEnum.SAVE || col.get(i).getBillStatus() == IvtBillStatusEnum.BOOK) {
                throw new CHLoanException(CHLoanException.AUDITERROR);
            }
            String id = col.get(i).getId().toString();
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK chloanPK) throws BOSException, EASBizException {
        this.updateEntRepay(ctx, IvtBillStatusEnum.AUDIT, chloanPK.toString());
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntRepaymentBillCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.SUBMIT) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.BOOK) {
                throw new CHLoanException(CHLoanException.ANTIAUDITERROR);
            }
            String id = col.get(i).getId().toString();
            super.antiAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK chloanPK) throws BOSException {
        this.updateEntRepay(ctx, IvtBillStatusEnum.SUBMIT, chloanPK.toString());
    }

    private void updateEntRepay(Context ctx, IvtBillStatusEnum status, String id) throws BOSException {
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "";
        sql = status.equals((Object)IvtBillStatusEnum.AUDIT) ? "update T_IVT_EntRepaymentBill set FBillStatus = ? , fauditorid = '" + curUser.getId().toString() + "' where fid = ?" : "update T_IVT_EntRepaymentBill set FBillStatus = ? , fauditorid = null where fid = ?";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status.getValue()), id});
    }

    @Override
    protected void _book(Context ctx, Set idSet) throws BOSException, EASBizException {
        Set loanIntIDSet;
        EntRepaymentBillCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.BOOK) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.SUBMIT) {
                throw new CHLoanException(CHLoanException.BOOK_ERROR);
            }
            String id = col.get(i).getId().toString();
            super.book4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT007") && (loanIntIDSet = this.findLoanInterestBillInfo(ctx, idSet)) != null && loanIntIDSet.size() > 0) {
            LoanInterestBillFactory.getLocalInstance(ctx).book(loanIntIDSet);
        }
    }

    @Override
    protected void _book4WF(Context ctx, IObjectPK loanPK) throws BOSException, EASBizException {
        String cashierid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        EntRepaymentBillInfo info = this.getEntRepaymentBillInfo(ctx, loanPK);
        this.updateEntRepayAcceptor(ctx, cashierid, IvtBillStatusEnum.BOOK, loanPK.toString());
        this.newBook(ctx, info, loanPK);
    }

    private void newBook(Context ctx, EntRepaymentBillInfo entRepaymentBillInfo, IObjectPK pk) throws BOSException, EASBizException {
        this.doBook(ctx, entRepaymentBillInfo, pk);
    }

    @Override
    protected void _cancelBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        Set loanIntIDSet;
        EntRepaymentBillCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.AUDIT) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.SUBMIT) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR);
            }
            if (col.get(i).isFivouchered()) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR2, new Object[]{col.get(i).getNumber()});
            }
            if (col.get(i).isIsDownLoaded()) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR3, new Object[]{col.get(i).getNumber()});
            }
            String id = col.get(i).getId().toString();
            super.cancelBook4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT007") && (loanIntIDSet = this.findLoanInterestBillInfo2(ctx, idSet)) != null && loanIntIDSet.size() > 0) {
            LoanInterestBillFactory.getLocalInstance(ctx).cancelBook(loanIntIDSet);
        }
    }

    @Override
    protected void _cancelBook4WF(Context ctx, IObjectPK loanPK) throws BOSException, EASBizException {
        this.newCancelBook(ctx, loanPK);
    }

    private void newCancelBook(Context ctx, IObjectPK loanPK) throws EASBizException, BOSException {
        this.antiBook(ctx, loanPK);
        this.updateEntRepayAcceptor(ctx, null, IvtBillStatusEnum.AUDIT, loanPK.toString());
    }

    private void updateEntRepayAcceptor(Context ctx, String cashierid, IvtBillStatusEnum status, String billid) throws BOSException {
        String sql = "update T_IVT_EntRepaymentBill set FAcceptor = ?,FBillStatus=? where fid = ?";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{cashierid, new Integer(status.getValue()), billid});
    }

    private EntRepaymentBillCollection getColByID(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(f);
        EntRepaymentBillCollection toBeBooked = EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillCollection(evi);
        return toBeBooked;
    }

    @Override
    protected Set _getLoanInterestBill(Context ctx, Set loanBill) throws BOSException, EASBizException {
        return this.findLoanInterestBillInfo(ctx, loanBill);
    }
}

