/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.ivt.FinancingAccountBookNotifyBuilder;
import com.kingdee.eas.fm.ivt.FinancingAccountCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountException;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.app.AbstractFinancingAccountControllerBean;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingAccountControllerBean
extends AbstractFinancingAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.FinancingAccountControllerBean");

    @Override
    protected void _batchClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        FinancingAccountInfo info;
        int i;
        if (idSet == null || idSet.size() == 0) {
            throw new EASBizException(FinancingAccountException.ISNULL);
        }
        FinancingAccountCollection fai = this.getFinancingAccountCollection(ctx, this.viewFinancingAccount(idSet));
        int size = fai.size();
        for (i = 0; i < size; ++i) {
            info = fai.get(i);
            if (null == info || info.getState() != FinancingStateEnum.CLOSE) continue;
            throw new EASBizException(FinancingAccountException.ISCLOSE);
        }
        size = fai.size();
        for (i = 0; i < size; ++i) {
            info = fai.get(i);
            this.executeUpdateState(ctx, "2", info.getId().toString());
        }
    }

    private void executeUpdateState(Context ctx, String state, String id) throws BOSException, EASBizException {
        String sql = "update T_IVT_FinancingAccount set FState = ? where FId = ?";
        FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{state, id});
    }

    private EntityViewInfo viewFinancingAccount(Set idSet) throws EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        return evi;
    }

    @Override
    protected void _batchUnClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        FinancingAccountInfo info;
        int i;
        if (idSet == null || idSet.size() == 0) {
            throw new EASBizException(FinancingAccountException.ISNULL);
        }
        FinancingAccountCollection fai = this.getFinancingAccountCollection(ctx, this.viewFinancingAccount(idSet));
        int size = fai.size();
        for (i = 0; i < size; ++i) {
            info = fai.get(i);
            if (null == info || info.getState() != FinancingStateEnum.SUBMIT) continue;
            throw new EASBizException(FinancingAccountException.ISUNCLOSE);
        }
        size = fai.size();
        for (i = 0; i < size; ++i) {
            info = fai.get(i);
            this.executeUpdateState(ctx, "3", info.getId().toString());
        }
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK((String)it.next());
            this.audit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _batchUnAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK((String)it.next());
            this.UnAudit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException {
        try {
            FinancingAccountInfo info = this.getFinancingAccountInfo(ctx, pk);
            if (info.getState() == FinancingStateEnum.CLOSE || info.getState() == FinancingStateEnum.AUDIT) {
                throw new FinancingAccountException(FinancingAccountException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String sql = "update T_IVT_FinancingAccount set FState = ?, FAuditorID = ?, FAuditTime = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), currentUser.getId().toString(), currTime, pk.toString()});
    }

    @Override
    protected void _UnAudit4WF(Context ctx, IObjectPK pk) throws BOSException {
        try {
            FinancingAccountInfo info = this.getFinancingAccountInfo(ctx, pk);
            if (info.getState() == FinancingStateEnum.CLOSE || info.getState() == FinancingStateEnum.SUBMIT) {
                throw new FinancingAccountException(FinancingAccountException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
            }
            if (info.isIsBook()) {
                throw new FinancingAccountException(FinancingAccountException.ISBOOK_UNAUDIT_ERRO, new Object[]{info.getNumber()});
            }
            if (info.isIsGenePayBill()) {
                throw new FinancingAccountException(FinancingAccountException.ISGENEPAYBILL_UNAUDIT_ERRO, new Object[]{info.getNumber()});
            }
            if (this.checkRedeem(ctx, info)) {
                throw new FinancingAccountException(FinancingAccountException.ISREDEEM_UNAUDIT_ERRO, new Object[]{info.getNumber()});
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        String sql = "update T_IVT_FinancingAccount set FState = ?, FAuditorID = null, FAuditTime = null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    private boolean checkRedeem(Context ctx, FinancingAccountInfo info) {
        boolean Isredem = false;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
            entityViewInfo.setFilter(filter);
            FinancingRedeemCollection collection = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemCollection(entityViewInfo);
            if (collection.size() > 0) {
                Isredem = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return Isredem;
    }

    @Override
    protected void _book(Context ctx, List ids) throws BOSException, EASBizException {
        String[] str = new String[ids.size()];
        String lst = FMHelper.Array2String((String[])ids.toArray(str));
        HashSet idSet = new HashSet(ids);
        FinancingAccountBookNotifyBuilder builder = new FinancingAccountBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        journalColl = builder.getJournalColl(ctx, idSet);
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IVT_FinancingAccount set FIsBook =1");
        sql.append(" where FID in ");
        sql.append(lst);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingAccountInfo accountInfo = (FinancingAccountInfo)model;
        if (accountInfo.getCU() == null) {
            accountInfo.setCU(accountInfo.getCompany().getCU());
        }
        if (!EmptyUtil.isEmpty((String)accountInfo.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(accountInfo.getId()), (CoreBillBaseInfo)accountInfo);
        }
        if (accountInfo.getSourceBillId() != null) {
            this.rewriteSrcBill(ctx, accountInfo, 1);
        }
        return super._addnew(ctx, model);
    }

    private void rewriteSrcBill(Context ctx, FinancingAccountInfo accountInfo, int isCreatetoFac) throws BOSException {
        String pk = accountInfo.getSourceBillId();
        String sql = "update T_IVT_FinancingAccountApply set FIsCreatetoFac = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isCreatetoFac, pk});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinancingAccountInfo info = this.getFinancingAccountInfo(ctx, pk);
        if (info.getState() == FinancingStateEnum.CLOSE) {
            throw new FinancingAccountException(FinancingAccountException.CLOSE_NO_DELETE, new Object[]{info.getNumber()});
        }
        if (info.getState() == FinancingStateEnum.AUDIT) {
            throw new FinancingAccountException(FinancingAccountException.AUDIT_NO_DELETE, new Object[]{info.getNumber()});
        }
        if (info.getSourceBillId() != null) {
            this.rewriteSrcBill(ctx, info, 0);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _cancelbook(Context ctx, List ids) throws BOSException, EASBizException {
        String[] str = new String[ids.size()];
        HashSet idsset = new HashSet(ids);
        String lst = FMHelper.Array2String((String[])ids.toArray(str));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", idsset, CompareType.INCLUDE));
        JournalFactory.getLocalInstance((Context)ctx).delete(filter);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IVT_FinancingAccount set FIsBook =0");
        sql.append(" where FID in ");
        sql.append(lst);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FinancingAccountInfo accountInfo = (FinancingAccountInfo)model;
        if (accountInfo.getBalance() == null) {
            accountInfo.setBalance(accountInfo.getFinanceAmount());
        }
        if (!FinancingStateEnum.AUDIT.equals((Object)accountInfo.getState())) {
            accountInfo.setState(FinancingStateEnum.SAVE);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingAccountInfo accountInfo = (FinancingAccountInfo)model;
        if (!FinancingStateEnum.AUDIT.equals((Object)accountInfo.getState())) {
            accountInfo.setState(FinancingStateEnum.SUBMIT);
        }
        return super._submit(ctx, model);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        int count = sourceBillCollection.size();
        for (int index = 0; index < count; ++index) {
            FinancingAccountInfo financingAccountInfo = (FinancingAccountInfo)sourceBillCollection.getObject(index);
            idSet.add(financingAccountInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)3, CompareType.EQUALS));
        CoreBillBaseCollection financingAccountColl = FinancingAccountFactory.getLocalInstance(ctx).getCoreBillBaseCollection(view);
        int count2 = financingAccountColl.size();
        for (int index = 0; index < count2; ++index) {
            FinancingAccountInfo financingAccountInfo = (FinancingAccountInfo)financingAccountColl.get(index);
            if (!financingAccountInfo.isFiVouchered() && financingAccountInfo.getState().equals((Object)FinancingStateEnum.AUDIT)) continue;
            financingAccountColl.removeObject(index);
        }
        CoreBillBaseCollection sortColls = financingAccountColl;
        DAPTransformResult result = super._generateVoucher(ctx, (IObjectCollection)sortColls, botMappingPK);
        return result;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FinancingAccountInfo info = (FinancingAccountInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
            } else {
                info.setAccountant((UserInfo)ctx.get((Object)"UserInfo"));
                info.setFiVouchered(true);
            }
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }
}

