/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.app.AbstractIntReverseFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class IntReverseFacadeControllerBean
extends AbstractIntReverseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.IntReverseFacadeControllerBean");

    @Override
    protected void _reverseAfterPreInt(Context ctx, LoanInterestBillInfo loanint) throws BOSException, EASBizException {
        this._updateLastIntDate(ctx, loanint);
    }

    @Override
    protected void _reverseAfterRecInt(Context ctx, LoanInterestBillInfo loanint) throws BOSException, EASBizException {
        this._updateLastSettleDate(ctx, loanint);
    }

    private void _updateLastIntDate(Context ctx, LoanInterestBillInfo loanint) throws BOSException {
        if (loanint.getBillStatus().getValue() != IvtBillStatusEnum.SAVE.getValue()) {
            if (loanint.getEndDate() == null) {
                String sql = "update t_ivt_chloan set FLastPreIntDate = null where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getEndDate(), loanint.getLoanBill().getId().toString()});
            } else {
                String sql = "update t_ivt_chloan set FLastPreIntDate = ? where fid = ?";
                ArrayList<Object> paramsList = new ArrayList<Object>();
                paramsList.add(loanint.getEndDate());
                paramsList.add(loanint.getLoanBill().getId().toString());
                if (!EmptyUtil.isEmpty((CoreBaseInfo)loanint.getLoanBill()) && !EmptyUtil.isEmpty((Object)loanint.getLoanBill().getLastPreIntDate())) {
                    sql = sql + " and  FLastPreIntDate < ? ";
                    paramsList.add(loanint.getEndDate());
                }
                Object[] params = paramsList.toArray(new Object[paramsList.size()]);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
        }
    }

    protected void _updateLastSettleDate(Context ctx, LoanInterestBillInfo loanint) throws BOSException {
        if (loanint.getEndDate() == null) {
            String sql = "update t_ivt_chloan set FLastSettleDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getLoanBill().getId().toString()});
        } else {
            String sql = "update t_ivt_chloan set FLastSettleDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getEndDate(), loanint.getLoanBill().getId().toString()});
        }
    }

    @Override
    protected void _reverseAfterDelete(Context ctx, LoanInterestBillInfo intBill) throws BOSException, EASBizException {
        int type = intBill.getIntCalType().getValue();
        if (type == 0) {
            this.casePreInt(ctx, intBill);
        } else if (type == 1) {
            this.caseRecInt(ctx, intBill);
        } else if (type == 2) {
            this.caseRepayInt(ctx, intBill);
        } else {
            this.caseHexiaoInt(ctx, intBill);
        }
    }

    private void caseHexiaoInt(Context ctx, LoanInterestBillInfo intBill) throws BOSException, EASBizException {
    }

    private void caseRepayInt(Context ctx, LoanInterestBillInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_ivt_chloan set FLastSettleDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoanBill().getId().toString()});
        } else {
            String sql = "update t_ivt_chloan set FLastSettleDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoanBill().getId().toString()});
        }
    }

    private void caseRecInt(Context ctx, LoanInterestBillInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_ivt_chloan set FLastSettleDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoanBill().getId().toString()});
        } else {
            String sql = "update t_ivt_chloan set FLastSettleDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoanBill().getId().toString()});
        }
    }

    private void casePreInt(Context ctx, LoanInterestBillInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_ivt_chloan set FLastPreIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoanBill().getId().toString()});
        } else {
            String sql = "update t_ivt_chloan set FLastPreIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoanBill().getId().toString()});
        }
    }
}

