/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.SourceBillTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.ivt.ILoanInterestBill;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanInterestBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillSmartFilter");
    private String failMsg = null;

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String operatorNumber = busiInfo.getOperatorNumber();
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("ChLoanSmartFilter============" + iexec.getSQL()));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL());
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"148_LoanInterestSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"149_LoanInterestSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(" ( ").append(filterSql).append(" ) ");
            }
        } else {
            result.append(" ( ").append(filterSql).append(" ) ");
        }
        Date todaydate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(todaydate.getTime());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.chloan_recint_pre.getName().equals(operatorNumber)) {
            result.append(" and ").append(" isprediction = 1 ");
            result.append(" and ").append(" loanBill.loanBalance > 0 ");
            result.append(" and ").append(" loanBill.BillStatus = 4 ");
            result.append(" and ").append(" intCalType = 1 ");
            result.append(" and ").append(" bizDate = {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
            cal.set(5, cal.get(5) - 1);
            result.append(" and ").append("( loanBill.lastSettleDate = null or loanBill.lastSettleDate <  {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "})");
        }
        if (InterfaceTypeEnum.loanInt_verify.getName().equals(operatorNumber)) {
            result.append(" and ").append(" isprediction = 0 ");
            result.append(" and ").append(" intCalType = 1 ");
            result.append(" and ").append(" unVerifyAmount > 0 ");
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" verifySeq = 0 ");
        }
        if (InterfaceTypeEnum.entint_writeback_chloanint.getName().equals(operatorNumber)) {
            result.append(" and ").append(" isprediction = 0 ");
            result.append(" and ").append(" isDownLoaded = 0 ");
            result.append(" and ").append(" ( intCalType = 1 or intCalType = 2 ) ");
            result.append(" and ").append(" BillStatus = 4 ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            LoanInterestBillInfo billInfo;
            int i;
            String operatorNumber = busiInfo.getOperatorNumber();
            ILoanInterestBill biz = LoanInterestBillFactory.getLocalInstance(ctx);
            LoanInterestBillCollection billColl = this.getBillColl(ctx, billList);
            if (InterfaceTypeEnum.chloan_recint_pre.getName().equals(operatorNumber)) {
                for (i = 0; i < billColl.size(); ++i) {
                    try {
                        billInfo = billColl.get(i);
                        billInfo.setCU(billInfo.getCompany().getCU());
                        Timestamp createtime = this.getTime();
                        billInfo.setCreator(schemaInfo.getOriginator());
                        billInfo.setCreateTime(createtime);
                        billInfo.setLastUpdateUser(schemaInfo.getOriginator());
                        billInfo.setLastUpdateTime(createtime);
                        billInfo.setIsPrediction(false);
                        biz.submit((CoreBaseInfo)billInfo);
                        HashMap<String, String> botMap = new HashMap<String, String>();
                        botMap.put(billInfo.getLoanBill().getId().toString(), billInfo.getId().toString());
                        FMHelper.saveBOTRelation((Context)ctx, botMap);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.loanInt_verify.getName().equals(operatorNumber)) {
                for (i = 0; i < billColl.size(); ++i) {
                    try {
                        billInfo = billColl.get(i);
                        BigDecimal verifyAmt = this.getVerifyAmount(ctx, billInfo);
                        billInfo.setVerifyAmount(verifyAmt);
                        biz.verifyBill(billInfo);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.entint_writeback_chloanint.getName().equals(operatorNumber)) {
                for (i = 0; i < billColl.size(); ++i) {
                    try {
                        Set idSet;
                        billInfo = billColl.get(i);
                        Map idMap = LoanInterestFactory.getLocalInstance((Context)ctx).createFromLoanInterestBill(billInfo.getId().toString(), SourceBillTypeEnum.EntLoanInterest);
                        if (!EmptyUtil.isEmpty((Object)idMap) && idMap.size() > 0 && !EmptyUtil.isEmpty((Collection)(idSet = (Set)idMap.get("createdID"))) && idSet.size() > 0) {
                            String destId = (String)idSet.iterator().next();
                            HashMap<String, String> botMap = new HashMap<String, String>();
                            botMap.put(billInfo.getId().toString(), destId);
                            FMHelper.saveBOTRelation((Context)ctx, botMap);
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private LoanInterestBillCollection getBillColl(Context ctx, List billList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("intAccount.ctrlParam"));
        sic.add(new SelectorItemInfo("intAccount.number"));
        sic.add(new SelectorItemInfo("intAccount.company.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("company.*"));
        view.setSelector(sic);
        LoanInterestBillCollection coll = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(view);
        return coll;
    }

    private BigDecimal getVerifyAmount(Context ctx, LoanInterestBillInfo info) throws EASBizException, BOSException {
        InnerAccountInfo innerAccountInfo = info.getIntAccount();
        BigDecimal verifyAmount = info.getUnVerifyAmount();
        BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue((Context)ctx, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
        AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
        accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
        BigDecimal maxPayAmount = FMHelper.add((BigDecimal)payeeInnerAcctBalance, (BigDecimal)Constants.ZERO);
        OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
            maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
            maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            maxPayAmount = Constants.MAX_VALUE;
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            // empty if block
        }
        if (verifyAmount.compareTo(maxPayAmount) == 1) {
            verifyAmount = maxPayAmount;
        }
        info.setVerifyAmount(verifyAmount);
        return verifyAmount;
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }
}

