/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import java.math.BigDecimal;

public class LoanInterestSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        LoanInterestBillInfo loanInterestBillInfo = this.getLoanInterestBillInfo(ctx, billId);
        int precision = FMHelper.getPrecOfCurrency((Context)ctx, (String)loanInterestBillInfo.getCurrency().getId().toString());
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        ChLoanInfo info = this._getChLoanInfo(ctx, loanInterestBillInfo);
        if (loanInterestBillInfo.getInterestActual().compareTo(Constants.ZERO) != 0) {
            slInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(ctx, info.getBank()));
            slInfo.setApplyUnit(info.getLoanAccount().getApplyUnit());
            slInfo.setInnerAccount(info.getLoanAccount());
            BigDecimal punishInterestActual = loanInterestBillInfo.getPunishInterestActual();
            BigDecimal interestAcctual = loanInterestBillInfo.getInterestAcctual();
            BigDecimal creditAmount = punishInterestActual.add(interestAcctual);
            creditAmount = creditAmount.setScale(precision, 4);
            slInfo.setCreditAmount(creditAmount.setScale(precision, 4));
            slInfo.setDate(loanInterestBillInfo.getBizDate());
            slInfo.setCurrency(info.getCurrency());
            slInfo.setExchangeRate(info.getExchangeRate());
            slInfo.setBillId(BOSUuid.read((String)billId));
            slInfo.setBillNumber(loanInterestBillInfo.getNumber());
            slInfo.setIsDownLoad(false);
            slInfo.setBookkeeper(loanInterestBillInfo.getCreator());
            slInfo.setDescription(loanInterestBillInfo.getDescription());
            slInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
            coll.add(slInfo);
        }
        if (this._bookSecond(loanInterestBillInfo, info)) {
            if (info == null) {
                info = this._getChLoanInfo(ctx, loanInterestBillInfo);
            }
            InnerAccountInfo innerAccount = this._getInnerAccount(info);
            slInfo = new SubsidiaryLedgerInfo();
            slInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(ctx, info.getBank()));
            slInfo.setApplyUnit(info.getLoanAccount().getApplyUnit());
            slInfo.setInnerAccount(innerAccount);
            BigDecimal inte = loanInterestBillInfo.getInterest();
            BigDecimal penaInt = loanInterestBillInfo.getPunishInterest();
            BigDecimal debitAmount = inte.add(penaInt);
            slInfo.setDebitAmount(debitAmount.setScale(precision, 4));
            slInfo.setDate(loanInterestBillInfo.getBizDate());
            slInfo.setCurrency(info.getCurrency());
            slInfo.setExchangeRate(info.getExchangeRate());
            slInfo.setBillId(BOSUuid.read((String)billId));
            slInfo.setBillNumber(loanInterestBillInfo.getNumber());
            slInfo.setIsDownLoad(false);
            slInfo.setBookkeeper(loanInterestBillInfo.getCreator());
            slInfo.setDescription(loanInterestBillInfo.getDescription());
            slInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
            coll.add(slInfo);
        }
        return coll;
    }

    private boolean _bookSecond(LoanInterestBillInfo loanInterestBillInfo, ChLoanInfo info) {
        boolean b1 = loanInterestBillInfo.getInterestActual().compareTo(Constants.ZERO) != 0;
        boolean b2 = info.getDistributeAccou() != null;
        boolean b3 = info.getAccrualAccount() != null;
        return b1 && (b2 || b3);
    }

    private LoanInterestBillInfo getLoanInterestBillInfo(Context ctx, String billid) throws EASBizException, BOSException {
        return LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(billid), this.getSelectors());
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }

    private ChLoanInfo _getChLoanInfo(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        return ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getLoanBill().getId()), this._getSelector());
    }

    private SelectorItemCollection _getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loanAccount.*"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("bank.*"));
        return sic;
    }

    private InnerAccountInfo _getInnerAccount(ChLoanInfo info) {
        if (info.getAccrualAccount() != null) {
            return info.getAccrualAccount();
        }
        return info.getDistributeAccou();
    }
}

