/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.app.AbstractIntCalStragety;
import com.kingdee.eas.fm.ivt.app.ExtDateInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class PreIntCalStragety
extends AbstractIntCalStragety {
    @Override
    protected java.util.Date getBeginDate(Context ctx, java.util.Date condBeginDate, ChLoanInfo loanInfo) throws EASBizException, BOSException {
        if (condBeginDate != null) {
            return this.newRequirment(condBeginDate, loanInfo);
        }
        return this.old(condBeginDate, loanInfo);
    }

    private java.util.Date newRequirment(java.util.Date condBeginDate, ChLoanInfo loanInfo) {
        java.util.Date billStartDate;
        java.util.Date lastPreIntDate;
        java.util.Date returnDate = null;
        returnDate = condBeginDate == null ? ((lastPreIntDate = loanInfo.getLastPreIntDate()) != null ? lastPreIntDate : loanInfo.getStartDate()) : (condBeginDate.compareTo(billStartDate = loanInfo.getStartDate()) <= 0 ? billStartDate : condBeginDate);
        return returnDate;
    }

    private java.util.Date old(java.util.Date condBeginDate, ChLoanInfo loanInfo) throws BOSException {
        java.util.Date issueDate = loanInfo.getStartDate();
        java.util.Date lastPreIntDate = loanInfo.getLastPreIntDate();
        java.util.Date lastIntDate = loanInfo.getLastSettleDate();
        lastPreIntDate = lastPreIntDate == null ? issueDate : DateUtil.getAfterDay((java.util.Date)lastPreIntDate);
        lastIntDate = lastIntDate == null ? issueDate : DateUtil.getAfterDay((java.util.Date)lastIntDate);
        java.util.Date bigDate = condBeginDate;
        if (bigDate == null) {
            try {
                bigDate = DateTimeUtils.parseDate((String)"1900-01-01");
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (issueDate != null && bigDate.compareTo(issueDate) < 0) {
            bigDate = issueDate;
        }
        if (lastPreIntDate != null && bigDate.compareTo(lastPreIntDate) < 0) {
            bigDate = lastPreIntDate;
        }
        if (lastIntDate != null && bigDate.compareTo(lastIntDate) < 0) {
            bigDate = lastIntDate;
        }
        return bigDate;
    }

    @Override
    protected java.util.Date getEndDate(java.util.Date condEndDate, EntRepaymentBillInfo repayBillInfo) {
        return DateUtil.getBeforeDay((java.util.Date)condEndDate);
    }

    @Override
    protected List getSubBeginDateList(Context ctx, java.util.Date beginDate, java.util.Date endDate, String loanId, boolean isAccordIntRate, CHLoanExtendBillCollection loanExColl, EntRepaymentBillInfo repayBillInfo, List allFirstExdDate) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sql.append(" select g.frepaydate subBeginDate, 1 type from T_IVT_CHLoan f \n").append(" \tjoin T_IVT_ENTREPAYMENTBILL g on f.fid=g.floanbillidid \n").append(" \twhere g.frepaydate > ? and g.frepaydate <= ? and g.fisrepaywithaccr = 0 \n").append("\t\tand f.FID = ? \n").append(" union \n").append(" select c.FEffectiveDate subBeginDate, 2 type from T_IVT_CHLoan a \n").append(" \tjoin T_INT_IntRateType b on a.FRateTypeId = b.FID \n").append(" \tjoin T_INT_IntRateBase c on b.FID = c.FTypeID \n").append("  and c.FbillState = '" + billState + "'").append(" \twhere c.FEffectiveDate > ? and c.FEffectiveDate <= ? and c.FIntTermID is null and c.FCurrencyID=? \n").append("\t\tand a.FID = ? \n").append(" union  \n").append(" select e.fbeforeexdate subBeginDate, 3 type from T_IVT_CHLoan d \n").append(" \tjoin t_ivt_chloanextendbill e on d.FID=e.fchloanid \n").append(" \twhere e.fbeforeexdate > ? and e.fbeforeexdate <= ? \n").append("\t\tand d.FID = ? \n").append(" order by subBeginDate \n");
        Date sBeginDate = new Date(beginDate.getTime());
        Date sEndDate = new Date(endDate.getTime());
        Object[] params = new Object[]{sBeginDate, sEndDate, loanId, sBeginDate, sEndDate, this.currencyID, loanId, sBeginDate, sEndDate, loanId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        java.util.Date firstExpDateBeforeExt = this.getFirstExpDateBeforeExt(allFirstExdDate, loanId);
        ArrayList<java.util.Date> subList = new ArrayList<java.util.Date>();
        java.util.Date date = null;
        Integer type = null;
        try {
            while (rs.next()) {
                date = DateTimeUtils.truncateDate((java.util.Date)rs.getDate("subBeginDate"));
                type = new Integer(rs.getInt("type"));
                if (this.isLessOrEqualsFirstExtend(date, firstExpDateBeforeExt) && isAccordIntRate && type == 2 || !this.isLessOrEqualsFirstExtend(date, firstExpDateBeforeExt) && type == 2 || subList.contains(date)) continue;
                subList.add(date);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return subList;
    }

    private boolean isLessOrEqualsFirstExtend(java.util.Date date, java.util.Date firstExpDateBeforeExt) {
        if (firstExpDateBeforeExt == null) {
            return true;
        }
        return date.compareTo(firstExpDateBeforeExt) <= 0;
    }

    private java.util.Date getFirstExpDateBeforeExt(Context ctx, String loanId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 a.FStartDate, b.fbeforeexdate from T_IVT_CHLoan a ").append("\tleft join t_ivt_chloanextendbill b on a.FID=b.fchloanid ").append("\twhere a.fid = ? ").append("\torder by b.fbeforeexdate ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{loanId});
        try {
            if (rs.next()) {
                return rs.getDate(2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private java.util.Date getFirstExpDateBeforeExt(List allFirstExdDate, String loanId) throws BOSException {
        ExtDateInfo info = null;
        java.util.Date FirstExpDateBeforeExt = null;
        for (int i = 0; i < allFirstExdDate.size(); ++i) {
            info = (ExtDateInfo)allFirstExdDate.get(i);
            if (!info.getChloanid().equals(loanId)) continue;
            FirstExpDateBeforeExt = info.getFirstExpDateBeforeExt();
            break;
        }
        return FirstExpDateBeforeExt;
    }

    @Override
    protected BigDecimal getIntPrinciple(BigDecimal balance, BigDecimal intFreeAmt, java.util.Date subBeginDate, EntRepaymentBillCollection repayColl, EntRepaymentBillInfo info) {
        if (repayColl == null || repayColl.isEmpty()) {
            return balance.add(intFreeAmt.negate());
        }
        BigDecimal repayTotalAmt = Constants.ZERO;
        EntRepaymentBillInfo repayInfo = null;
        for (int i = repayColl.size() - 1; i >= 0; --i) {
            repayInfo = repayColl.get(i);
            if (repayInfo.isIsRepayWithAccrual() || repayInfo.getRepayDate().compareTo(subBeginDate) <= 0) continue;
            repayTotalAmt = repayTotalAmt.add(repayInfo.getRepayAmt());
        }
        return balance.add(repayTotalAmt).add(intFreeAmt.negate());
    }

    @Override
    protected IntCalTypeEnum getIntCalType() {
        return IntCalTypeEnum.PRE_INT;
    }

    @Override
    protected boolean isCalPunishInt(java.util.Date beginDate, java.util.Date endDate, java.util.Date expiredDate, EntRepaymentBillInfo repayBillInfo) {
        return endDate.compareTo(expiredDate) > 0;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("isHistoryLoan"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("loanTotalAmt"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("assureWay.name"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("floatPoint"));
        sic.add(new SelectorItemInfo("yearRate"));
        sic.add(new SelectorItemInfo("returnWay"));
        sic.add(new SelectorItemInfo("floorAmt"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("isReturned"));
        sic.add(new SelectorItemInfo("isOverdue"));
        sic.add(new SelectorItemInfo("isPostponed"));
        sic.add(new SelectorItemInfo("fivouchered"));
        sic.add(new SelectorItemInfo("lastSettleDate"));
        sic.add(new SelectorItemInfo("lastPreIntDate"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("rateType.*"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("loanAccount.*"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        return sic;
    }
}

