/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.app.RptChLoanDetailFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Locale;

public class RptChloanDetailHelper {
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo baseCurrency;
    private String queryType;
    private Date endDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String[] currencyIDs;
    private String[] loanCompanyIDs;
    private Object loc;
    private String commonFilerToTimeDeposit;
    private Boolean includeZero;
    String unit = "1";
    private String configFile;

    public static RptChloanDetailHelper getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        return new RptChloanDetailHelper(params, ctx);
    }

    public RptChloanDetailHelper(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("query_type");
        this.endDate = (Date)params.getObject("endDate");
        this.amountUnit = (LoanStatisticalUnitEnum)((Object)params.getObject("amount_amt"));
        this.currencyIDs = (String[])params.getObject("currencyIDs");
        this.loanCompanyIDs = (String[])params.getObject("chLoanCompany");
        this.includeZero = (Boolean)params.getObject("includeZero");
        this.loc = this.getLoc(ctx);
        this.prepare(this.amountUnit.getValue());
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public void prepare(String amountUnit) {
        this.commonFilerToTimeDeposit = this.getCommonFilterToChLoan();
        if (amountUnit.equals("thousand")) {
            this.unit = "1000";
        } else if (amountUnit.equals("ten_thousand")) {
            this.unit = "10000";
        } else if (amountUnit.equals("million")) {
            this.unit = "1000000";
        } else if (amountUnit.equals("hundred_thousand")) {
            this.unit = "10000000";
        } else if (amountUnit.equals("hundred_million")) {
            this.unit = "100000000";
        }
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( chloan.FEffectedStatus = 2 and chloan.fcompanyid = '").append(this.currentCompany.getId().toString()).append("' ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and chloan.fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and chloan.FLoanCompanyID in ").append(this.getValues(this.loanCompanyIDs));
        }
        if (this.endDate != null) {
            sb.append(" and chloan.FEndDate <= { ").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("}");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    public void setSchemaSource(Context ctx, SchemaSource ss) {
        SqlParams sqp = new SqlParams();
        sqp.addDate(this.endDate);
        sqp.addDate(this.endDate);
        ss.setDataItem("Fact", this.getDetailSQL(ctx), sqp);
        ss.setDataItem("Horizon", this.getHorizonDataSQL(ctx), null);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        StringBuffer mdx = null;
        if (this.queryType.equals("by_company")) {
            sql.append("select com.FId,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com\n");
            ss.setDataItem("LoanCompany", sql.toString(), null);
            this.configFile = "RptChLoanDetail_LoanCompany.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"12_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"13_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"14_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select  [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"15_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_loanProduct") || this.queryType.equals("by_currency")) {
            // empty if block
        }
        ss.setCaller(RptChLoanDetailFacadeControllerBean.class);
        ss.setFilename(this.configFile);
        if (mdx == null) {
            return;
        }
        ss.setMdx(mdx.toString());
    }

    private String getDetailSQL(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from                                                                                                                \n");
        sb.append("(                                                                                                                            \n");
        sb.append("select detailtbl.*, (loanamttotal-repaytotalamt) as balance,                                                                 \n");
        sb.append("          (loanAmtLocal-repaytotalamtLocal) as balanceLocal from                                                              \n");
        sb.append("(                                                                                                                            \n");
        sb.append("  select chloan.ffinacingproductid as ffinacingproductid,chloan.fcurrencyid as fcurrencyid,                                  \n");
        sb.append("       chloan.floancompanyid as floancompanyid,isnull(fratetypeid,'10001') as fratetypeid,                                      \n");
        sb.append("       finpro.fname_").append(this.loc).append("  as finproName,cur.fname_").append(this.loc).append("  as fcurrencyName,                                                          \n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"16_RptChloanDetailHelper", (Locale)ctx.getLocale()));
        sb.append("       chloan.fnumber as fnumber, chloan.fid as fid,                                                                         \n");
        sb.append("       (case when chloan.fhorizon<=12 or fhorizon is null then 'shorthorizon'                                                                       \n");
        sb.append("             else 'longhorizon'                                                                                                 \n");
        sb.append("            end                                                                                                              \n");
        sb.append("       ) as fhorizonid,                                                                                                        \n");
        sb.append("       chloan.fyearrate as yearrate,                                                                                         \n");
        sb.append("       chloan.fstartdate as startdate,chloan.fenddate as enddate,                                                            \n");
        sb.append("       chloan.fisoverdue as isovedue,chloan.fdescription as diggest,                                                         \n");
        sb.append("       chloan.floantotalamt as loanamttotal,                                                                                 \n");
        sb.append("       chloan.floantotalamt*chloan.fexchangerate as loanAmtLocal,                                                            \n");
        sb.append("       ( select isnull(sum(frepayamt),0) from t_ivt_entrepaymentbill where floanbillidid = chloan.fid                           \n");
        sb.append("         and FRepayDate< {" + FMConstants.FORMAT_TIME.format(this.endDate) + "}                                                                                                    \n");
        sb.append("        ) as repaytotalamt,                                                                                                  \n");
        sb.append("        ( select isnull(sum(frepayamt*fexchangerate),0) from t_ivt_entrepaymentbill where floanbillidid = chloan.fid         \n");
        sb.append("         and FRepayDate< {" + FMConstants.FORMAT_TIME.format(this.endDate) + "} \t\t\t\t\t\t\t\t                                                                    \n");
        sb.append("        ) as repaytotalamtLocal                                                                                               \n");
        sb.append("  from t_ivt_chloan chloan                                                                                                   \n");
        sb.append("  left outer join  t_org_company com on com.fid = chloan.floancompanyid                                                      \n");
        sb.append("  left outer join  t_bd_currency cur on cur.fid = chloan.fcurrencyid                                                         \n");
        sb.append("  left outer join  t_fin_financingproducts finpro on finpro.fid = chloan.ffinacingproductid                                  \n");
        sb.append("  left outer join  T_INT_IntRateType rateType on rateType.fid = chloan.fratetypeid                                           \n");
        sb.append(" where ").append(this.getCommonFilterToChLoan());
        sb.append(")  detailtbl                                                                                                                 \n");
        sb.append(") \n");
        if (this.includeZero.booleanValue()) {
            sb.append(" where balance>0 \n");
        }
        return sb.toString();
    }

    private String getHorizonDataSQL(Context ctx) {
        String sql = ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"17_RptChloanDetailHelper", (Locale)ctx.getLocale()) + " union all " + ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"18_RptChloanDetailHelper", (Locale)ctx.getLocale());
        return sql;
    }
}

