/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.app.RptChLoanSumFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Locale;

public class RptChloanHelper {
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo baseCurrency;
    private String queryType;
    private Date startDate;
    private Date endDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String loc;
    private String commonFilerToTimeDeposit;
    private String[] currencyIDs;
    private String[] loanCompanyIDs;
    String unit = "1";
    private String groupByColum = "";
    private String configFile;

    public static RptChloanHelper getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        return new RptChloanHelper(params, ctx);
    }

    public RptChloanHelper(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("query_type");
        this.startDate = (Date)params.getObject("startDate");
        this.endDate = (Date)params.getObject("endDate");
        this.amountUnit = (LoanStatisticalUnitEnum)((Object)params.getObject("amount_amt"));
        this.currencyIDs = (String[])params.getObject("currencyIDs");
        this.loanCompanyIDs = (String[])params.getObject("chLoanCompany");
        this.loc = this.getLoc(ctx);
        this.prepare(this.amountUnit.getValue());
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public void prepare(String amountUnit) throws BOSException, EASBizException {
        this.commonFilerToTimeDeposit = this.getCommonFilterToChLoan();
        if (amountUnit.equals("thousand")) {
            this.unit = "1000";
        } else if (amountUnit.equals("ten_thousand")) {
            this.unit = "10000";
        } else if (amountUnit.equals("million")) {
            this.unit = "1000000";
        } else if (amountUnit.equals("hundred_thousand")) {
            this.unit = "10000000";
        } else if (amountUnit.equals("hundred_million")) {
            this.unit = "100000000";
        }
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( FEffectedStatus = 2 and fcompanyid = '").append(this.currentCompany.getId().toString()).append("' ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and FLoanCompanyID in ").append(this.getValues(this.loanCompanyIDs));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    private String getSumSQL() {
        if (this.queryType.equals("by_company")) {
            this.groupByColum = " FLoanCompanyID ";
        } else if (this.queryType.equals("by_loanProduct")) {
            this.groupByColum = " FFinacingProductID ";
        } else if (this.queryType.equals("by_currency")) {
            this.groupByColum = " FCurrencyID ";
        }
        this.groupByColum = this.groupByColum + ",fhorizonid ";
        StringBuffer sb = new StringBuffer(1024);
        sb.append("select\t\t  sum(QICHUYUE_LOCAL)/").append(this.unit).append(" as FQICHUYUE_LOCAL, \n");
        sb.append("       sum(BENQIZENJIA_LOCAL)/").append(this.unit).append(" as FBENQIZENJIA_LOCAL, \n");
        sb.append("       sum(BENQIHUANKUAN_LOCAL)/").append(this.unit).append(" as FBENQIHUANKUAN_LOCAL, \n");
        sb.append("       sum(QIMOYUE_LOCAL)/").append(this.unit).append(" as FQIMOYUE_LOCAL,fhorizonid, \n");
        sb.append("       sum(QIMOYUE_LOCAL+BENQIZENJIA_LOCAL+BENQIHUANKUAN_LOCAL+QIMOYUE_LOCAL) as sum, \n");
        if (this.queryType.equals("by_company")) {
            sb.append(" FLoanCompanyID ");
        } else if (this.queryType.equals("by_loanProduct")) {
            sb.append(" FFinacingProductID ");
        } else if (this.queryType.equals("by_currency")) {
            sb.append(" FCurrencyID ");
        }
        sb.append("              from (select qichuyue as QICHUYUE,qichuyue * FExchangeRate  as QICHUYUE_LOCAL,  ");
        sb.append("              \t\t\t  benqiguihuan as BENQIHUANKUAN,benqiguihuan*FExchangeRate as BENQIHUANKUAN_LOCAL, ");
        sb.append("              \t\t\t  benqizengjia as BENQIZENJIA, benqizengjia * FExchangeRate  as BENQIZENJIA_LOCAL, ");
        sb.append("              \t\t\t  qimoyue as QIMOYUE, qimoyue * FExchangeRate as QIMOYUE_LOCAL, ");
        sb.append("               FLoanCompanyID, \n");
        sb.append("              FFinacingProductID, \n");
        sb.append("               FCurrencyID,fhorizonid \n");
        sb.append("          from (select FLoanCompanyID, \n");
        sb.append("           ( case when fhorizon <= 12 or fhorizon is null then 'shorthorizon' \n");
        sb.append("\t\t\t\t\t\telse 'longhorizon' \n");
        sb.append("\t\t\t\t\t end                  \n");
        sb.append("\t           ) as fhorizonid,             \n");
        sb.append("                      FFinacingProductID, \n");
        sb.append("                       FCurrencyID, \n");
        sb.append("                       fid, \n");
        sb.append("                       qichuyue, \n");
        sb.append("                       benqizengjia, \n");
        sb.append("                       benqiguihuan, \n");
        sb.append("                       FExchangeRate, \n");
        sb.append("                       (qichuyue + benqizengjia - benqiguihuan) as qimoyue \n");
        sb.append("                  from (select FLoanCompanyID,fhorizon, \n");
        sb.append("                               FFinacingProductID, \n");
        sb.append("                               FCurrencyID, \n");
        sb.append("                               fid, \n");
        sb.append("                               FExchangeRate, \n");
        sb.append("(                                         ");
        sb.append(" (select isnull(sum((case FIsHistoryLoan                     ");
        sb.append("  when 1 then FInitBalanceOfHistoryBill   ");
        sb.append("  else FLoanTotalAmt                      ");
        sb.append("  end                                     ");
        sb.append("  )),0) from t_ivt_chloan where FStartDate < {").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("}").append(" and fid = a.fid) -                                      ");
        sb.append("                               (select isnull(sum(FRepayAmt), 0) \n");
        sb.append("                                   from t_Ivt_Entrepaymentbill \n");
        sb.append("                                  where FRepayDate < {").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("} ");
        sb.append("                                    and FLoanBillIDID = a.fid)) as qichuyue, \n");
        StringBuffer sss = new StringBuffer("(case FIsHistoryLoan                     ");
        sss.append("  when 1 then FInitBalanceOfHistoryBill   ");
        sss.append("  else FLoanTotalAmt                      ");
        sss.append("  end                                     ");
        sss.append("  )");
        sb.append("                               (select isnull(sum( ").append(sss).append("), 0) \n");
        sb.append("                                  from t_ivt_chloan where \n");
        sb.append("  FStartDate <= { ").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("}");
        sb.append(" and FStartDate >= { ").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("} and fid = a.fid ) as benqizengjia,");
        sb.append("                               (select isnull(sum(FRepayAmt), 0) \n");
        sb.append("                                  from t_Ivt_Entrepaymentbill where \n");
        sb.append("   FRepayDate >= {").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("}  ");
        sb.append("  and  FRepayDate <= {").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("}  ");
        sb.append("                                  and FLoanBillIDID = a.fid) as benqiguihuan \n");
        sb.append("                          from t_ivt_chloan a \n");
        sb.append("                         where ").append(this.commonFilerToTimeDeposit).append(" ) aa ) bb ) cc\n");
        sb.append(" group by  ").append(this.groupByColum);
        sb.append(" having  sum(QICHUYUE_LOCAL)+sum(BENQIZENJIA_LOCAL)+sum(BENQIHUANKUAN_LOCAL)+sum(QIMOYUE_LOCAL)>0");
        return sb.toString();
    }

    public void setSchemaSource(Context ctx, SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSQLPrepared(), this.getSqlParams());
        ss.setDataItem("Horizon", this.getHorizonDataSQL(ctx), null);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        StringBuffer mdx = null;
        if (this.queryType.equals("by_company")) {
            sql.append("select com.FId as fid,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com \n");
            ss.setDataItem("LoanCompany", sql.toString(), null);
            this.configFile = "RptChLoanSum_LoanCompany.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"19_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append(" select {[Measures].members} on columns, FactMembersWithPCD(Horizon,LoanCompany) on rows from fm ");
        } else if (this.queryType.equals("by_loanProduct")) {
            sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_FIN_FinancingProducts as cur\n");
            ss.setDataItem("FinancingProduct", sql.toString(), null);
            this.configFile = "RptChLoanSum_FinancingProduct.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"20_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"21_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"14_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"123_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        } else if (this.queryType.equals("by_currency")) {
            sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", sql.toString(), null);
            this.configFile = "RptChLoanSum_Currency.xml";
            mdx = new StringBuffer("with ");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"23_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"24_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"14_RptChloanDetailHelper", (Locale)ctx.getLocale()));
            mdx.append("\n select  [Measures].members on columns,");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"124_RptChloanHelper", (Locale)ctx.getLocale()));
            mdx.append("\n from fm");
        }
        ss.setCaller(RptChLoanSumFacadeControllerBean.class);
        ss.setFilename(this.configFile);
        if (mdx != null) {
            ss.setMdx(mdx.toString());
        }
    }

    private String getHorizonDataSQL(Context ctx) {
        String sql = ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"17_RptChloanDetailHelper", (Locale)ctx.getLocale()) + " union all " + ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"18_RptChloanDetailHelper", (Locale)ctx.getLocale());
        return sql;
    }

    private String getSumSQLPrepared() {
        if (this.queryType.equals("by_company")) {
            this.groupByColum = " FLoanCompanyID ";
        } else if (this.queryType.equals("by_loanProduct")) {
            this.groupByColum = " FFinacingProductID ";
        } else if (this.queryType.equals("by_currency")) {
            this.groupByColum = " FCurrencyID ";
        }
        this.groupByColum = this.groupByColum + ",fhorizonid ";
        StringBuffer sb = new StringBuffer(1024);
        sb.append("select\t\t  sum(QICHUYUE_LOCAL)/").append(this.unit).append(" as FQICHUYUE_LOCAL, \n");
        sb.append("       sum(BENQIZENJIA_LOCAL)/").append(this.unit).append(" as FBENQIZENJIA_LOCAL, \n");
        sb.append("       sum(BENQIHUANKUAN_LOCAL)/").append(this.unit).append(" as FBENQIHUANKUAN_LOCAL, \n");
        sb.append("       sum(QIMOYUE_LOCAL)/").append(this.unit).append(" as FQIMOYUE_LOCAL,fhorizonid, \n");
        sb.append("       sum(QIMOYUE_LOCAL+BENQIZENJIA_LOCAL+BENQIHUANKUAN_LOCAL+QIMOYUE_LOCAL) as sum, \n");
        if (this.queryType.equals("by_company")) {
            sb.append(" FLoanCompanyID ");
        } else if (this.queryType.equals("by_loanProduct")) {
            sb.append(" FFinacingProductID ");
        } else if (this.queryType.equals("by_currency")) {
            sb.append(" FCurrencyID ");
        }
        sb.append("              from (select qichuyue as QICHUYUE,qichuyue * FExchangeRate  as QICHUYUE_LOCAL,  ");
        sb.append("              \t\t\t  benqiguihuan as BENQIHUANKUAN,benqiguihuan*FExchangeRate as BENQIHUANKUAN_LOCAL, ");
        sb.append("              \t\t\t  benqizengjia as BENQIZENJIA, benqizengjia * FExchangeRate  as BENQIZENJIA_LOCAL, ");
        sb.append("              \t\t\t  qimoyue as QIMOYUE, qimoyue * FExchangeRate as QIMOYUE_LOCAL, ");
        sb.append("               FLoanCompanyID, \n");
        sb.append("              FFinacingProductID, \n");
        sb.append("               FCurrencyID,fhorizonid \n");
        sb.append("          from (select FLoanCompanyID, \n");
        sb.append("           ( case when fhorizon <= 12 or fhorizon is null then 'shorthorizon' \n");
        sb.append("\t\t\t\t\t\telse 'longhorizon' \n");
        sb.append("\t\t\t\t\t end                  \n");
        sb.append("\t           ) as fhorizonid,             \n");
        sb.append("                      FFinacingProductID, \n");
        sb.append("                       FCurrencyID, \n");
        sb.append("                       fid, \n");
        sb.append("                       qichuyue, \n");
        sb.append("                       benqizengjia, \n");
        sb.append("                       benqiguihuan, \n");
        sb.append("                       FExchangeRate, \n");
        sb.append("                       (qichuyue + benqizengjia - benqiguihuan) as qimoyue \n");
        sb.append("                  from (select FLoanCompanyID,fhorizon, \n");
        sb.append("                               FFinacingProductID, \n");
        sb.append("                               FCurrencyID, \n");
        sb.append("                               fid, \n");
        sb.append("                               FExchangeRate, \n");
        sb.append("(                                         ");
        sb.append(" (select isnull(sum((case FIsHistoryLoan                     ");
        sb.append("  when 1 then FInitBalanceOfHistoryBill   ");
        sb.append("  else FLoanTotalAmt                      ");
        sb.append("  end                                     ");
        sb.append("  )),0) from t_ivt_chloan where FStartDate < ? ").append(" and fid = a.fid) -                                      ");
        sb.append("                               (select isnull(sum(FRepayAmt), 0) \n");
        sb.append("                                   from t_Ivt_Entrepaymentbill \n");
        sb.append("                                  where FRepayDate < ? ");
        sb.append("                                    and FLoanBillIDID = a.fid)) as qichuyue, \n");
        StringBuffer sss = new StringBuffer("(case FIsHistoryLoan                     ");
        sss.append("  when 1 then FInitBalanceOfHistoryBill   ");
        sss.append("  else FLoanTotalAmt                      ");
        sss.append("  end                                     ");
        sss.append("  )");
        sb.append("                               (select isnull(sum( ").append(sss).append("), 0) \n");
        sb.append("                                  from t_ivt_chloan where \n");
        sb.append("  FStartDate <= ? ");
        sb.append(" and FStartDate >= ? and fid = a.fid ) as benqizengjia,");
        sb.append("                               (select isnull(sum(FRepayAmt), 0) \n");
        sb.append("                                  from t_Ivt_Entrepaymentbill where \n");
        sb.append("   FRepayDate >= ?  ");
        sb.append("  and  FRepayDate <= ? ");
        sb.append("                                  and FLoanBillIDID = a.fid) as benqiguihuan \n");
        sb.append("                          from t_ivt_chloan a \n");
        sb.append("                         where ").append(this.getCommonFilterToChLoanPrepared()).append(" ) aa ) bb ) cc\n");
        sb.append(" group by  ").append(this.groupByColum);
        sb.append(" having  sum(QICHUYUE_LOCAL)+sum(BENQIZENJIA_LOCAL)+sum(BENQIHUANKUAN_LOCAL)+sum(QIMOYUE_LOCAL)>0");
        return sb.toString();
    }

    private SqlParams getSqlParams() {
        SqlParams sp = new SqlParams();
        Object[] allparams = this.getParams();
        for (int i = 0; i < allparams.length; ++i) {
            sp.addObject(allparams[i]);
        }
        return sp;
    }

    private Object[] getParams() {
        int i;
        Object[] fixParam = new Object[]{this.startDate, this.startDate, this.endDate, this.startDate, this.startDate, this.endDate, this.currentCompany.getId().toString()};
        Object[] currencyParam = null;
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            currencyParam = new Object[10];
            this.setCurrencyParam(currencyParam);
        }
        Object[] loanCompanyIDParam = null;
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            for (int i2 = 0; i2 < this.loanCompanyIDs.length; ++i2) {
                loanCompanyIDParam = new Object[this.getPlaceholderCount(this.loanCompanyIDs.length)];
                this.setLoanCompanyParam(loanCompanyIDParam);
            }
        }
        int currencyParamCount = currencyParam == null ? 0 : currencyParam.length;
        int loanCompanyIDParamCount = loanCompanyIDParam == null ? 0 : loanCompanyIDParam.length;
        Object[] allParam = new Object[fixParam.length + currencyParamCount + loanCompanyIDParamCount];
        int currentPos = 0;
        for (i = 0; i < fixParam.length; ++i) {
            allParam[i] = fixParam[i];
        }
        currentPos = fixParam.length;
        if (currencyParamCount > 0) {
            for (i = 0; i < currencyParam.length; ++i) {
                allParam[currentPos + i] = currencyParam[i];
            }
        }
        currentPos += currencyParamCount;
        if (loanCompanyIDParamCount > 0) {
            for (i = 0; i < loanCompanyIDParam.length; ++i) {
                allParam[currentPos + i] = loanCompanyIDParam[i];
            }
        }
        return allParam;
    }

    private void setLoanCompanyParam(Object[] loanCompanyIDParam) {
        int loanCompanyIDChoosedCount = this.loanCompanyIDs.length;
        for (int i = 0; i < this.loanCompanyIDs.length; ++i) {
            loanCompanyIDParam[i] = this.loanCompanyIDs[i].toString();
        }
        for (int j = 0; j < loanCompanyIDParam.length - loanCompanyIDChoosedCount; ++j) {
            loanCompanyIDParam[j + loanCompanyIDChoosedCount] = "";
        }
    }

    private void setCurrencyParam(Object[] currencyParam) {
        int currencyIDChoosedCount = this.currencyIDs.length;
        for (int i = 0; i < currencyIDChoosedCount; ++i) {
            currencyParam[i] = this.currencyIDs[i].toString();
        }
        for (int j = 0; j < 10 - currencyIDChoosedCount; ++j) {
            currencyParam[j + currencyIDChoosedCount] = "";
        }
    }

    private String getCommonFilterToChLoanPrepared() {
        StringBuffer sb = new StringBuffer();
        sb.append("( FEffectedStatus = 2 and fcompanyid = ? ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and ").append(this.getCurrencyPrepared());
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and ").append(this.getLoanCompanyPrepared(this.loanCompanyIDs));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getLoanCompanyPrepared(String[] loanCompanyIDs) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(loanCompanyIDs.length);
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" FLoanCompanyID = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private String getCurrencyPrepared() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            sb.append(" fcurrencyid = ? ");
            if (i == 9) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private int getPlaceholderCount(int i) {
        if (i <= 20) {
            return 20;
        }
        if (i > 20 && i <= 40) {
            return 40;
        }
        if (i > 40 && i <= 60) {
            return 60;
        }
        if (i > 60 && i <= 80) {
            return 80;
        }
        return i;
    }
}

