/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.app.MutexService;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.liquid.app.AbstractCapitalLiquidJobFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.DealCapitalDataRunnable;
import com.kingdee.eas.fm.liquid.app.DealFinancingDataRunnable;
import com.kingdee.eas.fm.liquid.app.DealInnerAcctDataRunnable;
import com.kingdee.eas.fm.liquid.app.DealLoanDataRunnable;
import com.kingdee.eas.fm.liquid.app.DealNtDataRunnable;
import com.kingdee.eas.fm.liquid.common.CapitalDetailHelper;
import com.kingdee.eas.fm.liquid.common.CapitalDistributionHelper;
import com.kingdee.eas.fm.liquid.common.CapitalStoreHelper;
import com.kingdee.eas.fm.liquid.common.CapitalTrendHelper;
import com.kingdee.eas.fm.liquid.common.CapitalWarningHelper;
import com.kingdee.eas.fm.liquid.common.FinancingDistributionHelper;
import com.kingdee.eas.fm.liquid.common.LoanDistributionHelper;
import com.kingdee.eas.fm.liquid.common.NtDistributionHelper;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class CapitalLiquidJobFacadeControllerBean
extends AbstractCapitalLiquidJobFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.CapitalLiquidJobFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _prepareCapitalData(Context ctx, String dealDate) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap map = MutexService.getInstance().getObjIDForUpdateList(ctx);
        if (map.containsKey("prepareCapitalData" + ctx.getAIS())) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u540e\u53f0\u4e8b\u52a1>>\u73b0\u6709\u4e8b\u52a1\u8fd8\u672a\u6267\u884c\u5b8c\u6210");
        }
        boolean isLock = iMutex.requestObjIDForUpdate("prepareCapitalData");
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String todayS = df.format(new Date());
            Date today = df.parse(todayS);
            if (!EmptyUtil.isEmpty((String)dealDate)) {
                today = df.parse(dealDate);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(today);
            calendar.add(5, -1);
            Date yesterday = calendar.getTime();
            if (!isLock) {
                throw new BOSException("\u8d44\u91d1\u6d1e\u5bdf:\u540e\u53f0\u4e8b\u52a1>>\u73b0\u6709\u4e8b\u52a1\u8fd8\u672a\u6267\u884c\u5b8c\u6210");
            }
            CurrencyCollection currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
            ExecutorService fixedThreadPool = Executors.newFixedThreadPool(20);
            this.dealCapitalData(ctx, yesterday, today, currencyCol, fixedThreadPool);
            this.dealInnerAcctData(ctx, yesterday, today, currencyCol, fixedThreadPool);
            this.dealLoanData(ctx, fixedThreadPool);
            this.dealFinancingData(ctx, fixedThreadPool);
            this.dealNtData(ctx, fixedThreadPool);
            fixedThreadPool.shutdown();
            boolean flag = true;
            while (flag) {
                if (fixedThreadPool.isTerminated()) {
                    flag = false;
                    if (isLock) {
                        iMutex.releaseObjIDForUpdate("prepareCapitalData");
                    }
                }
                Thread.sleep(30000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u540e\u53f0\u4e8b\u52a1>>\u5f02\u5e38\u8bb0\u5f55");
            logger.error((Object)e);
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate("prepareCapitalData");
            }
        }
    }

    private void dealCapitalData(Context ctx, Date yesterday, Date today, CurrencyCollection currencyCol, ExecutorService fixedThreadPool) throws BOSException {
        DealCapitalDataRunnable run;
        AccountBankInfo acctBankInfo;
        int i;
        DealCapitalDataRunnable run2;
        CompanyOrgUnitInfo orgInfo;
        int i2;
        String delete = " delete from T_LI_CapitalData where FBizDate= ? ";
        DbUtil.execute((Context)ctx, (String)delete, (Object[])new Object[]{new Timestamp(yesterday.getTime())});
        DbUtil.execute((Context)ctx, (String)delete, (Object[])new Object[]{new Timestamp(today.getTime())});
        CompanyOrgUnitCollection orgCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(this.getOrgFilterForCashAccountView());
        for (i2 = 0; i2 < orgCol.size(); ++i2) {
            orgInfo = orgCol.get(i2);
            run2 = new DealCapitalDataRunnable(ctx, orgInfo, currencyCol, yesterday);
            fixedThreadPool.execute(run2);
        }
        for (i2 = 0; i2 < orgCol.size(); ++i2) {
            orgInfo = orgCol.get(i2);
            run2 = new DealCapitalDataRunnable(ctx, orgInfo, currencyCol, today);
            fixedThreadPool.execute(run2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isClosed", (Object)false));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        for (i = 0; i < acctBankCol.size(); ++i) {
            acctBankInfo = acctBankCol.get(i);
            run = new DealCapitalDataRunnable(ctx, acctBankInfo, currencyCol, yesterday);
            fixedThreadPool.execute(run);
        }
        for (i = 0; i < acctBankCol.size(); ++i) {
            acctBankInfo = acctBankCol.get(i);
            run = new DealCapitalDataRunnable(ctx, acctBankInfo, currencyCol, today);
            fixedThreadPool.execute(run);
        }
    }

    private void dealInnerAcctData(Context ctx, Date yesterday, Date today, CurrencyCollection currencyCol, ExecutorService fixedThreadPool) throws BOSException {
        DealInnerAcctDataRunnable innerAcctRun;
        InnerAccountInfo innerAcctInfo;
        int i;
        String deleteInAcct = " delete from T_LI_InnerAcctBalance where FBizDate= ? ";
        DbUtil.execute((Context)ctx, (String)deleteInAcct, (Object[])new Object[]{new Timestamp(yesterday.getTime())});
        DbUtil.execute((Context)ctx, (String)deleteInAcct, (Object[])new Object[]{new Timestamp(today.getTime())});
        EntityViewInfo inView = new EntityViewInfo();
        SelectorItemCollection inSelector = new SelectorItemCollection();
        inSelector.add("id");
        inSelector.add("name");
        inSelector.add("number");
        inSelector.add("clearingHouse.id");
        inSelector.add("clearingHouse.openDate");
        inSelector.add("clearingHouse.settleDate");
        inSelector.add("company.id");
        inSelector.add("company.number");
        inSelector.add("applyUnit.id");
        FilterInfo inFilter = new FilterInfo();
        inFilter.getFilterItems().add(new FilterItemInfo("closed", (Object)false));
        inFilter.getFilterItems().add(new FilterItemInfo("type.property", (Object)1));
        inFilter.getFilterItems().add(new FilterItemInfo("type.property", (Object)2));
        inFilter.setMaskString("#0 AND (#1 OR #2)");
        inView.setSelector(inSelector);
        inView.setFilter(inFilter);
        InnerAccountCollection inAcctColl = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(inView);
        for (i = 0; i < inAcctColl.size(); ++i) {
            innerAcctInfo = inAcctColl.get(i);
            innerAcctRun = new DealInnerAcctDataRunnable(ctx, innerAcctInfo, currencyCol, yesterday);
            fixedThreadPool.execute(innerAcctRun);
        }
        for (i = 0; i < inAcctColl.size(); ++i) {
            innerAcctInfo = inAcctColl.get(i);
            innerAcctRun = new DealInnerAcctDataRunnable(ctx, innerAcctInfo, currencyCol, today);
            fixedThreadPool.execute(innerAcctRun);
        }
    }

    private void dealLoanData(Context ctx, ExecutorService fixedThreadPool) throws BOSException {
        String deleteLoan = " truncate table T_LI_LoanBalance";
        DbUtil.execute((Context)ctx, (String)deleteLoan);
        DealLoanDataRunnable loanRun = new DealLoanDataRunnable(ctx);
        fixedThreadPool.execute(loanRun);
    }

    private void dealFinancingData(Context ctx, ExecutorService fixedThreadPool) throws BOSException {
        String deleteFinancing = " truncate table T_LI_FinancingBalance";
        DbUtil.execute((Context)ctx, (String)deleteFinancing);
        DealFinancingDataRunnable financingRun = new DealFinancingDataRunnable(ctx);
        fixedThreadPool.execute(financingRun);
    }

    private void dealNtData(Context ctx, ExecutorService fixedThreadPool) throws BOSException {
        String deleteNt = " truncate table T_LI_NtBalance";
        DbUtil.execute((Context)ctx, (String)deleteNt);
        DealNtDataRunnable ntRun = new DealNtDataRunnable(ctx);
        fixedThreadPool.execute(ntRun);
    }

    @Override
    protected Map _getCapitalData(Context ctx, String queryId, String queryType, String currencyId, String unit, String desc, String payAmt, String recAmt) throws BOSException, EASBizException {
        CapitalStoreHelper storeHelper = new CapitalStoreHelper();
        CapitalDetailHelper detailHelper = new CapitalDetailHelper();
        Map<String, Object> result = new HashMap<String, Object>();
        Date today = new Date();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String todayS = df.format(new Date());
            today = df.parse(todayS);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("errorMsg", "\u8d44\u91d1\u6d1e\u5bdf>>\u83b7\u53d6\u6d41\u6c34\u65f6\u65e5\u671f\u8f6c\u6362\u51fa\u9519");
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u83b7\u53d6\u6d41\u6c34\u65f6\u65e5\u671f\u8f6c\u6362\u51fa\u9519");
            logger.error((Object)e);
            return result;
        }
        int unitValue = Integer.parseInt(unit);
        if (queryType.equals("homePage")) {
            result = storeHelper.getHomePageData(ctx, today, unitValue);
        }
        if (queryType.equals("storeInitData")) {
            result = storeHelper.getStoreInitData(ctx, today, unitValue);
        }
        if (queryType.equals("org")) {
            result = storeHelper.getOrgCapitalData(ctx, queryId, currencyId, today, unitValue, null, false);
        }
        if (queryType.equals("acctBankQuery")) {
            result = storeHelper.queryAcctBankStoreDataByAccId(ctx, queryId, currencyId, today, unitValue);
        }
        if (queryType.equals("acctBank")) {
            result = detailHelper.getAcctBankLiquidData(ctx, queryId, currencyId, today, today, unitValue, null, null, null);
        }
        if (queryType.equals("liquidDetailQuery")) {
            result = detailHelper.getAcctBankLiquidData(ctx, queryId, currencyId, today, today, unitValue, desc, payAmt, recAmt);
        }
        return result;
    }

    @Override
    protected Map _getCapitalDetailData(Context ctx, String queryId, String currencyId, Date startDate, Date endDate, String type, String unit, String desc, String payAmt, String recAmt) throws BOSException, EASBizException {
        CapitalDetailHelper detailHelper = new CapitalDetailHelper();
        Map<String, String> result = new HashMap();
        if (type.equals("liquidInitData")) {
            result = detailHelper.getLiquidInitData(ctx);
            return result;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String startDateS = df.format(startDate);
            startDate = df.parse(startDateS);
            String endDateS = df.format(endDate);
            endDate = df.parse(endDateS);
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", (String)((Object)Integer.valueOf(1)));
            result.put("errorMsg", "\u8d44\u91d1\u6d1e\u5bdf>>\u83b7\u53d6\u6d41\u6c34\u65f6\u65e5\u671f\u8f6c\u6362\u51fa\u9519");
            return result;
        }
        int unitValue = Integer.parseInt(unit);
        if (type.equals("org")) {
            result = detailHelper.getDataGroupByDateWithOrg(ctx, queryId, currencyId, startDate, endDate, unitValue);
        }
        if (type.equals("acctBank")) {
            result = detailHelper.getAcctBankSumDataWithDate(ctx, queryId, currencyId, startDate, unitValue);
        }
        if (type.equals("acctBankQuery")) {
            result = detailHelper.queryAcctBankLiquidDataByAccId(ctx, queryId, currencyId, startDate, endDate, unitValue);
        }
        if (type.equals("liquidDetail")) {
            result = detailHelper.getAcctBankLiquidData(ctx, queryId, currencyId, startDate, endDate, unitValue, null, null, null);
        }
        if (type.equals("liquidDetailQuery")) {
            result = detailHelper.getAcctBankLiquidData(ctx, queryId, currencyId, startDate, endDate, unitValue, desc, payAmt, recAmt);
        }
        return result;
    }

    private EntityViewInfo getOrgFilterForCashAccountView() {
        EntityViewInfo orgView = new EntityViewInfo();
        FilterInfo orgFilter = new FilterInfo();
        orgView.setFilter(orgFilter);
        FilterItemCollection orgItems = orgFilter.getFilterItems();
        orgItems.add(new FilterItemInfo("isLeaf", (Object)"1"));
        orgItems.add(new FilterItemInfo("ISFREEZE", (Object)"0"));
        orgItems.add(new FilterItemInfo("isSealUp", (Object)"0"));
        orgItems.add(new FilterItemInfo("accountTable", null, CompareType.NOTEQUALS));
        return orgView;
    }

    @Override
    protected Map _getDistributionData(Context ctx, String companyId, String currencyId, String searchType) throws BOSException, EASBizException {
        Map result = new HashMap();
        CapitalDistributionHelper helper = new CapitalDistributionHelper();
        if (searchType.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (searchType.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, currencyId);
        }
        if (searchType.equals("companySub")) {
            result = helper.getCompanySubData(ctx, companyId, currencyId);
        }
        return result;
    }

    @Override
    protected Map _getTrendData(Context ctx, String companyIds, String currencyId, String searchType) throws BOSException, EASBizException {
        Map result = new HashMap();
        CapitalTrendHelper helper = new CapitalTrendHelper();
        if (searchType.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (searchType.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyIds, currencyId);
        }
        return result;
    }

    @Override
    protected Map _getWarningData(Context ctx, String companyId, String currencyId, Date startDate, Date endDate, String type, String amount) throws BOSException, EASBizException {
        Map result = new HashMap();
        CapitalWarningHelper helper = new CapitalWarningHelper();
        if (type.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (type.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, currencyId, startDate, endDate, new BigDecimal(amount));
        }
        return result;
    }

    @Override
    protected Map _getWarningData(Context ctx, String companyId, String currencyId, Date startDate, Date endDate, String type) throws BOSException, EASBizException {
        Map result = new HashMap();
        CapitalWarningHelper helper = new CapitalWarningHelper();
        if (type.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (type.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, currencyId, startDate, endDate, BigDecimal.ZERO);
        }
        return result;
    }

    @Override
    protected Map _getCapitalCompanyData(Context ctx, String companyId, String currencyId, String unit, String orgIds, String isF7Query) throws BOSException, EASBizException {
        CapitalStoreHelper storeHelper = new CapitalStoreHelper();
        Map<String, Object> result = new HashMap<String, Object>();
        Date today = new Date();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String todayS = df.format(new Date());
            today = df.parse(todayS);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("errorMsg", "\u8d44\u91d1\u6d1e\u5bdf>>\u5f00\u542f\u53c2\u6570Zjdc001\u548cZjdc002\u67e5\u8be2\u51fa\u9519");
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f00\u542f\u53c2\u6570Zjdc001\u548cZjdc002\u67e5\u8be2\u51fa\u9519");
            logger.error((Object)e);
            return result;
        }
        int unitValue = Integer.parseInt(unit);
        result = storeHelper.getOrgCapitalData(ctx, companyId, currencyId, today, unitValue, orgIds, Boolean.valueOf(isF7Query));
        return result;
    }

    @Override
    protected Map _getLoanData(Context ctx, String companyId, String currencyId, String searchType, String unit) throws BOSException, EASBizException {
        Map result = new HashMap();
        int unitValue = Integer.parseInt(unit);
        LoanDistributionHelper helper = new LoanDistributionHelper();
        if (searchType.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (searchType.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, currencyId, unitValue);
        }
        if (searchType.equals("companySub")) {
            result = helper.getCompanySubData(ctx, companyId, currencyId, unitValue);
        }
        return result;
    }

    @Override
    protected Map _getFinancingData(Context ctx, String companyId, String currencyId, String searchType, String unit) throws BOSException, EASBizException {
        Map result = new HashMap();
        int unitValue = Integer.parseInt(unit);
        FinancingDistributionHelper helper = new FinancingDistributionHelper();
        if (searchType.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (searchType.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, currencyId, unitValue);
        }
        if (searchType.equals("companySub")) {
            result = helper.getCompanySubData(ctx, companyId, currencyId, unitValue);
        }
        return result;
    }

    @Override
    protected Map _getNtData(Context ctx, String companyId, String searchType, String unit) throws BOSException, EASBizException {
        Map result = new HashMap();
        int unitValue = Integer.parseInt(unit);
        NtDistributionHelper helper = new NtDistributionHelper();
        if (searchType.equals("init")) {
            result = helper.getInitData(ctx);
        }
        if (searchType.equals("queryData")) {
            result = helper.getDataByFilter(ctx, companyId, unitValue);
        }
        if (searchType.equals("companySub")) {
            result = helper.getCompanySubData(ctx, companyId, unitValue);
        }
        return result;
    }
}

