/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.app.AbstractLiquidFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LiquidFacadeControllerBean
extends AbstractLiquidFacadeControllerBean {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.LiquidFacadeControllerBean");
    static String detailTableNew = "t_Liquid_Balance";
    static String balanceTableNew = "t_Liquid_Balance";
    static String limitBalanceTable = "T_Liquid_CompanyLimitedBalance";
    static String detailTable = "v_Liquid_Detail";
    static String balanceTable = "v_Liquid_Balance";
    static String acctBankTable = "t_bd_accountbanks";
    static String companyTable = "T_ORG_Company";
    static String bankTable = "T_BD_Bank";
    static String stockItemTable = "t_liquid_stockitem";
    static String acctPropertyTable = "T_BD_AccountProperty";
    static String currencyTable = "T_BD_CURRENCY";
    static String safteyStockTable = "T_LI_CapitalReserves";
    static String accountViewTable = "t_bd_accountview";
    static String accountAndCurrencyTable = "T_BD_AccountCurrency";
    static String restrictedTable = "T_LI_RestrictedAccount";
    static String balanceCasTable = "T_cas_JournalBalance";
    static String detailCasTable = "t_cas_journal";
    static String currencyUsedTable = "T_Liquid_BalanceCurrency";

    @Override
    protected Map _getDetailsByAccounts(Context ctx, ArrayList acctParamList, Date beginDate, Date endDate) throws BOSException, EASBizException {
        boolean isNewMode = true;
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, AccountParam> detailResultMap = new HashMap<String, AccountParam>();
        Object[] acctIds = new String[acctParamList.size()];
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            acctIds[i] = acctParam.getAcctid();
        }
        String acctidInSql = FMHelper.buildIn((String)"FACCOUNTBANKID", (Object[])acctIds);
        StringBuffer detailSql = new StringBuffer();
        detailSql.append("select FACCOUNTBANKID,FTYPE,FCURRENCYID,sum(FDEBITAMOUNT) inAmount,sum(FCREDITAMOUNT) outAmount from ").append(isNewMode ? detailTableNew : detailTable).append("\n");
        detailSql.append("WHERE FBIZDATE >={ts'").append(LiquidAppConstants.sdf.format(beginDate.getTime())).append("'}\n");
        detailSql.append("  AND FBIZDATE <= {ts'").append(LiquidAppConstants.sdf.format(endDate.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            detailSql.append("  AND ").append(acctidInSql).append("\n");
        }
        detailSql.append("GROUP BY FACCOUNTBANKID,FTYPE,FCURRENCYID");
        logger.debug((Object)("detailSql:" + detailSql));
        HashMap<String, AccountParam> resultMap = new HashMap<String, AccountParam>();
        try {
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)detailSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setInAmount(rs.getBigDecimal("inAmount"));
                acctParam.setOutAmount(rs.getBigDecimal("outAmount"));
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, endDate);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                if (rs.getBigDecimal("inAmount") != null && exchangeRate != null) {
                    acctParam.setLocalInAmount(rs.getBigDecimal("inAmount").multiply(exchangeRate));
                } else {
                    acctParam.setLocalInAmount(BigDecimal.ZERO);
                }
                if (rs.getBigDecimal("outAmount") != null && exchangeRate != null) {
                    acctParam.setLocalOutAmount(rs.getBigDecimal("outAmount").multiply(exchangeRate));
                } else {
                    acctParam.setLocalOutAmount(BigDecimal.ZERO);
                }
                resultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            AccountParam dataAcctParam = (AccountParam)resultMap.get(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId());
            if (dataAcctParam != null) {
                acctParam.setInAmount(dataAcctParam.getInAmount());
                acctParam.setOutAmount(dataAcctParam.getOutAmount());
                acctParam.setLocalInAmount(dataAcctParam.getLocalInAmount());
                acctParam.setLocalOutAmount(dataAcctParam.getLocalOutAmount());
            } else {
                acctParam.setInAmount(BigDecimal.ZERO);
                acctParam.setOutAmount(BigDecimal.ZERO);
                acctParam.setLocalInAmount(BigDecimal.ZERO);
                acctParam.setLocalOutAmount(BigDecimal.ZERO);
            }
            detailResultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
        }
        return detailResultMap;
    }

    @Override
    protected Map _getBalancesByAccounts(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException {
        boolean isNewMode = true;
        if (isNewMode) {
            return this.getNewBalanceBack(ctx, acctParamList, date);
        }
        return this.getOldBalance(ctx, acctParamList, date);
    }

    private Map getNewBalance(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException, LiquidException {
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, AccountParam> balanceResultMap = new HashMap<String, AccountParam>();
        Object[] acctIds = new String[acctParamList.size()];
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            acctIds[i] = acctParam.getAcctid();
        }
        String acctidInSql = FMHelper.buildIn((String)"FACCOUNTBANKID", (Object[])acctIds);
        HashMap resultLessEqualsDateMap = new HashMap();
        StringBuffer balanceSql = new StringBuffer();
        Map initBalanceMap = this.getInitBalanceMap(ctx, date, (String[])acctIds, acctidInSql);
        Map detailMap = this.getDetailMap(ctx, date, (String[])acctIds, acctidInSql);
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            AccountParam initBalanceAcctParam = (AccountParam)initBalanceMap.get(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId());
            if (initBalanceAcctParam != null) {
                acctParam.setBizDate(initBalanceAcctParam.getBizDate());
            }
            BigDecimal detailAmount = this.getDetailAmount(acctParam, date, detailMap);
            if (initBalanceAcctParam != null) {
                BigDecimal initBalance = initBalanceAcctParam.getBalance();
                acctParam.setBalance(initBalance.add(detailAmount));
            } else {
                acctParam.setBalance(detailAmount);
            }
            BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(acctParam.getCurrencyId());
            if (exchangeRate == null) {
                exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, acctParam.getCurrencyId(), currentOrg, date);
                exchangeRateMap.put(acctParam.getCurrencyId(), exchangeRate);
            }
            if (exchangeRate != null) {
                acctParam.setLocalBalance(acctParam.getBalance().multiply(exchangeRate));
            } else {
                acctParam.setLocalBalance(BigDecimal.ZERO);
            }
            balanceResultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
        }
        return balanceResultMap;
    }

    private Map getNewBalanceBack(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException, LiquidException {
        StringBuffer balanceSql = new StringBuffer();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, AccountParam> balanceResultMap = new HashMap<String, AccountParam>();
        Object[] acctIds = new String[acctParamList.size()];
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            acctIds[i] = acctParam.getAcctid();
        }
        String acctidInSql = FMHelper.buildIn((String)"FACCOUNTBANKID", (Object[])acctIds);
        HashMap<String, AccountParam> resultLessEqualsDateMap = new HashMap<String, AccountParam>();
        balanceSql = this.getBalanceSqlBack(date, (String[])acctIds, acctidInSql);
        logger.debug((Object)("balanceSql:" + balanceSql));
        HashMap resultLessThanDateMap = new HashMap();
        try {
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)balanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, date);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                if (rs.getBigDecimal("FBALANCE") != null && exchangeRate != null) {
                    acctParam.setLocalBalance(rs.getBigDecimal("FBALANCE").multiply(exchangeRate));
                } else {
                    acctParam.setLocalBalance(BigDecimal.ZERO);
                }
                resultLessEqualsDateMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            AccountParam dataAcctParam = (AccountParam)resultLessEqualsDateMap.get(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId());
            if (dataAcctParam != null) {
                acctParam.setBalance(dataAcctParam.getBalance());
                acctParam.setLocalBalance(dataAcctParam.getLocalBalance());
            } else {
                acctParam.setBalance(BigDecimal.ZERO);
                acctParam.setLocalBalance(BigDecimal.ZERO);
            }
            balanceResultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
        }
        return balanceResultMap;
    }

    private BigDecimal getDetailAmount(AccountParam acctParam, Date endDate, Map detailMap) {
        BigDecimal detailAmount = BigDecimal.ZERO;
        Date beginDate = acctParam.getBizDate();
        String key = acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId();
        Map oneDetailMap = (Map)detailMap.get(key);
        if (oneDetailMap == null) {
            return detailAmount;
        }
        if (beginDate != null) {
            ArrayList betweenDays = LiquidFacadeHelper.getBetweenDay(beginDate, endDate);
            for (int i = 0; i < betweenDays.size(); ++i) {
                Date oneDay = (Date)betweenDays.get(i);
                AccountParam oneDetailAcctParam = (AccountParam)oneDetailMap.get(oneDay.toString());
                if (oneDetailAcctParam == null) continue;
                detailAmount = detailAmount.add(oneDetailAcctParam.getBalance());
            }
        } else {
            for (Map.Entry entry : oneDetailMap.entrySet()) {
                AccountParam oneDetailAcctParam = (AccountParam)entry.getValue();
                detailAmount = detailAmount.add(oneDetailAcctParam.getBalance());
            }
        }
        return detailAmount;
    }

    private Map getDetailMap(Context ctx, Date date, String[] acctIds, String acctidInSql) throws BOSException, EASBizException {
        HashMap detailMap = new HashMap();
        StringBuffer detailSql = new StringBuffer();
        detailSql.append("select  a.faccountbankid, a.fcurrencyid,  a.ftype, a.fbizdate,  sum(a.fdebitamount)-sum(a.fcreditamount) fbalance from  ").append("\n");
        detailSql.append(detailTable).append(" as a \n");
        detailSql.append("where  a.FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            detailSql.append("and ").append("\n");
            detailSql.append(acctidInSql).append("\n");
        }
        detailSql.append("group by  FAccountBankID,fcurrencyid,ftype , a.fbizdate").append("\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)detailSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                String key = acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId();
                Map oneDetailMap = detailMap.get(key) != null ? (Map)detailMap.get(key) : new HashMap();
                oneDetailMap.put(acctParam.getBizDate(), acctParam);
                detailMap.put(key, oneDetailMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return detailMap;
    }

    private Map getInitBalanceMap(Context ctx, Date date, String[] acctIds, String acctidInSql) throws BOSException, EASBizException {
        HashMap<String, AccountParam> initBalanceMap = new HashMap<String, AccountParam>();
        StringBuffer initBalanceSql = new StringBuffer();
        initBalanceSql.append("select  a.FAccountBankID,a.fcurrencyid,a.ftype,a.fbizdate,a.fbalance  from ").append(balanceTable).append(" as a ").append("\n");
        initBalanceSql.append("right join ").append("\n");
        initBalanceSql.append("(").append("\n");
        initBalanceSql.append("select FAccountBankID,fcurrencyid,ftype,max(fbizdate) as fbizdate from ").append(balanceTable).append("\n");
        initBalanceSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            initBalanceSql.append("and ").append("\n");
            initBalanceSql.append(acctidInSql).append("\n");
        }
        initBalanceSql.append("group by  FAccountBankID,fcurrencyid,ftype ").append("\n");
        initBalanceSql.append(") as b on a.FAccountBankID=b.FAccountBankID and a.fcurrencyid=b.fcurrencyid and a.ftype=b.ftype and a.fbizdate=b.fbizdate ").append("\n");
        logger.debug((Object)("initBalanceSql:" + initBalanceSql));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)initBalanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                initBalanceMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return initBalanceMap;
    }

    private Map getOldBalance(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException, LiquidException {
        StringBuffer balanceSql = new StringBuffer();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, AccountParam> balanceResultMap = new HashMap<String, AccountParam>();
        Object[] acctIds = new String[acctParamList.size()];
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            acctIds[i] = acctParam.getAcctid();
        }
        String acctidInSql = FMHelper.buildIn((String)"FACCOUNTBANKID", (Object[])acctIds);
        HashMap<String, AccountParam> resultLessEqualsDateMap = new HashMap<String, AccountParam>();
        balanceSql = this.getBalanceSql(date, (String[])acctIds, acctidInSql);
        logger.debug((Object)("balanceSql:" + balanceSql));
        HashMap resultLessThanDateMap = new HashMap();
        HashMap noBalanceMap = new HashMap();
        try {
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)balanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, date);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                if (rs.getBigDecimal("FBALANCE") != null && exchangeRate != null) {
                    acctParam.setLocalBalance(rs.getBigDecimal("FBALANCE").multiply(exchangeRate));
                } else {
                    acctParam.setLocalBalance(BigDecimal.ZERO);
                }
                resultLessEqualsDateMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            AccountParam dataAcctParam = (AccountParam)resultLessEqualsDateMap.get(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId());
            if (dataAcctParam != null) {
                acctParam.setBalance(dataAcctParam.getBalance());
                acctParam.setLocalBalance(dataAcctParam.getLocalBalance());
            } else {
                acctParam.setBalance(BigDecimal.ZERO);
                acctParam.setLocalBalance(BigDecimal.ZERO);
            }
            balanceResultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
        }
        return balanceResultMap;
    }

    private StringBuffer getBalanceSql(Date date, String[] acctIds, String acctidInSql) {
        StringBuffer balanceSql = new StringBuffer();
        StringBuffer hasBalanceSql = new StringBuffer();
        StringBuffer initBalanceSql = new StringBuffer();
        initBalanceSql.append("select  a.FAccountBankID,a.fcurrencyid,a.ftype,a.fbalance  from ").append(balanceTable).append(" as a ").append("\n");
        initBalanceSql.append("right join ").append("\n");
        initBalanceSql.append("(").append("\n");
        initBalanceSql.append("select FAccountBankID,fcurrencyid,ftype,max(fbizdate) as fbizdate from ").append(balanceTable).append("\n");
        initBalanceSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            initBalanceSql.append("and ").append("\n");
            initBalanceSql.append(acctidInSql).append("\n");
        }
        initBalanceSql.append("group by  FAccountBankID,fcurrencyid,ftype ").append("\n");
        initBalanceSql.append(") as b on a.FAccountBankID=b.FAccountBankID and a.fcurrencyid=b.fcurrencyid and a.ftype=b.ftype and a.fbizdate=b.fbizdate ").append("\n");
        StringBuffer detailSql = new StringBuffer();
        detailSql.append("select  a.faccountbankid, a.fcurrencyid,  a.ftype,  sum(a.fdebitamount)-sum(a.fcreditamount) fbalance from  ").append("\n");
        detailSql.append("( ").append("\n");
        detailSql.append("select fcompanyid, faccountbankid, fcurrencyid, fbizdate, fdebitamount,fcreditamount, ftype from ").append(detailTable).append("\n");
        detailSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            detailSql.append("and ").append("\n");
            detailSql.append(acctidInSql).append("\n");
        }
        detailSql.append(") a").append("\n");
        detailSql.append("inner join  ").append("\n");
        detailSql.append("( ").append("\n");
        detailSql.append("select FAccountBankID,fcurrencyid,ftype,max(fbizdate) as fbizdate from ").append(balanceTable).append("\n");
        detailSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            detailSql.append("and ").append("\n");
            detailSql.append(acctidInSql).append("\n");
        }
        detailSql.append("group by  FAccountBankID,fcurrencyid,ftype ").append("\n");
        detailSql.append(") b on  a.faccountbankid=b.faccountbankid and a.fcurrencyid=b.fcurrencyid and a.ftype=b.ftype and a.fbizdate>b.fbizdate ").append("\n");
        detailSql.append("group by    a.faccountbankid, a.fcurrencyid , a.ftype ").append("\n");
        hasBalanceSql.append("select  c.FAccountBankID,c.ftype,c.fcurrencyid,sum(fbalance) fbalance  from ").append("\n");
        hasBalanceSql.append("(").append("\n");
        hasBalanceSql.append(initBalanceSql).append("\n");
        hasBalanceSql.append("  union all ").append("\n");
        hasBalanceSql.append(detailSql).append("\n");
        hasBalanceSql.append(") c ").append("\n");
        hasBalanceSql.append("group by c.FAccountBankID,c.ftype,c.fcurrencyid ").append("\n");
        StringBuffer balanceIsNullDateSql = new StringBuffer();
        balanceIsNullDateSql.append("select FACCOUNTBANKID, FTYPE,FCURRENCYID,isnull(SUM(FDEBITAMOUNT)-SUM(FCREDITAMOUNT),0) FBALANCE FROM ").append("\n");
        balanceIsNullDateSql.append(detailTable).append(" e \n");
        balanceIsNullDateSql.append("where not exists  ").append("\n");
        balanceIsNullDateSql.append(" (select 1 from  ").append(balanceTable).append(" f where f.FACCOUNTBANKID=e.FACCOUNTBANKID  ").append("\n");
        balanceIsNullDateSql.append("   AND f.ftype=e.ftype and f.Fcurrencyid=e.Fcurrencyid ) ").append("\n");
        balanceIsNullDateSql.append("and e.FBIZDATE<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            balanceIsNullDateSql.append("  and ").append(acctidInSql).append("\n");
        }
        balanceIsNullDateSql.append("group by  FACCOUNTBANKID,FTYPE,FCURRENCYID ").append("\n");
        balanceIsNullDateSql.append("").append("\n");
        balanceSql.append(hasBalanceSql).append("\n");
        balanceSql.append("union all ").append("\n");
        balanceSql.append(balanceIsNullDateSql);
        return balanceSql;
    }

    private StringBuffer getBalanceSqlBack(Date date, String[] acctIds, String acctidInSql) {
        StringBuffer initBalanceSql = new StringBuffer();
        initBalanceSql.append("select  a.FAccountBankID,a.fcurrencyid,a.ftype,a.fbalance  from ").append(balanceTableNew).append(" as a ").append("\n");
        initBalanceSql.append("where  FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctIds.length > 0) {
            initBalanceSql.append("and ").append("\n");
            initBalanceSql.append(acctidInSql).append("\n");
        }
        return initBalanceSql;
    }

    @Override
    protected IRowSet _getAccountsInfomation(Context ctx, Map paramMap) throws BOSException, EASBizException {
        StringBuffer acctInfoSql = this.getAcctInfoSql(ctx, paramMap);
        StringBuffer acctFilterSql = this.getAcctFilterSql(ctx, paramMap);
        String acctSql = acctInfoSql.append(acctFilterSql).toString();
        acctSql = acctSql + "\n  order by " + "FBankNumber" + "," + "FAccountBankNumber";
        logger.debug((Object)("getAccountsInfomation:" + acctSql));
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)acctSql);
        IRowSet irs = exec.executeSQL();
        return irs;
    }

    private StringBuffer getAcctInfoSql(Context ctx, Map paramMap) {
        StringBuffer acctAndCurrencySql = this.getAcctAndCurrencySql(paramMap);
        String isReturnNoAcctCompany = "true";
        Object value = paramMap.get("isReturnNoAcctCompany");
        if (value != null) {
            isReturnNoAcctCompany = (String)value;
        }
        StringBuffer acctInfoSql = new StringBuffer();
        acctInfoSql.append("select").append("\n");
        acctInfoSql.append("  ACCOUNTBANK .fid as  ").append("FAccountBankId").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK .fname_l2 as  ").append("FAccountBankName").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK .FBankAccountNumber as  ").append("FBankAccountNumber").append("\n");
        acctInfoSql.append(",  isnull(ACCOUNTBANK.FNumber,'ZZZZZZ') AS  ").append("FAccountBankNumber").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK.FCURRENCYID AS   ").append("FCurrencyId").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK.Fcurrencyname AS   ").append("FCurrencyName").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK.FcurrencyISOCode AS   ").append("FISOCode").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK.FcurrencyNumber AS   ").append("FCurrencyNumber").append("\n");
        acctInfoSql.append(",  ACCOUNTBANK.acct_currency_type AS   ").append("acct_currency_type").append("\n");
        acctInfoSql.append(", COMPANY .FID AS   ").append("FCompanyId").append("\n");
        acctInfoSql.append(", COMPANY .FPARENTID AS   ").append("FCompanyParentId").append("\n");
        acctInfoSql.append(", COMPANY .FName_l2 AS   ").append("FCompanyName").append("\n");
        acctInfoSql.append(", COMPANY .FIsLeaf AS   ").append("FCompanyIsLeaf").append("\n");
        acctInfoSql.append(", COMPANY .FLongNumber AS    ").append("FCompanyLongNumber").append("\n");
        acctInfoSql.append(", COMPANY .FLevel AS   ").append("FCompanyLevel").append("\n");
        acctInfoSql.append(", isnull(BANK.FID,'").append("cash0000").append("') AS   ").append("FBankId").append("\n");
        String cashBankName = ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"7_LiquidConstant", (Locale)ctx.getLocale());
        acctInfoSql.append(", isnull(BANK.FName_l2,'").append(cashBankName).append("') AS   ").append("FBankName").append("\n");
        acctInfoSql.append(", isnull(BANK.FNumber,'ZZZZZZZ') AS   ").append("FBankNumber").append("\n");
        acctInfoSql.append(", PROPERTY .FName_l2 AS   ").append("FPropertyName").append("\n");
        acctInfoSql.append(", PROPERTY .FNumber AS   ").append("FPropertyNumber").append("\n");
        acctInfoSql.append(",'' AS ").append("FQueryCycleId").append("\n");
        acctInfoSql.append(",'' AS ").append("FQueryCycleName").append("\n");
        acctInfoSql.append(",'' AS ").append("FQueryCycleBeginDate").append("\n");
        acctInfoSql.append(",'' AS ").append("FQueryCycleEndDate").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FBeginingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FIncomeAmount").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FOutcomeAmount").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FEndingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalBeginingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalIncomeAmount").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalOutcomeAmount").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalEndingBalance").append("\n");
        acctInfoSql.append(", isnull(FISSETBANKINTERFACE,'0') AS  FISSETBANKINTERFACE").append("\n");
        acctInfoSql.append("from (").append(acctAndCurrencySql).append(") AS  ACCOUNTBANK ").append("\n");
        if (isReturnNoAcctCompany.equals("true")) {
            acctInfoSql.append("RIGHT OUTER JOIN ").append(companyTable).append(" AS  COMPANY ").append("\n");
        } else {
            acctInfoSql.append("left OUTER JOIN ").append(companyTable).append(" AS  COMPANY ").append("\n");
        }
        acctInfoSql.append("ON  ACCOUNTBANK .FCompanyID =  COMPANY .FID").append("\n");
        acctInfoSql.append("LEFT OUTER JOIN ").append(bankTable).append("  AS  BANK ").append("\n");
        acctInfoSql.append("ON  ACCOUNTBANK .FBank =  BANK .FID").append("\n");
        acctInfoSql.append("LEFT OUTER JOIN ").append(acctPropertyTable).append("  AS  PROPERTY ").append("\n");
        acctInfoSql.append("ON  ACCOUNTBANK .FPropertyId =  PROPERTY .FID").append("\n");
        acctInfoSql.append("LEFT OUTER JOIN ").append(currencyTable).append("  AS  CURRENCY ").append("\n");
        acctInfoSql.append("ON  ACCOUNTBANK .FCURRENCYID =  CURRENCY.FID").append("\n");
        acctInfoSql.append("Where 0=0 ").append("\n");
        return acctInfoSql;
    }

    private StringBuffer getAcctAndCurrencySql(Map paramMap) {
        String isIncludeBank = "true";
        Object value = paramMap.get("isIncludeBank");
        if (value != null) {
            isIncludeBank = (String)value;
        }
        String isIncludeCash = "true";
        value = paramMap.get("isIncludeCash");
        if (value != null) {
            isIncludeCash = (String)value;
        }
        StringBuffer acctAndCurrencySql = new StringBuffer();
        if (isIncludeBank.equals("true")) {
            acctAndCurrencySql.append("select ").append("\n");
            acctAndCurrencySql.append("  ACCOUNTBANK .fid as fid ").append("\n");
            acctAndCurrencySql.append(",ACCOUNTBANK .FCompanyID   ").append("\n");
            acctAndCurrencySql.append(", ACCOUNTBANK .FBank as fbank ").append("\n");
            acctAndCurrencySql.append(",ACCOUNTBANK .FPropertyId  as FPropertyId").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .fname_l2 ").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .FBankAccountNumber as FBankAccountNumber ").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .FNumber").append("\n");
            acctAndCurrencySql.append(",  CURRENCY.FID AS  FCURRENCYID ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.Fname_l2 AS Fcurrencyname ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.FISOCode AS FcurrencyISOCode  ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.Fnumber AS FcurrencyNumber ").append("\n");
            acctAndCurrencySql.append(", '").append("singleCurrency").append("' AS ").append("acct_currency_type").append("\n");
            acctAndCurrencySql.append(", ACCOUNTBANK.FISSETBANKINTERFACE AS FISSETBANKINTERFACE").append("\n");
            acctAndCurrencySql.append("from  ").append(acctBankTable).append("  AS  ACCOUNTBANK  ").append("\n");
            acctAndCurrencySql.append(" JOIN ").append(currencyTable).append("   AS  CURRENCY  ").append("\n");
            acctAndCurrencySql.append("ON  ACCOUNTBANK .FCURRENCYID =  CURRENCY.FID ").append("\n");
            acctAndCurrencySql.append(" where  CURRENCY.FID <> '11111111-1111-1111-1111-111111111111DEB58FDC' AND CURRENCY.FID <> '22222222-2222-2222-2222-222222222222DEB58FDC'").append("\n");
            acctAndCurrencySql.append(" and  CURRENCY.FDeletedStatus=1 ").append("\n");
            acctAndCurrencySql.append("union ").append("\n");
            acctAndCurrencySql.append("select ").append("\n");
            acctAndCurrencySql.append("  ACCOUNTBANK .fid as fid").append("\n");
            acctAndCurrencySql.append(",ACCOUNTBANK .FCompanyID  ").append("\n");
            acctAndCurrencySql.append(", ACCOUNTBANK .FBank  as fbank ").append("\n");
            acctAndCurrencySql.append(",ACCOUNTBANK .FPropertyId  as FPropertyId ").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .fname_l2  ").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .FBankAccountNumber as FBankAccountNumber ").append("\n");
            acctAndCurrencySql.append(",  ACCOUNTBANK .FNumber").append("\n");
            acctAndCurrencySql.append(",  CURRENCY.FID AS  FCURRENCYID ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.Fname_l2 AS Fcurrencyname ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.FISOCode AS FcurrencyISOCode ").append("\n");
            acctAndCurrencySql.append(", CURRENCY.Fnumber AS FcurrencyNumber ").append("\n");
            acctAndCurrencySql.append(", '").append("mutilCurrency").append("' AS ").append("acct_currency_type").append("\n");
            acctAndCurrencySql.append(", ACCOUNTBANK.FISSETBANKINTERFACE AS FISSETBANKINTERFACE").append("\n");
            acctAndCurrencySql.append("from  ").append(acctBankTable).append(" AS  ACCOUNTBANK  ").append("\n");
            acctAndCurrencySql.append("cross JOIN ").append(currencyTable).append("   AS  CURRENCY  ").append("\n");
            acctAndCurrencySql.append("where ACCOUNTBANK.FCURRENCYID is null ").append("\n");
            acctAndCurrencySql.append(" and  CURRENCY.FID <> '11111111-1111-1111-1111-111111111111DEB58FDC' AND CURRENCY.FID <> '22222222-2222-2222-2222-222222222222DEB58FDC'").append("\n");
            acctAndCurrencySql.append("and  CURRENCY.FDeletedStatus=1 ").append("\n");
            acctAndCurrencySql.append("and exists (select * from ").append(currencyUsedTable).append(" liquidBalance where  currency.fid=liquidBalance.fcurrencyid) ").append("\n");
        }
        if (isIncludeCash.equals("true")) {
            StringBuffer cashSql = new StringBuffer();
            StringBuffer cashNoCurrency = new StringBuffer();
            cashNoCurrency.append(" select  acctview.fid as fid ,acctview.fcompanyid,'' as fbank,'' as FPropertyId, acctview.fname_l2 ").append("\n");
            cashNoCurrency.append(" ,acctview.fnumber as FBankAccountNumber,null as fnumber,currency.fid as FCURRENCYID ,currency.fname_l2  as  Fcurrencyname ,CURRENCY.FISOCode AS FcurrencyISOCode , CURRENCY.Fnumber AS FcurrencyNumber ").append("\n");
            cashNoCurrency.append(", '").append("singleCurrency").append("' AS ").append("acct_currency_type").append("\n");
            cashNoCurrency.append(",0 as FISSETBANKINTERFACE").append("\n");
            cashNoCurrency.append(" from  ");
            cashNoCurrency.append("(").append("\n");
            cashNoCurrency.append("select acctview.fid,acctview.fcompanyid,acctview.fname_l2").append("\n");
            cashNoCurrency.append(",acctview.fnumber,acctview.faccounttableid,company.FBaseCurrencyID from ").append(accountViewTable).append(" acctview").append("\n");
            cashNoCurrency.append("inner join ").append(companyTable).append("  company on company.fiD=acctview.Fcompanyid and company.FAccountTableID=acctview.FAccountTableID").append("\n");
            cashNoCurrency.append("where  acctview.fisLeaf = '1' AND acctview.fisCash = '1' and acctview.FAcctCurrency=0").append("\n");
            cashNoCurrency.append(" ) acctview").append("\n");
            cashNoCurrency.append(" left join ").append(currencyTable).append("   currency on acctview.FBaseCurrencyID=currency.fid").append("\n");
            cashNoCurrency.append(" where  CURRENCY.FID <> '11111111-1111-1111-1111-111111111111DEB58FDC' AND CURRENCY.FID <> '22222222-2222-2222-2222-222222222222DEB58FDC'").append("\n");
            cashNoCurrency.append(" and  CURRENCY.FDeletedStatus=1 ").append("\n");
            StringBuffer cashOneCurrency = new StringBuffer();
            cashOneCurrency.append(" select  acctview.fid as fid ,acctview.fcompanyid,'' as fbank,'' as FPropertyId, acctview.fname_l2 ").append("\n");
            cashOneCurrency.append(" ,acctview.fnumber as FBankAccountNumber,null as fnumber,currency.fid as FCURRENCYID ,currency.fname_l2  as  Fcurrencyname ,CURRENCY.FISOCode AS FcurrencyISOCode , CURRENCY.Fnumber AS FcurrencyNumber ").append("\n");
            cashOneCurrency.append(", '").append("specificCurrency").append("' AS ").append("acct_currency_type").append("\n");
            cashOneCurrency.append(",0 as FISSETBANKINTERFACE").append("\n");
            cashOneCurrency.append(" from  ");
            cashOneCurrency.append("(").append("\n");
            cashOneCurrency.append("select acctview.fid,acctview.fcompanyid,acctview.fname_l2").append("\n");
            cashOneCurrency.append(",acctview.fnumber,acctview.faccounttableid from ").append(accountViewTable).append(" acctview").append("\n");
            cashOneCurrency.append("inner join ").append(companyTable).append("  company on company.fiD=acctview.Fcompanyid and company.FAccountTableID=acctview.FAccountTableID").append("\n");
            cashOneCurrency.append("where  acctview.fisLeaf = '1' AND acctview.fisCash = '1' and acctview.FAcctCurrency=1").append("\n");
            cashOneCurrency.append(" ) acctview").append("\n");
            cashOneCurrency.append(" inner join ").append(accountAndCurrencyTable).append("   accountCurrency on accountCurrency.faccountviewid=acctview.fid ").append("\n");
            cashOneCurrency.append(" inner join ").append(currencyTable).append("    currency on currency.fid =accountCurrency.fcurrencyid ").append("\n");
            cashOneCurrency.append(" where  CURRENCY.FDeletedStatus=1 ").append("\n");
            cashOneCurrency.append("and exists (select * from ").append(currencyUsedTable).append(" liquidBalance where  currency.fid=liquidBalance.fcurrencyid) ").append("\n");
            StringBuffer cashAllCurrency = new StringBuffer();
            cashAllCurrency.append(" select  acctview.fid as fid ,acctview.fcompanyid,'' as fbank,'' as FPropertyId, acctview.fname_l2 ").append("\n");
            cashAllCurrency.append(" ,acctview.fnumber as FBankAccountNumber,null as fnumber,currency.fid as FCURRENCYID ,currency.fname_l2  as  Fcurrencyname ,CURRENCY.FISOCode AS FcurrencyISOCode , CURRENCY.Fnumber AS FcurrencyNumber ").append("\n");
            cashAllCurrency.append(", '").append("mutilCurrency").append("' AS ").append("acct_currency_type").append("\n");
            cashAllCurrency.append(",0 as FISSETBANKINTERFACE").append("\n");
            cashAllCurrency.append(" from  ");
            cashAllCurrency.append("(").append("\n");
            cashAllCurrency.append("select acctview.fid,acctview.fcompanyid,acctview.fname_l2").append("\n");
            cashAllCurrency.append(",acctview.fnumber,acctview.faccounttableid from ").append(accountViewTable).append(" acctview").append("\n");
            cashAllCurrency.append("inner join ").append(companyTable).append("  company on company.fiD=acctview.Fcompanyid and company.FAccountTableID=acctview.FAccountTableID").append("\n");
            cashAllCurrency.append("where  acctview.fisLeaf = '1' AND acctview.fisCash = '1' and acctview.FAcctCurrency=2").append("\n");
            cashAllCurrency.append(" ) acctview").append("\n");
            cashAllCurrency.append(" cross join  ").append(currencyTable).append("  currency ").append("\n");
            cashAllCurrency.append(" where  CURRENCY.FID <> '11111111-1111-1111-1111-111111111111DEB58FDC' AND CURRENCY.FID <> '22222222-2222-2222-2222-222222222222DEB58FDC'").append("\n");
            cashAllCurrency.append(" and  CURRENCY.FDeletedStatus=1 ").append("\n");
            cashAllCurrency.append("and exists (select * from ").append(currencyUsedTable).append(" liquidBalance where  currency.fid=liquidBalance.fcurrencyid) ").append("\n");
            cashSql.append(cashNoCurrency).append(" union ").append("\n");
            cashSql.append(cashOneCurrency).append(" union ").append("\n");
            cashSql.append(cashAllCurrency);
            if (acctAndCurrencySql.length() != 0) {
                acctAndCurrencySql.append(" union ").append("\n").append(cashSql);
            } else {
                acctAndCurrencySql.append("\n").append(cashSql);
            }
        }
        return acctAndCurrencySql;
    }

    private StringBuffer getAcctFilterSql(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String isIncludeInnerBank;
        String isIncludeSealCompany;
        CharSequence inSql;
        Set idSet;
        StringBuffer acctFilterSql = new StringBuffer();
        Object value = paramMap.get("companyIdSet");
        if (value != null) {
            idSet = (Set)value;
            inSql = FMHelper.setTran2String((Set)idSet);
            acctFilterSql.append(" AND COMPANY.FID in ").append((String)inSql);
        }
        if ((value = paramMap.get("isIncludeSealCompany")) != null && (isIncludeSealCompany = (String)value).equals("false")) {
            acctFilterSql.append("  and ( COMPANY.fisSealUp = 0  ) ");
        }
        if ((value = paramMap.get("bankIdSet")) != null) {
            idSet = (Set)value;
            inSql = FMHelper.setTran2String((Set)idSet);
            acctFilterSql.append(" AND (BANK.FID in ").append((String)inSql).append(" OR BANK.FID IS NULL) ");
        }
        if ((value = paramMap.get("currencyIdSet")) != null) {
            String inSql2 = FMHelper.setTran2String((Set)((Set)value));
            acctFilterSql.append("  AND (ACCOUNTBANK.FCURRENCYID in ").append(inSql2).append(" OR ACCOUNTBANK.FCURRENCYID IS NULL) ");
        }
        if ((value = paramMap.get("parentBankId")) != null) {
            String parentBankId = (String)value;
            inSql = new StringBuffer();
            ((StringBuffer)inSql).append("(select fid  from ").append(bankTable).append(" where flongnumber like ").append("\n");
            ((StringBuffer)inSql).append(" (select CONCAT(flongnumber,'!%') from ").append(bankTable).append(" where fid='").append(parentBankId).append("'))");
            acctFilterSql.append("  AND ( BANK.FID in ").append((StringBuffer)inSql);
            acctFilterSql.append("  or BANK.FID = '").append(parentBankId).append("' OR BANK.FID IS NULL)  ");
        }
        if ((value = paramMap.get("isIncludeInnerBank")) != null && (isIncludeInnerBank = (String)value).equals("false")) {
            acctFilterSql.append("  and ( BANK.FIsInGroup = 0 or BANK.FIsInGroup is null ) ");
        }
        if ((value = paramMap.get("parentCompanyId")) != null) {
            String parentCompanyId = (String)value;
            inSql = LiquidFacadeHelper.getAllCompanyById(parentCompanyId);
            acctFilterSql.append("  AND ( COMPANY.FID in ").append((String)inSql);
            acctFilterSql.append("  or COMPANY.FID = '").append(parentCompanyId).append("')");
        }
        if ((value = paramMap.get("accountBankIds")) != null) {
            idSet = (Set)value;
            inSql = FMHelper.setTran2String((Set)idSet);
            acctFilterSql.append(" AND (ACCOUNTBANK.FID in ").append((String)inSql).append(" OR ACCOUNTBANK.FID IS NULL) ");
        }
        if ((value = paramMap.get("isFromProcess")) == null) {
            value = paramMap.get("isFromPc");
            if (value != null) {
                LiquidFacadeHelper.getPermissionCompanySql(ctx, acctFilterSql, true);
            } else {
                LiquidFacadeHelper.getPermissionCompanySql(ctx, acctFilterSql, false);
            }
        }
        return acctFilterSql;
    }

    @Override
    protected IRowSet _getLoanBalance(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLimitBalanceByAccounts(Context ctx, ArrayList acctParamList, Date date) throws BOSException, EASBizException {
        boolean isNewMode = true;
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, AccountParam> restrictedResultMap = new HashMap<String, AccountParam>();
        Object[] acctIds = new String[acctParamList.size()];
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            acctIds[i] = acctParam.getAcctid();
        }
        String acctidInSql = FMHelper.buildIn((String)"FACCOUNTBANKID", (Object[])acctIds);
        String restrictedAcctidInSql = FMHelper.buildIn((String)"restrictedAccount.FACCOUNTBANKID", (Object[])acctIds);
        StringBuffer dateRestrictedSql = new StringBuffer();
        dateRestrictedSql.append("select FAccountBankID,FCurrencyId, '").append("1").append("' ftype").append(" ,FAmount from ").append(restrictedTable).append("  a ").append("\n");
        dateRestrictedSql.append(" where  FRESTRICTEDTYPE =1 ").append("\n");
        dateRestrictedSql.append(" and FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("and (not exists (select 1 from  ").append(restrictedTable).append(" b where A.FACCOUNTBANKID=B.FACCOUNTBANKID  and  A.FCurrencyId=B.FCurrencyId ").append("\n");
        dateRestrictedSql.append("         AND  b.FStartDate>a.FStartDate  AND b.FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("     ))").append("\n");
        dateRestrictedSql.append(" and ( fendDate>={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("      or fendDate is null ) \n");
        if (acctIds.length > 0) {
            dateRestrictedSql.append(" and ").append(acctidInSql).append("\n");
        }
        StringBuffer noDateRestrictedSql = new StringBuffer();
        StringBuffer balanceSql = null;
        balanceSql = isNewMode ? this.getBalanceSqlBack(date, (String[])acctIds, acctidInSql) : this.getBalanceSql(date, (String[])acctIds, acctidInSql);
        noDateRestrictedSql.append("select restrictedAccount.FAccountBankID ,restrictedAccount.FCurrencyId ,isnull(d.Ftype,1) ftype,case when d.FBALANCE>0 then d.FBALANCE else 0 end FBALANCE from ").append(restrictedTable).append("  restrictedAccount ").append("\n");
        noDateRestrictedSql.append("left join ").append("\n");
        noDateRestrictedSql.append(" ( ").append("\n");
        noDateRestrictedSql.append(balanceSql);
        noDateRestrictedSql.append(") d on d.FACCOUNTBANKID=restrictedAccount.FAccountBankID and d.FcurrencyID=restrictedAccount.FcurrencyID ").append("\n");
        noDateRestrictedSql.append(" where  FRESTRICTEDTYPE =0 ").append("\n");
        noDateRestrictedSql.append(" and ").append("\n");
        noDateRestrictedSql.append(" (( FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}").append("  and fendDate>={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'})\n");
        noDateRestrictedSql.append("       or ( FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}").append("       and fendDate is null )\n");
        noDateRestrictedSql.append(" )").append("\n");
        if (acctIds.length > 0) {
            noDateRestrictedSql.append(" and ").append(restrictedAcctidInSql).append("\n");
        }
        StringBuffer restrictedSql = new StringBuffer();
        restrictedSql.append(dateRestrictedSql);
        restrictedSql.append(" union ").append("\n");
        restrictedSql.append(noDateRestrictedSql);
        HashMap<String, AccountParam> restrictedDateAmountMap = new HashMap<String, AccountParam>();
        logger.debug((Object)("getLimitBalanceByAccounts:" + restrictedSql));
        try {
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)restrictedSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE") != null ? rs.getString("FTYPE") : "1");
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setLimitAmount(rs.getBigDecimal("FAmount"));
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, date);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                if (rs.getBigDecimal("FAmount") != null && exchangeRate != null) {
                    acctParam.setLocalLimitAmount(rs.getBigDecimal("FAmount").multiply(exchangeRate));
                }
                restrictedDateAmountMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < acctParamList.size(); ++i) {
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            AccountParam dataAcctParam = (AccountParam)restrictedDateAmountMap.get(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId());
            if (dataAcctParam != null) {
                if (dataAcctParam.getLimitAmount() != null) {
                    acctParam.setLimitAmount(dataAcctParam.getLimitAmount());
                    acctParam.setLocalLimitAmount(dataAcctParam.getLocalLimitAmount());
                } else {
                    acctParam.setLimitAmount(BigDecimal.ZERO);
                    acctParam.setLocalLimitAmount(BigDecimal.ZERO);
                }
            } else {
                acctParam.setLimitAmount(BigDecimal.ZERO);
                acctParam.setLocalLimitAmount(BigDecimal.ZERO);
            }
            restrictedResultMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
        }
        return restrictedResultMap;
    }

    @Override
    protected IRowSet _getCompanyInfomation(Context ctx, Map paramMap) throws BOSException, EASBizException {
        StringBuffer acctInfoSql = this.getCompanyInfoSql(paramMap);
        StringBuffer acctFilterSql = this.getCompanyFilterSql(ctx, paramMap);
        String acctSql = acctInfoSql.append(acctFilterSql).toString();
        logger.debug((Object)("getCompanyInfomation:" + acctSql));
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)acctSql);
        IRowSet irs = exec.executeSQL();
        return irs;
    }

    @Override
    protected IRowSet _getSafetyStock(Context ctx, Map filterParamMap) throws BOSException, EASBizException {
        IRowSet rs;
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        Date queryDate = LiquidFacadeHelper.checkDateIsValid(filterParamMap, "queryDate", ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"3_FundStockFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fcompanyid,a.FCurrencyID,a.famount,0.0 flocalAmount \n");
        sql.append("from ").append(safteyStockTable).append(" a \n");
        sql.append("INNER JOIN t_org_company b ON a.fcompanyid = b.fid \n");
        sql.append(" WHERE  FEffectiveDate <= {ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        sql.append("  and ").append("\n");
        sql.append(" (not exists ").append("\n");
        sql.append("      (select 1 from  ").append(safteyStockTable).append(" b  where a.fcompanyid=b.fcompanyid and a.fcurrencyid=b.fcurrencyid ").append("\n");
        sql.append("        AND  b.FEffectiveDate>a.FEffectiveDate  AND b.FEffectiveDate<={ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        sql.append("        )").append("\n");
        sql.append("  )").append("\n");
        StringBuffer acctFilterSql = new StringBuffer();
        Object value = filterParamMap.get("companyIdSet");
        if (value != null) {
            String companyId = (String)value;
            CompanyLiquidInfo companyLiquidInfo = LiquidFacadeHelper.getCompanyLiquidById(ctx, companyId);
            acctFilterSql.append(" AND b.flongnumber like '").append(companyLiquidInfo.getCompanyLongnumber()).append("%'");
        }
        if ((value = filterParamMap.get("currencyIdSet")) != null) {
            String inSql = FMHelper.setTran2String((Set)((Set)value));
            acctFilterSql.append("  AND FCURRENCYID in ").append(inSql);
        }
        if (acctFilterSql.length() != 0) {
            sql.append(acctFilterSql);
        }
        logger.debug((Object)("getSafetyStock:" + sql));
        try {
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
            rs = exec.executeSQL();
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, queryDate);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                if (rs.getBigDecimal("famount") == null || exchangeRate == null) continue;
                rs.updateBigDecimal("flocalAmount", rs.getBigDecimal("FAmount").multiply(exchangeRate));
            }
            rs.beforeFirst();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return rs;
    }

    private StringBuffer getCompanyFilterSql(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String isIncludeSealCompany;
        String inSql;
        StringBuffer acctFilterSql = new StringBuffer();
        Object value = paramMap.get("companyIdSet");
        if (value != null) {
            Set idSet = (Set)value;
            inSql = FMHelper.setTran2String((Set)idSet);
            acctFilterSql.append(" AND COMPANY.FID in ").append(inSql);
        }
        if ((value = paramMap.get("isIncludeSealCompany")) != null && (isIncludeSealCompany = (String)value).equals("false")) {
            acctFilterSql.append("  and ( COMPANY.fisSealUp = 0  ) ");
        }
        if ((value = paramMap.get("parentCompanyId")) != null) {
            String parentCompanyId = (String)value;
            inSql = LiquidFacadeHelper.getAllCompanyById(parentCompanyId);
            acctFilterSql.append("  AND ( COMPANY.FID in ").append(inSql);
            acctFilterSql.append("  or COMPANY.FID = '").append(parentCompanyId).append("')");
        }
        if ((value = paramMap.get("isFromProcess")) == null) {
            value = paramMap.get("isFromPc");
            if (value != null) {
                LiquidFacadeHelper.getPermissionCompanySql(ctx, acctFilterSql, true);
            } else {
                LiquidFacadeHelper.getPermissionCompanySql(ctx, acctFilterSql, false);
            }
        }
        return acctFilterSql;
    }

    private StringBuffer getCompanyInfoSql(Map paramMap) {
        StringBuffer acctInfoSql = new StringBuffer();
        acctInfoSql.append("select").append("\n");
        acctInfoSql.append(" COMPANY .FID AS   ").append("FCompanyId").append("\n");
        acctInfoSql.append(", COMPANY .FPARENTID AS   ").append("FCompanyParentId").append("\n");
        acctInfoSql.append(", COMPANY .FName_l2 AS   ").append("FCompanyName").append("\n");
        acctInfoSql.append(", COMPANY .fisleaf AS   ").append("FCompanyIsLeaf").append("\n");
        acctInfoSql.append(", COMPANY .flongnumber AS    ").append("FCompanyLongNumber").append("\n");
        acctInfoSql.append(", COMPANY .flevel AS   ").append("FCompanyLevel").append("\n");
        acctInfoSql.append(", currency.fid as ").append("FCurrencyId").append("\n");
        acctInfoSql.append(",  currency.fname_l2 AS   ").append("FCurrencyName").append("\n");
        acctInfoSql.append(",  currency.fnumber AS   ").append("FCurrencyNumber").append("\n");
        acctInfoSql.append(",'' AS  ").append("FStockItemId").append("\n");
        acctInfoSql.append(",'' AS  ").append("FStockItemName").append("\n");
        acctInfoSql.append(",'' AS  ").append("FStockItemNumber").append("\n");
        acctInfoSql.append(",'' AS  ").append("FStockItemParentId").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FThisEndingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLastEndingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLastYearPeriodBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FThisYearBeginBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLinkRelativeRatio").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FYearOnYearRatio").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FCurrentYearRatio").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalThisEndingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalLastEndingBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalLastYearPeriodBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalThisYearBeginBalance").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalLinkRelativeRatio").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalYearOnYearRatio").append("\n");
        acctInfoSql.append(",0.0 AS  ").append("FLocalCurrentYearRatio").append("\n");
        acctInfoSql.append("from ").append(companyTable).append(" AS  COMPANY ").append("\n");
        acctInfoSql.append("cross JOIN ").append(currencyTable).append(" AS  currency ").append("\n");
        acctInfoSql.append("Where 0=0 ").append("\n");
        acctInfoSql.append(" and  currency.FID <> '11111111-1111-1111-1111-111111111111DEB58FDC' AND CURRENCY.FID <> '22222222-2222-2222-2222-222222222222DEB58FDC'").append("\n");
        acctInfoSql.append(" and  currency.FDeletedStatus=1 ").append("\n");
        acctInfoSql.append("and exists (select * from ").append(currencyUsedTable).append(" liquidBalance where  currency.fid=liquidBalance.fcurrencyid) ").append("\n");
        return acctInfoSql;
    }

    @Override
    protected Map _getBalancesByCompamys(Context ctx, Set idSet, Date date) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String companyInSql = FMHelper.buildIn((String)"fcompanyid", (Object[])idSet.toArray());
        StringBuffer sqlNotUnion = new StringBuffer();
        sqlNotUnion.append(" select fcompanyid,fcurrencyid,fbalance from ").append("t_liquid_companyBalance");
        sqlNotUnion.append(" WHERE FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (idSet.size() != 0) {
            sqlNotUnion.append(" and ").append(companyInSql);
        }
        StringBuffer sqlUnion = new StringBuffer();
        sqlUnion.append(" select fcompanyid,fcurrencyid,fbalance from ").append("T_Liquid_CompanyUserBalance");
        sqlUnion.append(" WHERE FUserID = '").append(userID).append("' ").append(" and FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (idSet.size() != 0) {
            sqlUnion.append(" and ").append(companyInSql);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(sqlNotUnion).append("\n");
        sql.append(" union ").append("\n");
        sql.append(sqlUnion);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, date);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("FBALANCE") != null && exchangeRate != null ? rs.getBigDecimal("FBALANCE").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getString("fcompanyid") + "1") == null) {
                    resultMap.put(rs.getString("fcompanyid") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getString("fcompanyid") + "1");
                resultMap.put(rs.getString("fcompanyid") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getLimitBalanceByCompanys(Context ctx, Set idSet, Date date) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String companyInSql = FMHelper.buildIn((String)"fcompanyid", (Object[])idSet.toArray());
        StringBuffer sqlNotUnion = new StringBuffer();
        sqlNotUnion.append(" select fcompanyid,fcurrencyid,FLimitedBalance from ").append("T_Liquid_CompanyLimitedBalance");
        sqlNotUnion.append(" WHERE FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (idSet.size() != 0) {
            sqlNotUnion.append(" and ").append(companyInSql);
        }
        StringBuffer sqlUnion = new StringBuffer();
        sqlUnion.append(" select fcompanyid,fcurrencyid,FLimitedBalance from ").append("T_Liquid_ComLimitUserBalance");
        sqlUnion.append(" WHERE FUserID = '").append(userID).append("' ").append(" and FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (idSet.size() != 0) {
            sqlUnion.append(" and ").append(companyInSql);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(sqlNotUnion).append("\n");
        sql.append(" union ").append("\n");
        sql.append(sqlUnion);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, date);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("FLimitedBalance") != null && exchangeRate != null ? rs.getBigDecimal("FLimitedBalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getString("fcompanyid") + "1") == null) {
                    resultMap.put(rs.getString("fcompanyid") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getString("fcompanyid") + "1");
                resultMap.put(rs.getString("fcompanyid") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getBalancesByDates(Context ctx, Set acctIdSet, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String acctIdInSql = FMHelper.buildIn((String)"faccountbankid", (Object[])acctIdSet.toArray());
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fbizdate,fcurrencyid,ftype,sum(FBalance) fbalance from ").append("t_liquid_balance");
        sql.append(" WHERE ");
        if (dateSet.size() != 0) {
            sql.append(dateInSql);
        }
        if (acctIdSet.size() <= 0) {
            return resultMap;
        }
        sql.append(" and ");
        sql.append(acctIdInSql);
        sql.append(" group by fbizdate,fcurrencyid,ftype ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getDate("fbizdate") + "1") == null) {
                    resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getDate("fbizdate") + "1");
                resultMap.put(rs.getDate("fbizdate") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getLimitBalancesByDates(Context ctx, Set acctIdSet, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String acctIdInSql = FMHelper.buildIn((String)"faccountbankid", (Object[])acctIdSet.toArray());
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fbizdate,fcurrencyid,ftype,sum(FlimitedBalance) fbalance from ").append("t_liquid_limitedbalance");
        sql.append(" WHERE ");
        if (dateSet.size() != 0) {
            sql.append(dateInSql);
        }
        if (acctIdSet.size() <= 0) {
            return resultMap;
        }
        sql.append(" and ");
        sql.append(acctIdInSql);
        sql.append(" group by fbizdate,fcurrencyid,ftype ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getDate("fbizdate") + "1") == null) {
                    resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getDate("fbizdate") + "1");
                resultMap.put(rs.getDate("fbizdate") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getCompanyBalancesByDates(Context ctx, String companyid, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if (company.isIsBizUnit()) {
            sql.append(" select fbizdate,fcurrencyid,ftype,sum(FBalance) fbalance from ").append("t_liquid_companybalance");
            sql.append(" WHERE fcompanyid ='").append(companyid).append("'");
            if (dateSet.size() != 0) {
                sql.append(" and ").append(dateInSql);
            }
            sql.append(" group by fbizdate,fcurrencyid,ftype ");
        } else {
            String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
            sql.append(" select fbizdate,fcurrencyid,ftype,sum(FBalance) fbalance from ").append("T_Liquid_CompanyUserBalance");
            sql.append(" WHERE  FUserID = '").append(userID).append("' ").append(" and fcompanyid ='").append(companyid).append("'");
            if (dateSet.size() != 0) {
                sql.append(" and ").append(dateInSql);
            }
            sql.append(" group by fbizdate,fcurrencyid,ftype ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getDate("fbizdate") + "1") == null) {
                    resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getDate("fbizdate") + "1");
                resultMap.put(rs.getDate("fbizdate") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getCompanyLimitBalancesByDates(Context ctx, String companyid, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if (company.isIsBizUnit()) {
            sql.append(" select fbizdate,fcurrencyid,ftype,sum(FlimitedBalance) fbalance from ").append("t_liquid_companylimitedbalance");
            sql.append(" WHERE fcompanyid ='").append(companyid).append("'");
            if (dateSet.size() != 0) {
                sql.append(" and ").append(dateInSql);
            }
            sql.append(" group by fbizdate,fcurrencyid,ftype ");
        } else {
            String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
            sql.append(" select fbizdate,fcurrencyid,ftype,sum(FlimitedBalance) fbalance from ").append("T_Liquid_ComLimitUserBalance");
            sql.append(" WHERE  FUserID = '").append(userID).append("' ").append(" and fcompanyid ='").append(companyid).append("'");
            if (dateSet.size() != 0) {
                sql.append(" and ").append(dateInSql);
            }
            sql.append(" group by fbizdate,fcurrencyid,ftype ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + rs.getDate("fbizdate"), exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getDate("fbizdate") + "1") == null) {
                    resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(rs.getDate("fbizdate") + "1");
                resultMap.put(rs.getDate("fbizdate") + "1", lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getOneAcctBalancesByDates(Context ctx, String acctId, String currencyId, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fbizdate,fcurrencyid,ftype,FBalance from ").append("t_liquid_balance");
        sql.append(" WHERE faccountbankid='").append(acctId).append("'");
        sql.append(" and fcurrencyid='").append(currencyId).append("'");
        if (dateSet.size() != 0) {
            sql.append(" and ").append(dateInSql);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap exchangeRateMap = new HashMap();
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getOneAcctLimitBalancesByDates(Context ctx, String acctId, String currencyId, Set dateSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        dateSet = this.getDateSet(dateSet);
        String dateInSql = FMHelper.buildIn((String)"FBIZDATE", (Object[])dateSet.toArray());
        dateInSql = dateInSql.replace("'", "");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fbizdate,fcurrencyid,ftype,FlimitedBalance from ").append("t_liquid_limitedbalance");
        sql.append(" WHERE faccountbankid='").append(acctId).append("'");
        sql.append(" and fcurrencyid='").append(currencyId).append("'");
        if (dateSet.size() != 0) {
            sql.append(" and ").append(dateInSql);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                BigDecimal exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, rs.getDate("fbizdate"));
                BigDecimal localBalance = rs.getBigDecimal("FlimitedBalance") != null && exchangeRate != null ? rs.getBigDecimal("FlimitedBalance").multiply(exchangeRate) : BigDecimal.ZERO;
                resultMap.put(rs.getDate("fbizdate") + "1", localBalance);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    private Set getDateSet(Set dateSet) {
        HashSet<String> dateSetNew = new HashSet<String>();
        for (int i = 0; i < dateSet.toArray().length; ++i) {
            Date date = (Date)dateSet.toArray()[i];
            dateSetNew.add("{" + LiquidAppConstants.sdf.format(date.getTime()) + "}");
        }
        return dateSetNew;
    }

    @Override
    protected Map _getBalancesByOnelvelBankIds(Context ctx, String companyId, Set bankIdSet, Date queryDate) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (bankIdSet.size() == 0) {
            return resultMap;
        }
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String acctIdInSql = FMHelper.buildIn((String)"c.fonelevelbankid", (Object[])bankIdSet.toArray());
        StringBuffer sql = new StringBuffer();
        StringBuffer bankSql = new StringBuffer();
        bankSql.append(" select a.fcompanyid fcompanyid,c.fonelevelbankid fonelevelbankid,a.fcurrencyid fcurrencyid,sum(fbalance) fbalance").append("\n");
        bankSql.append("from t_liquid_balance a ").append("\n");
        bankSql.append("  join t_bd_accountbanks b on a.faccountbankid=b.fid ").append("\n");
        bankSql.append("   join t_liquid_bank c on b.fbank=c.fbankid ").append("\n");
        bankSql.append("  where a.fcompanyid='").append(companyId).append("'");
        bankSql.append("  and a.FBIZDATE = {ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        if (bankIdSet.size() > 0) {
            bankSql.append(" and ");
            bankSql.append(acctIdInSql);
        }
        bankSql.append("  group by a.fcompanyid,c.fonelevelbankid,a.fcurrencyid ").append("\n");
        StringBuffer cashSql = new StringBuffer();
        cashSql.append(" select a.fcompanyid fcompanyid,'").append("cash0000").append("' fonelevelbankid ,a.fcurrencyid fcurrencyid,sum(fbalance) fbalance").append("\n");
        cashSql.append("from t_liquid_balance a ").append("\n");
        cashSql.append("   join t_bd_accountview b on a.faccountbankid=b.fid ").append("\n");
        cashSql.append("  where a.fcompanyid='").append(companyId).append("'").append("\n");
        cashSql.append("  and a.FBIZDATE = {ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        cashSql.append("  group by a.fcompanyid ,a.fcurrencyid ").append("\n");
        sql.append(bankSql).append("\n");
        sql.append(" union ").append("\n");
        sql.append(cashSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                String key = rs.getString("fcompanyid") + rs.getString("fonelevelbankid") + "1";
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, queryDate);
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + queryDate, exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(key) == null) {
                    resultMap.put(key, localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(key);
                resultMap.put(key, lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected Map _getLimitedBalancesByOnelvelBankIds(Context ctx, String companyid, Set bankIdSet, Date queryDate) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (bankIdSet.size() == 0) {
            return resultMap;
        }
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String acctIdInSql = FMHelper.buildIn((String)"c.fonelevelbankid", (Object[])bankIdSet.toArray());
        StringBuffer sql = new StringBuffer();
        StringBuffer bankSql = new StringBuffer();
        bankSql.append(" select a.fcompanyid fcompanyid,c.fonelevelbankid fonelevelbankid,a.fcurrencyid fcurrencyid,sum(flimitedbalance) fbalance").append("\n");
        bankSql.append("from t_liquid_limitedbalance a ").append("\n");
        bankSql.append("  join t_bd_accountbanks b on a.faccountbankid=b.fid ").append("\n");
        bankSql.append("   join t_liquid_bank c on b.fbank=c.fbankid ").append("\n");
        bankSql.append("  where a.fcompanyid='").append(companyid).append("'");
        bankSql.append("  and a.FBIZDATE = {ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        if (bankIdSet.size() > 0) {
            bankSql.append(" and ");
            bankSql.append(acctIdInSql);
        }
        bankSql.append("  group by a.fcompanyid,c.fonelevelbankid,a.fcurrencyid ").append("\n");
        StringBuffer cashSql = new StringBuffer();
        cashSql.append(" select a.fcompanyid fcompanyid,'").append("cash0000").append("' fonelevelbankid ,a.fcurrencyid fcurrencyid,sum(flimitedbalance) fbalance").append("\n");
        cashSql.append("from t_liquid_limitedbalance a ").append("\n");
        cashSql.append("   join t_bd_accountview b on a.faccountbankid=b.fid ").append("\n");
        cashSql.append("  where a.fcompanyid='").append(companyid).append("'").append("\n");
        cashSql.append("  and a.FBIZDATE = {ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        cashSql.append("  group by a.fcompanyid,a.fcurrencyid ").append("\n");
        sql.append(bankSql).append("\n");
        sql.append(" union ").append("\n");
        sql.append(cashSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                String key = rs.getString("fcompanyid") + rs.getString("fonelevelbankid") + "1";
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, queryDate);
                    exchangeRateMap.put(rs.getString("FCURRENCYID") + queryDate, exchangeRate);
                }
                BigDecimal localBalance = rs.getBigDecimal("fbalance") != null && exchangeRate != null ? rs.getBigDecimal("fbalance").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(key) == null) {
                    resultMap.put(key, localBalance);
                    continue;
                }
                BigDecimal lastBalance = (BigDecimal)resultMap.get(key);
                resultMap.put(key, lastBalance.add(localBalance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }
}

