/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.StockItemInfo;
import com.kingdee.eas.fm.liquid.app.CompanyBalanceNode;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeControllerBean;
import com.kingdee.eas.fm.mobile.util.PermissionCompanyTreeUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class LiquidFacadeHelper {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static CompanyLiquidInfo getCompanyLiquidById(Context ctx, String id) throws EASBizException {
        CompanyLiquidInfo companyLiquid = new CompanyLiquidInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select COMPANY.fid fcompanyId,COMPANY.fname_l2 fcompanyName,COMPANY.fisleaf fcompanyIsleaf,COMPANY.fnumber fcompanyNumber,COMPANY.flongnumber fcompanyLongnumber ");
        sql.append("  ,COMPANY.FBaseCurrencyID FBaseCurrencyID,BASECURRENCY.fname_l2 FBaseCurrencyName ");
        sql.append(" from ").append(LiquidFacadeControllerBean.companyTable).append(" AS  COMPANY ").append("\n");
        sql.append(" left join ").append(LiquidFacadeControllerBean.currencyTable).append(" AS  BASECURRENCY ON  COMPANY .FBaseCurrencyID =  BASECURRENCY.FID").append("\n");
        sql.append(" where COMPANY.fid = '").append(id).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                companyLiquid.setCompanyName(rs.getString("fcompanyName"));
                companyLiquid.setLeaf(rs.getBoolean("fcompanyIsleaf"));
                companyLiquid.setCompanyNumber(rs.getString("fcompanyNumber"));
                companyLiquid.setCompanyLongnumber(rs.getString("fcompanyLongnumber"));
                companyLiquid.setDescCurrencyName(rs.getString("FBaseCurrencyName"));
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return companyLiquid;
    }

    public static ArrayList getCompanyLiquidByIdSet(Context ctx, Set idSet) throws EASBizException {
        ArrayList<CompanyLiquidInfo> companyLiquidList = new ArrayList<CompanyLiquidInfo>();
        String companyInSql = FMHelper.buildIn((String)" COMPANY.fid ", (Object[])idSet.toArray());
        StringBuffer sql = new StringBuffer();
        sql.append(" select COMPANY.fid fcompanyId,COMPANY.fname_l2 fcompanyName,COMPANY.fisleaf fcompanyIsleaf,COMPANY.fnumber fcompanyNumber,COMPANY.flongnumber fcompanyLongnumber ");
        sql.append("  ,COMPANY.FBaseCurrencyID FBaseCurrencyID,BASECURRENCY.fname_l2 FBaseCurrencyName ");
        sql.append(" from ").append(LiquidFacadeControllerBean.companyTable).append(" AS  COMPANY ").append("\n");
        sql.append(" left join ").append(LiquidFacadeControllerBean.currencyTable).append(" AS  BASECURRENCY ON  COMPANY .FBaseCurrencyID =  BASECURRENCY.FID").append("\n");
        sql.append(" where ").append(companyInSql);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CompanyLiquidInfo companyLiquid = new CompanyLiquidInfo();
                companyLiquid.setCompanyName(rs.getString("fcompanyName"));
                companyLiquid.setCompanyid(rs.getString("fcompanyId"));
                companyLiquid.setLeaf(rs.getBoolean("fcompanyIsleaf"));
                companyLiquid.setCompanyNumber(rs.getString("fcompanyNumber"));
                companyLiquid.setCompanyLongnumber(rs.getString("fcompanyLongnumber"));
                companyLiquid.setDescCurrencyName(rs.getString("FBaseCurrencyName"));
                companyLiquidList.add(companyLiquid);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return companyLiquidList;
    }

    public static Set getAllCompanyById(Context ctx, String id) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid  from ").append(LiquidFacadeControllerBean.companyTable);
        sql.append(" where fparentid = '").append(id).append("'");
        try {
            Map permissionCompanyMap = LiquidFacadeHelper.getPermissionCompanyMap(ctx);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String companyId = rs.getString("fid");
                if (!permissionCompanyMap.containsKey(companyId)) continue;
                idSet.add(companyId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    private static Map getPermissionCompanyMap(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx);
        HashMap<String, String> permissionCompanyMap = new HashMap<String, String>();
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo companyInfo = companyColl.get(i);
            permissionCompanyMap.put(companyInfo.getId().toString(), companyInfo.getId().toString());
        }
        return permissionCompanyMap;
    }

    public static BankInfo getBankById(Context ctx, String bankId) throws EASBizException {
        BankInfo bank = new BankInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fname_l2,fnumber from ").append(LiquidFacadeControllerBean.bankTable);
        sql.append(" where fid = '").append(bankId).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                bank.setName(rs.getString("fname_l2"));
                bank.setNumber(rs.getString("fnumber"));
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return bank;
    }

    public static Set getAllParentBankById(Context ctx, String id) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> numberSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select bank.fid fid,bank.flongnumber flongnumber from ").append(LiquidFacadeControllerBean.bankTable).append(" as bank").append("\n");
        sql.append("  join ").append(LiquidFacadeControllerBean.acctBankTable).append(" as accountbank on bank.fid=accountbank.fbank ").append("\n");
        sql.append(" where accountbank.fcompanyid= '").append(id).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String bankLongNumber = rs.getString("flongnumber");
                String[] longNumbers = bankLongNumber.split("!");
                if (numberSet.contains(longNumbers[0])) continue;
                numberSet.add(longNumbers[0]);
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("select fid from ").append(LiquidFacadeControllerBean.bankTable);
            String inSql = FMHelper.setTran2String(numberSet);
            sql2.append(" where fisingroup!=1 and fnumber in ").append(inSql);
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
            while (rs2.next()) {
                String bankId = rs2.getString("fid");
                idSet.add(bankId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    public static Map getStockItems(Context ctx) throws EASBizException {
        HashMap<String, StockItemInfo> stockItemMap = new HashMap<String, StockItemInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fname_l2,fnumber,fparentid from ").append(LiquidFacadeControllerBean.stockItemTable);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                StockItemInfo stockItem = new StockItemInfo();
                stockItem.setId(rs.getString("fid"));
                stockItem.setName(rs.getString("fname_l2"));
                stockItem.setNumber(rs.getString("fnumber"));
                stockItem.setParentid(rs.getString("fparentid"));
                stockItemMap.put(stockItem.getId(), stockItem);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return stockItemMap;
    }

    public static String getAllCompanyById(String parentCompanyId) {
        StringBuffer inSql = new StringBuffer();
        inSql.append("(select fid  from ").append(LiquidFacadeControllerBean.companyTable).append(" where flongnumber like ").append("\n");
        inSql.append(" (select CONCAT(flongnumber,'!%') from ").append(LiquidFacadeControllerBean.companyTable).append(" where fid='").append(parentCompanyId).append("'))");
        return inSql.toString();
    }

    public static BigDecimal getExRateInfo(Context ctx, String srcCurrId, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        if (srcCurrId == null || date == null) {
            return null;
        }
        String destCurrId = company.getBaseCurrency().getId().toString();
        if (srcCurrId.equals(destCurrId)) {
            return BigDecimal.ONE;
        }
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (exRateInfo == null) {
            return null;
        }
        boolean isIndirectExRate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exRateInfo.getConvertMode());
        BigDecimal rate = isIndirectExRate ? Constants.ONE.divide(exRateInfo.getConvertRate(), 20, 4) : exRateInfo.getConvertRate();
        return rate;
    }

    public static Date checkDateIsValid(Map<String, Object> filterParamMap, String paramName, String dateTitle) throws LiquidException {
        Date date = null;
        Object value = filterParamMap.get(paramName);
        if (!EmptyUtil.isEmpty((Object)value)) {
            try {
                date = dateFormat.parse((String)value);
            }
            catch (ParseException e) {
                throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
            }
        } else {
            throw new LiquidException(LiquidException.NOTBLANK, new Object[]{dateTitle});
        }
        return date;
    }

    public static Set getMotherAcctByCompanyId(Context ctx, String companyid) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append(" where fcompanyid = '").append(companyid).append("' and  FIsMotherAccount=1 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String acctId = rs.getString("fid");
                idSet.add(acctId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    public static Set getSubAcctByMotherCompanyId(Context ctx, String companyid) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append("  where FSubAccountID in  ").append("\n");
        sql.append(" (select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append(" where fcompanyid = '").append(companyid).append("' and  FIsMotherAccount=1 )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String acctId = rs.getString("fid");
                idSet.add(acctId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    public static Set getOtherAcctByMotherCompanyId(Context ctx, String companyid) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append(" where fcompanyid = '").append(companyid).append("' and  FIsMotherAccount!=1 ").append("\n");
        sql.append(" union ").append("\n");
        sql.append(" select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append(" where FSubAccountID is null and fcompanyid in  ").append("\n");
        sql.append("(select fcompanyid  from ").append(LiquidFacadeControllerBean.acctBankTable).append(" where FSubAccountID in ").append("\n");
        sql.append("  (select fid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        sql.append("    where fcompanyid = '").append(companyid).append("' and  FIsMotherAccount=1 )").append("\n");
        sql.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String acctId = rs.getString("fid");
                idSet.add(acctId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    public static ArrayList getAcctParamListByCompanyId(Context ctx, String companyid) throws EASBizException {
        ArrayList<AccountParam> acctParamList = new ArrayList<AccountParam>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fcurrencyid  from ").append(LiquidFacadeControllerBean.acctBankTable).append("\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String acctid = rs.getString("fid");
                String currencyId = rs.getString("FCurrencyId");
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(acctid);
                acctParam.setDateType("1");
                acctParam.setCurrencyId(currencyId);
                acctParam.setCompanyId(companyid);
                acctParamList.add(acctParam);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return acctParamList;
    }

    public static Map getInitBalanceMap(Context ctx, Date date, String acctidInSql) throws BOSException, EASBizException {
        HashMap<String, AccountParam> initBalanceMap = new HashMap<String, AccountParam>();
        StringBuffer initBalanceSql = new StringBuffer();
        initBalanceSql.append("select  a.FAccountBankID,a.fcurrencyid,a.ftype,a.fbizdate,a.fbalance  from ").append(LiquidFacadeControllerBean.balanceTable).append(" as a ").append("\n");
        initBalanceSql.append("right join ").append("\n");
        initBalanceSql.append("(").append("\n");
        initBalanceSql.append("select FAccountBankID,fcurrencyid,ftype,min(fbizdate) as fbizdate from ").append(LiquidFacadeControllerBean.balanceTable).append("\n");
        initBalanceSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctidInSql.length() > 0) {
            initBalanceSql.append("and ").append("\n");
            initBalanceSql.append(acctidInSql).append("\n");
        }
        initBalanceSql.append("group by  FAccountBankID,fcurrencyid,ftype ").append("\n");
        initBalanceSql.append(") as b on a.FAccountBankID=b.FAccountBankID and a.fcurrencyid=b.fcurrencyid and a.ftype=b.ftype and a.fbizdate=b.fbizdate ").append("\n");
        logger.debug((Object)("initBalanceSql:" + initBalanceSql));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)initBalanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                initBalanceMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return initBalanceMap;
    }

    public static Map getDetailMap(Context ctx, Date date, String acctidInSql) throws BOSException, EASBizException {
        HashMap detailMap = new HashMap();
        StringBuffer detailSql = new StringBuffer();
        detailSql.append("select  a.faccountbankid, a.fcurrencyid,  a.ftype, a.fbizdate,  sum(a.fdebitamount) fdebitamount,sum(a.fcreditamount) fcreditamount from  ").append("\n");
        detailSql.append(LiquidFacadeControllerBean.detailTable).append(" as a \n");
        detailSql.append("where  a.FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        if (acctidInSql.length() > 0) {
            detailSql.append("and ").append("\n");
            detailSql.append(acctidInSql).append("\n");
        }
        detailSql.append("group by  FAccountBankID,fcurrencyid,ftype , a.fbizdate").append("\n");
        detailSql.append("order by  FAccountBankID,fcurrencyid,ftype , a.fbizdate asc ").append("\n");
        try {
            logger.debug((Object)("detailSql:" + detailSql));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)detailSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("fdebitamount").subtract(rs.getBigDecimal("fcreditamount")));
                acctParam.setInAmount(rs.getBigDecimal("fdebitamount"));
                acctParam.setOutAmount(rs.getBigDecimal("fcreditamount"));
                String key = acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId();
                Map oneDetailMap = detailMap.get(key) != null ? (Map)detailMap.get(key) : new TreeMap();
                oneDetailMap.put(acctParam.getBizDate().toString(), acctParam);
                detailMap.put(key, oneDetailMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return detailMap;
    }

    public static Map getInitBalanceCompamyMap(Context ctx, Date date) throws BOSException, EASBizException {
        HashMap<String, AccountParam> initBalanceMap = new HashMap<String, AccountParam>();
        StringBuffer initBalanceSql = new StringBuffer();
        initBalanceSql.append("select  a.Fcompanyid,a.fcurrencyid,a.ftype,a.fbizdate,a.fbalance  from ").append("\n");
        initBalanceSql.append("(select  Fcompanyid,fcurrencyid,ftype,fbizdate,sum(fbalance) fbalance from ").append(LiquidFacadeControllerBean.balanceTable).append("\n");
        initBalanceSql.append(" group by Fcompanyid,fcurrencyid,ftype,fbizdate ").append("\n").append(" ) a ");
        initBalanceSql.append("right join ").append("\n");
        initBalanceSql.append("(").append("\n");
        initBalanceSql.append("select Fcompanyid,fcurrencyid,ftype,min(fbizdate) as fbizdate from ").append(LiquidFacadeControllerBean.balanceTable).append("\n");
        initBalanceSql.append("where  FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        initBalanceSql.append("group by  Fcompanyid,fcurrencyid,ftype ").append("\n");
        initBalanceSql.append(") as b on a.Fcompanyid=b.Fcompanyid and a.fcurrencyid=b.fcurrencyid and a.ftype=b.ftype and a.fbizdate=b.fbizdate ").append("\n");
        logger.debug((Object)("initCompanyBalanceSql:" + initBalanceSql));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)initBalanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("Fcompanyid"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
                initBalanceMap.put(acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId(), acctParam);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return initBalanceMap;
    }

    public static Map getDetailCompanyMap(Context ctx, Date date) throws BOSException, EASBizException {
        HashMap detailMap = new HashMap();
        StringBuffer detailSql = new StringBuffer();
        detailSql.append("select  Fcompanyid, a.fcurrencyid,  a.ftype, a.fbizdate,  sum(a.fdebitamount) fdebitamount,sum(a.fcreditamount) fcreditamount from  ").append("\n");
        detailSql.append(LiquidFacadeControllerBean.detailTable).append(" as a \n");
        detailSql.append("where  a.FBIZDATE <={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        detailSql.append("group by  Fcompanyid,fcurrencyid,ftype , a.fbizdate").append("\n");
        detailSql.append("order by  Fcompanyid,fcurrencyid,ftype , a.fbizdate asc ").append("\n");
        try {
            logger.debug((Object)("detailCompanySql:" + detailSql));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)detailSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("Fcompanyid"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBizDate(rs.getDate("fbizdate"));
                acctParam.setBalance(rs.getBigDecimal("fdebitamount").subtract(rs.getBigDecimal("fcreditamount")));
                acctParam.setInAmount(rs.getBigDecimal("fdebitamount"));
                acctParam.setOutAmount(rs.getBigDecimal("fcreditamount"));
                String key = acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId();
                Map oneDetailMap = detailMap.get(key) != null ? (Map)detailMap.get(key) : new TreeMap();
                oneDetailMap.put(acctParam.getBizDate().toString(), acctParam);
                detailMap.put(key, oneDetailMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return detailMap;
    }

    public static ArrayList getBetweenDay(Date beginDate, Date endDate) {
        ArrayList<Date> betweenDays = new ArrayList<Date>();
        int differDays = DateHelper.getDiffDays((Date)beginDate, (Date)endDate);
        Date now = beginDate;
        for (int i = 0; i < differDays; ++i) {
            Date nextDay = DateHelper.getNextDay((Date)now);
            betweenDays.add(nextDay);
            now = nextDay;
        }
        return betweenDays;
    }

    public static ArrayList<Date> getBetweenDayByYear(Date beginDate, Date endDate) {
        ArrayList<Date> betweenDays = new ArrayList<Date>();
        betweenDays.add(beginDate);
        Date nextDay = DateHelper.getNextDay((Date)beginDate, (int)730);
        while (nextDay.before(endDate)) {
            betweenDays.add(nextDay);
            nextDay = DateHelper.getNextDay((Date)nextDay, (int)730);
        }
        betweenDays.add(DateHelper.getNextDay((Date)endDate));
        return betweenDays;
    }

    public static CompanyBalanceNode buildTreeByOrgUnitCollection(CompanyOrgUnitCollection col) {
        if (col == null) {
            return null;
        }
        if (col.size() == 0) {
            return null;
        }
        CompanyBalanceNode rootTreeNode = null;
        HashMap<String, CompanyBalanceNode> nodeMap = new HashMap<String, CompanyBalanceNode>();
        for (int i = 0; i < col.size(); ++i) {
            CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)col.getObject(i);
            CompanyOrgUnitInfo parentInfo = (CompanyOrgUnitInfo)unitInfo.get("parent");
            if (rootTreeNode == null) {
                rootTreeNode = new CompanyBalanceNode(unitInfo);
                nodeMap.put(unitInfo.getId().toString(), rootTreeNode);
                continue;
            }
            CompanyBalanceNode subTreeNode = new CompanyBalanceNode(unitInfo);
            if (parentInfo == null) continue;
            if (nodeMap.containsKey(parentInfo.getId().toString())) {
                ((CompanyBalanceNode)nodeMap.get(parentInfo.getId().toString())).add(subTreeNode);
            }
            nodeMap.put(unitInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static Set getAcctIdByCompanyAndBank(Context ctx, String companyId, String parentBankId) throws EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        if (parentBankId.equals("cash0000")) {
            sql.append("select acctview.fid ").append("\n");
            sql.append(",acctview.fnumber,acctview.faccounttableid,company.FBaseCurrencyID from ").append(LiquidFacadeControllerBean.accountViewTable).append(" acctview").append("\n");
            sql.append("inner join ").append(LiquidFacadeControllerBean.companyTable).append("  company on company.fiD=acctview.Fcompanyid and company.FAccountTableID=acctview.FAccountTableID").append("\n");
            sql.append("where  acctview.fisLeaf = '1' AND acctview.fisCash = '1' ").append("\n");
            sql.append("  and acctview.fcompanyid = '").append(companyId).append("'");
        } else {
            sql.append("select fid from t_bd_accountbanks where ");
            sql.append("  fcompanyid = '").append(companyId).append("'");
            if (parentBankId != null) {
                StringBuffer inSql = new StringBuffer();
                inSql.append("(select fid  from ").append(LiquidFacadeControllerBean.bankTable).append(" where flongnumber like ").append("\n");
                inSql.append(" (select CONCAT(flongnumber,'!%') from ").append(LiquidFacadeControllerBean.bankTable).append(" where fid='").append(parentBankId).append("'))");
                sql.append("  AND ( FBANK in ").append(inSql);
                sql.append("  or FBANK = '").append(parentBankId).append("')  ");
            }
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String acctId = rs.getString("fid");
                idSet.add(acctId);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return idSet;
    }

    public static void getPermissionCompanySql(Context ctx, StringBuffer acctFilterSql, boolean isFromPc) throws BOSException, EASBizException {
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (currentUser != null) {
            CompanyOrgUnitCollection collection = null;
            collection = isFromPc ? PermissionCompanyTreeUtil.getCompanyTreeWithPermissionForPc(ctx) : PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx);
            String companyids = FMHelper.coll2String((IObjectCollection)collection);
            if (!EmptyUtil.isEmpty((String)companyids)) {
                acctFilterSql.append("  AND COMPANY.FID IN ").append(companyids);
            } else {
                acctFilterSql.append("  AND 1 = 2 ");
            }
        }
    }
}

