/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.RestrictedAccountInfo;
import com.kingdee.eas.fm.liquid.app.AbstractRestrictedAccountControllerBean;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public class RestrictedAccountControllerBean
extends AbstractRestrictedAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.RestrictedAccountControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RestrictedAccountInfo info = (RestrictedAccountInfo)model;
        this.verifyRestricted(ctx, info);
        LiquidBaseHelper.initNumber(ctx, info, info.getAccBankCompany().getId().toString(), (AbstractCoreBaseControllerBean)this);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RestrictedAccountInfo info = (RestrictedAccountInfo)model;
        this.verifyRestricted(ctx, info);
        LiquidBaseHelper.initNumber(ctx, info, info.getAccBankCompany().getId().toString(), (AbstractCoreBaseControllerBean)this);
        return super._save(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private String getMessageFromAccount(RestrictedAccountInfo info) {
        String message = info.getAccountBank().getName();
        String bankNumber = info.getAccountBank().getBankAccountNumber();
        int size = bankNumber.length();
        message = size >= 4 ? message + bankNumber.substring(size - 4, size) : message + bankNumber;
        return message;
    }

    private void verifyRestricted(Context ctx, RestrictedAccountInfo info) throws BOSException, LiquidException {
        Timestamp startDate = null;
        Timestamp endDate = null;
        startDate = new Timestamp(info.getStartDate().getTime());
        startDate.setHours(0);
        startDate.setMinutes(0);
        startDate.setSeconds(0);
        startDate.setNanos(0);
        SQLUtil sql = new SQLUtil();
        sql.appendSql("SELECT ra.fid as fid, ra.FRestrictedType , ra.FAmount, ra.FRemarks, fstartDate, ");
        sql.appendSql(" case when fendDate is null then ");
        sql.appendParam((Object)new Date(DateUtil.stringToDate((String)"2100-01-01").getTime()));
        sql.appendSql(" else  fendDate  end fendDate ");
        sql.appendSql(" FROM T_LI_RestrictedAccount AS ra ");
        sql.appendSql(" WHERE faccountBankid = ");
        sql.appendParam((Object)info.getAccountBank().getId().toString());
        sql.appendSql(" and fcurrencyid =");
        sql.appendParam((Object)info.getCurrency().getId().toString());
        if (info.getId() != null) {
            sql.appendSql(" and fid != ");
            sql.appendParam((Object)info.getId().toString());
        }
        sql.appendSql(" and ( fendDate is null or fendDate >= ");
        sql.appendParam((Object)startDate);
        sql.appendSql(" ) ");
        if (info.getEndDate() != null) {
            endDate = new Timestamp(info.getEndDate().getTime());
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
            endDate.setNanos(59);
            sql.appendSql(" and fstartDate <= ");
            sql.appendParam((Object)endDate);
        } else {
            sql.appendSql(" and fstartDate <= ");
            sql.appendParam((Object)new Date(DateUtil.stringToDate((String)"2100-01-01").getTime()));
        }
        Object coll = null;
        IRowSet rowSet = this.getRowSet(ctx, sql);
        if (rowSet.size() > 0) {
            throw new LiquidException(LiquidException.HASRESTRICTED, new Object[]{info.getAccBankCompany().getName(), this.getMessageFromAccount(info), info.getCurrency().getName()});
        }
    }

    private IRowSet getRowSet(Context ctx, SQLUtil sqlBuilder) throws BOSException {
        JdbcRowSet rowSet = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            rowSet = new JdbcRowSet();
            rowSet.populate(rs);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rowSet;
    }

    @Override
    protected Map _batchAddnew(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        return null;
    }
}

