/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.backcal;

import com.kingdee.eas.fm.liquid.app.backcal.NodeData;
import com.kingdee.eas.fm.liquid.app.backcal.NodeDataTable;
import java.util.HashMap;
import java.util.Map;

public class OrgNode {
    private NodeDataTable nodeDataTable;
    private Map<String, OrgNode> children = new HashMap<String, OrgNode>();
    private String orgID;

    public OrgNode(String orgID) {
        this.orgID = orgID;
        this.nodeDataTable = new NodeDataTable();
    }

    public void addChild(OrgNode node) {
        this.children.put(node.getID(), node);
    }

    public String getID() {
        return this.orgID;
    }

    public OrgNode getChildByKey(String childID) {
        return this.children.get(childID);
    }

    public int childrenSize() {
        return this.children.size();
    }

    public void addData(NodeData nodeData) {
        this.nodeDataTable.addRow(nodeData);
    }

    public NodeDataTable getNodeDataMap() {
        return this.nodeDataTable;
    }

    public void buildData() {
        if (this.children.isEmpty()) {
            return;
        }
        for (OrgNode orgNode : this.children.values()) {
            orgNode.buildData();
            this.nodeDataTable.merge(orgNode.getNodeDataMap());
        }
    }

    public String toString() {
        return "OrgNode [orgID=" + this.orgID + ", nodeDataTable=" + this.nodeDataTable + ", children=" + this.children + "]";
    }
}

