/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LiquidDataSetHelper {
    private static final int PROFILE_TIME = 500;
    private static final Logger logger = Logger.getLogger(LiquidDataSetHelper.class);
    private static ITableManagerFacade tableManagerFacade = null;
    private static final String SQL_TABLE_EXCHANGE_RATE = "CREATE TABLE {0} (FCurrencyId VARCHAR(44),FExchangeRate NUMERIC(19,6))";
    private static final String SQL_INSERT_EXCHANGE_RATE = "INSERT INTO {0} (FCurrencyId,FExchangeRate) VALUES(''{1}'',{2});\n";
    private static final String SQL_COMPANY_CURRENCY = "SELECT FId FCurrencyId FROM T_BD_CURRENCY CURRENCY WHERE EXISTS (SELECT DETAIL.FCurrencyId FROM {0} DETAIL WHERE DETAIL.FCurrencyId = CURRENCY.FID)";
    private static final String SQL_ORG_UNIONS = "SELECT FUnitId FROM T_ORG_STRUCTURE STRUCTURE1 \nWHERE EXISTS (\nSELECT FID FROM (\nSELECT FID, FUnitId FROM T_ORG_STRUCTURE WHERE FTreeId = ''{0}'' \nAND FUnitId IN {1} \n ) STRUCTURE2  WHERE STRUCTURE1.FParentId = STRUCTURE2.FID) \nAND STRUCTURE1.FTreeId = ''{0}'' \nAND STRUCTURE1.FUnitId IN {2}";
    private static final String SQL_TABLE_COMPANY = "CREATE TABLE {0} (FId VARCHAR(44),FName_{1} NVARCHAR(80),FLongNumber NVARCHAR(255),FIsLeaf NUMERIC(4),FLevel NUMERIC(4),FParentId VARCHAR(44),FIsSealup NUMERIC(4),CONSTRAINT PK_{2} PRIMARY KEY (FId))";
    private static final String SQL_INSERT_FIELD_COMPANY = "INSERT INTO {0} (FID,FName_{1},FLongNumber,FIsLeaf,FLevel,FParentId,FIsSealup)\n";
    private static final String SQL_ORG_COMPANY_DATA = "SELECT FID,FName_{2},FLongNumber,FIsLeaf,FLevel,FParentId,FIsSealup FROM T_ORG_COMPANY COMPANY WHERE FLongNumber LIKE ''{0}%'' {1}";
    private static final String SQL_ORG_COMPANY_FILTER = "AND EXISTS(SELECT COMPANY1.FID FROM T_ORG_COMPANY COMPANY1 WHERE CHARINDEX(COMPANY.FLongNumber,COMPANY1.FLongNumber) >= 1 {0})";
    private static final String SQL_ORG_STRUCTURE_DATA = "SELECT ISNULL(COMPANY.FID,STRUCTURE.FID),ISNULL(BASEUNIT.FName_{3},COMPANY.FName_{3}),STRUCTURE.FLongNumber,STRUCTURE.FIsLeaf,STRUCTURE.FLevel,STRUCTURE.FParentId,ISNULL(COMPANY.FIsSealup,0) \nFROM T_ORG_STRUCTURE STRUCTURE \nLEFT JOIN T_ORG_BASEUNIT BASEUNIT ON STRUCTURE.FUnitId = BASEUNIT.FID AND BASEUNIT.FIsUnion = 1 \nLEFT JOIN T_ORG_COMPANY COMPANY ON STRUCTURE.FUnitId = COMPANY.FID \nWHERE STRUCTURE.FLongNumber LIKE ''{0}%'' AND STRUCTURE.FTreeId = ''{1}'' \n{2}";
    private static final String SQL_ORG_STRUCTURE_FILTER = "AND EXISTS(SELECT STRUCTURE1.FID FROM T_ORG_STRUCTURE STRUCTURE1 WHERE CHARINDEX(STRUCTURE.FLongNumber,STRUCTURE1.FLongNumber) >= 1 {0})";

    public static ITableManagerFacade getTableManagerFacade(Context ctx) throws BOSException {
        if (tableManagerFacade == null) {
            tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        }
        return tableManagerFacade;
    }

    public static String getTemporaryTableName(Context ctx, String desc) throws BOSException {
        String tableName = LiquidDataSetHelper.getTableManagerFacade(ctx).getTemporaryTableName(desc);
        if (tableName.length() > 30) {
            tableName = tableName.substring(0, 30);
        }
        return tableName;
    }

    public static void releaseTemporaryTableName(Context ctx, String tableName) throws BOSException {
        LiquidDataSetHelper.getTableManagerFacade(ctx).releaseTemporaryTableName(tableName);
    }

    public static String dateFormat(String dateString) {
        return "{ts'" + dateString + "'}";
    }

    public static String dateFormat(Date date) {
        return "{ts'" + DateUtil.DateToString((Date)date) + "'}";
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        SimpleTimer timer = new SimpleTimer();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        long time = timer.getTime();
        if (time > 500L) {
            String info = String.format("executeQuery:\n %s \n spend time: %s ms", sql, time);
            System.out.println(info);
            logger.info((Object)info);
        }
        return rowset;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        SimpleTimer timer = new SimpleTimer();
        DbUtil.execute((Context)ctx, (String)sql);
        long time = timer.getTime();
        if (time > 500L) {
            String info = String.format("execute:\n %s \n spend time: %s ms", sql, timer.getTime());
            System.out.println(info);
            logger.info((Object)info);
        }
    }

    public static String getCurrentLanguage(Context ctx) {
        return BOSLocaleUtil.getLocale((Context)ctx).getLanguage();
    }

    public static String getExchangeRateTable(Context ctx, String companyId, Date date, String flowTable) throws EASBizException, BOSException {
        String exchangeRateTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "EXCHANGE_RATE");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_EXCHANGE_RATE, exchangeRateTable));
        StringBuilder sqlBuilder = new StringBuilder();
        CompanyOrgUnitInfo companyInfo = LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, companyId);
        IRowSet rowSet = LiquidDataSetHelper.executeQuery(ctx, MessageFormat.format(SQL_COMPANY_CURRENCY, flowTable));
        try {
            while (rowSet.next()) {
                String currencyId = rowSet.getString("FCurrencyId");
                BigDecimal exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, currencyId, companyInfo, date);
                if (exchangeRate == null) continue;
                sqlBuilder.append(MessageFormat.format(SQL_INSERT_EXCHANGE_RATE, exchangeRateTable, currencyId, exchangeRate.toString()));
            }
            if (sqlBuilder.length() > 0) {
                LiquidDataSetHelper.execute(ctx, sqlBuilder.toString());
            }
            return exchangeRateTable;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getExchangeRateTable(Context ctx, Map<String, Object> filterParamMap, String flowTable) throws BOSException, EASBizException {
        Date date = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        String companyId = LiquidCompanyHelper.getLocalCompanyInfo(ctx, filterParamMap).getId().toString();
        try {
            return LiquidDataSetHelper.getExchangeRateTable(ctx, companyId, date, flowTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static Set<String> getAuthorizedOrgByUnion(Context ctx, String userId, String orgTreeId, Date date, String permItemName) throws EASBizException, BOSException {
        Set<String> authOrgIds = LiquidCompanyHelper.getAuthorizedOrg(ctx, userId, orgTreeId, permItemName);
        if (EmptyUtil.isEmpty((String)orgTreeId)) {
            return authOrgIds;
        }
        Set<String> authUnionOrgIds = LiquidCompanyHelper.getUnionUnitOfTree(ctx, userId, orgTreeId, date);
        String ksql = MessageFormat.format(SQL_ORG_UNIONS, orgTreeId, FMHelper.coll2String(authUnionOrgIds), FMHelper.coll2String(authOrgIds));
        IRowSet rowSet = LiquidDataSetHelper.executeQuery(ctx, ksql);
        try {
            while (rowSet.next()) {
                authUnionOrgIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return authUnionOrgIds;
    }

    public static String createCompanyTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String sql;
        String orgTreeId = (String)filterParamMap.get("orgUnionTreeId");
        boolean isOrgUnion = !EmptyUtil.isEmpty((String)orgTreeId);
        String currentLocaleString = LiquidDataSetHelper.getCurrentLanguage(ctx);
        String companyInfoTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "LIQUID_COMPANY");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_COMPANY, companyInfoTable, currentLocaleString, companyInfoTable.substring(4)));
        StringBuilder filterBulder = new StringBuilder();
        String companyId = (String)filterParamMap.get("parentCompanyId");
        CoreBaseInfo orgInfo = LiquidCompanyHelper.getOrgInfo(ctx, companyId);
        String companyLongNumber = LiquidCompanyHelper.getOrgLongNumber(ctx, orgInfo);
        if (LiquidCompanyHelper.isOrgLeaf(ctx, orgInfo)) {
            filterBulder.append(" AND FId = '").append(companyId).append("'");
            sql = MessageFormat.format(SQL_ORG_COMPANY_DATA, companyLongNumber, filterBulder.toString(), currentLocaleString);
        } else {
            String isIncludeSealCompany = (String)filterParamMap.get("isIncludeSealCompany");
            if (EmptyUtil.isEmpty((String)isIncludeSealCompany) || "false".equalsIgnoreCase(isIncludeSealCompany)) {
                filterBulder.append(" AND COMPANY.FIsSealUp = 0");
            }
            LiquidDataSetHelper.getAuthorizedOrgFilter(ctx, filterParamMap, orgTreeId, isOrgUnion, filterBulder);
            if (isOrgUnion) {
                String filter = MessageFormat.format(SQL_ORG_STRUCTURE_FILTER, filterBulder.toString());
                sql = MessageFormat.format(SQL_ORG_STRUCTURE_DATA, companyLongNumber, orgTreeId, filter, currentLocaleString);
            } else {
                String filter = MessageFormat.format(SQL_ORG_COMPANY_FILTER, filterBulder.toString());
                sql = MessageFormat.format(SQL_ORG_COMPANY_DATA, companyLongNumber, filter, currentLocaleString);
            }
        }
        String insertSql = MessageFormat.format(SQL_INSERT_FIELD_COMPANY, companyInfoTable, currentLocaleString);
        LiquidDataSetHelper.execute(ctx, insertSql + sql);
        return companyInfoTable;
    }

    private static void getAuthorizedOrgFilter(Context ctx, Map<String, Object> filterParamMap, String orgTreeId, boolean isOrgUnion, StringBuilder filterBulder) throws EASBizException, BOSException {
        UserInfo currentUserInfo;
        String isOrgPermission = (String)filterParamMap.get("isOrgPermission");
        if ((EmptyUtil.isEmpty((String)isOrgPermission) || isOrgPermission.equalsIgnoreCase("true")) && !EmptyUtil.isEmpty((CoreBaseInfo)(currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx)))) {
            String authCompanyids;
            Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
            String permItemName = (String)filterParamMap.get("companyPermItem");
            Set<String> authUnionOrgIds = LiquidDataSetHelper.getAuthorizedOrgByUnion(ctx, currentUserInfo.getId().toString(), orgTreeId, endDate, permItemName);
            String companyId = (String)filterParamMap.get("parentCompanyId");
            if (!EmptyUtil.isEmpty((String)companyId) && !authUnionOrgIds.contains(companyId)) {
                authUnionOrgIds.add(companyId);
            }
            if (EmptyUtil.isEmpty((String)(authCompanyids = FMHelper.coll2String(authUnionOrgIds)))) {
                authCompanyids = "('0000')";
            }
            if (isOrgUnion) {
                filterBulder.append("AND STRUCTURE.FUnitId IN ").append(authCompanyids);
            } else {
                filterBulder.append("AND FID IN ").append(authCompanyids);
            }
        }
    }
}

