/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CapitalHelper {
    public static Set<String> getPermissionOrgSet(Context ctx, String permissionName) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        OrgPermissionService service = new OrgPermissionService(ctx);
        FullOrgUnitCollection fullOrgUnitCollection = service.getAuthorizedOrg(ctx.getCaller(), (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"), permissionName);
        for (FullOrgUnitInfo fullOrgUnitInfo : fullOrgUnitCollection) {
            idSet.add(fullOrgUnitInfo.getId().toString());
        }
        if (idSet.size() > 0) {
            CapitalHelper.removeSealUpCompany(ctx, idSet);
        }
        return idSet;
    }

    public static List<CompanyOrgUnitInfo> getTopLevelCompanySet(Context ctx, Set<String> idSet) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        SorterItemInfo sortInfo1 = new SorterItemInfo("level");
        sortInfo1.setSortType(SortType.ASCEND);
        SorterItemInfo sortInfo2 = new SorterItemInfo("number");
        sortInfo2.setSortType(SortType.ASCEND);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSorter().add(sortInfo1);
        entityViewInfo.getSorter().add(sortInfo2);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityViewInfo);
        if (companyOrgUnitCollection.size() > 0) {
            CompanyOrgUnitInfo info;
            int level = companyOrgUnitCollection.get(0).getLevel();
            for (int i = 0; i < companyOrgUnitCollection.size() && (info = companyOrgUnitCollection.get(i)).getLevel() == level; ++i) {
                companyList.add(info);
            }
        }
        return companyList;
    }

    public static Set getInGroupAcctBankIds(Context ctx, Set companyIdSet) throws BOSException {
        Set bankIdSet = CapitalHelper.getClearingHouseIds(ctx, companyIdSet);
        if (bankIdSet == null) {
            return null;
        }
        return CapitalHelper.getInGroupAcctBankIds(ctx, companyIdSet, bankIdSet);
    }

    public static Set getClearingHouseIds(Context ctx, Set companyIdSet) throws BOSException {
        EntityViewInfo bankView = new EntityViewInfo();
        bankView.getSelector().add("id");
        bankView.getSelector().add("relatedCompany.id");
        FilterInfo bankFilter = new FilterInfo();
        bankFilter.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
        if (companyIdSet != null) {
            bankFilter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyIdSet, CompareType.INCLUDE));
        }
        bankView.setFilter(bankFilter);
        BankCollection bankcoll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(bankView);
        if (bankcoll == null || bankcoll.size() <= 0) {
            return null;
        }
        HashSet<String> bankIdSet = new HashSet<String>();
        for (int i = 0; i < bankcoll.size(); ++i) {
            bankIdSet.add(bankcoll.get(i).getId().toString());
        }
        return bankIdSet;
    }

    public static Set getInGroupAcctBankIds(Context ctx, Set companyIdSet, Set bankIdSet) throws BOSException {
        EntityViewInfo acctBankView = new EntityViewInfo();
        acctBankView.getSelector().add("id");
        FilterInfo acctBankFilter = new FilterInfo();
        acctBankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        acctBankFilter.getFilterItems().add(new FilterItemInfo("company.isFreeze", (Object)new Boolean(false)));
        acctBankFilter.getFilterItems().add(new FilterItemInfo("company.isSealUp", (Object)new Boolean(false)));
        acctBankFilter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankIdSet, CompareType.INCLUDE));
        acctBankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
        acctBankView.setFilter(acctBankFilter);
        AccountBankCollection acctBankcoll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(acctBankView);
        if (acctBankcoll == null || acctBankcoll.size() <= 0) {
            return null;
        }
        HashSet<String> acctBankIdSet = new HashSet<String>();
        for (int i = 0; i < acctBankcoll.size(); ++i) {
            acctBankIdSet.add(acctBankcoll.get(i).getId().toString());
        }
        return acctBankIdSet;
    }

    public static Set getAllInGroupAcctBankIds(Context ctx, Set companyIdSet) throws BOSException {
        Set bankIdSet = CapitalHelper.getClearingHouseIds(ctx, null);
        if (bankIdSet == null) {
            return null;
        }
        return CapitalHelper.getInGroupAcctBankIds(ctx, companyIdSet, bankIdSet);
    }

    public static String setToString(Set set) {
        ArrayList list = new ArrayList(set);
        StringBuffer ids = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String id = (String)list.get(i);
                ids.append("'");
                ids.append(id);
                ids.append("'");
                if (i >= list.size() - 1) continue;
                ids.append(",");
            }
        }
        return ids.toString();
    }

    public static String getInGroupAcctBankIds(Context ctx, String longnumber) throws BOSException {
        Set companyIdSet = CapitalHelper.getCompanyIdSet(ctx, longnumber);
        Set acctBankIdSet = CapitalHelper.getInGroupAcctBankIds(ctx, companyIdSet);
        if (acctBankIdSet == null) {
            return null;
        }
        String acctBankIds = CapitalHelper.setToString(acctBankIdSet);
        return acctBankIds;
    }

    public static String getLongnumber(Context ctx, String companyId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("longnumber");
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        String longnumber = companyInfo.getLongNumber();
        return longnumber;
    }

    public static Set getCompanyIdSet(Context ctx, String longnumber) throws BOSException {
        String oql = "SELECT id where ( longnumber like '" + longnumber + "!%' or longnumber= '" + longnumber + "' ) and isFreeze=0 and isSealUp=0";
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(oql);
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < companyColl.size(); ++i) {
            companyIdSet.add(companyColl.get(i).getId().toString());
        }
        return companyIdSet;
    }

    public static String ListToString(List list) {
        StringBuffer ids = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String id = ((CompanyOrgUnitInfo)list.get(i)).getId().toString();
                ids.append(id);
                if (i >= list.size() - 1) continue;
                ids.append(",");
            }
        }
        return ids.toString();
    }

    public static String getAcctBankIds(Context ctx, String orgIds) throws BOSException, EASBizException {
        Set companyIdSet = CapitalHelper.getCompanySet(ctx, orgIds);
        String acctBankIds = null;
        if (companyIdSet != null) {
            Set acctBankIdSet = CapitalHelper.getInGroupAcctBankIds(ctx, companyIdSet);
            if (acctBankIdSet == null) {
                return null;
            }
            acctBankIds = CapitalHelper.setToString(acctBankIdSet);
        }
        return acctBankIds;
    }

    public static Set getCompanySet(Context ctx, String orgIds) throws EASBizException, BOSException {
        if (orgIds == null || orgIds.length() <= 0) {
            return null;
        }
        String[] companyArray = orgIds.split(",");
        HashSet companyIdSet = new HashSet();
        for (int i = 0; i < companyArray.length; ++i) {
            String longnumber = CapitalHelper.getLongnumber(ctx, companyArray[i]);
            Set companySet = CapitalHelper.getCompanyIdSet(ctx, longnumber);
            companyIdSet.addAll(companySet);
        }
        return companyIdSet;
    }

    public static Set getCompanyIdSet(Context ctx, List<CompanyOrgUnitInfo> companyList) throws EASBizException, BOSException {
        HashSet companyIdSet = new HashSet();
        for (int i = 0; i < companyList.size(); ++i) {
            String longnumber = companyList.get(i).getLongNumber();
            Set companySet = CapitalHelper.getCompanyIdSet(ctx, longnumber);
            companyIdSet.addAll(companySet);
        }
        return companyIdSet;
    }

    private static AccountBankCollection getSharedAccountBankColl(Context ctx, Set<String> companyIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("shareAcct.id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.isFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("company.isSealUp", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("shareAcct.id", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        AccountBankCollection acctBankcoll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return acctBankcoll;
    }

    public static Set<String> getSharedAcctBankIds(Context ctx, Set<String> companyIdSet) throws BOSException {
        AccountBankCollection acctBankcoll = CapitalHelper.getSharedAccountBankColl(ctx, companyIdSet);
        if (acctBankcoll == null || acctBankcoll.size() <= 0) {
            return null;
        }
        HashSet<String> sharedAcctBankIdSet = new HashSet<String>();
        for (int i = 0; i < acctBankcoll.size(); ++i) {
            sharedAcctBankIdSet.add(acctBankcoll.get(i).getId().toString());
        }
        return sharedAcctBankIdSet;
    }

    private static Set<String> getShareAcctIdSet(Context ctx, Set<String> companyIdSet) throws BOSException {
        AccountBankCollection acctBankcoll = CapitalHelper.getSharedAccountBankColl(ctx, companyIdSet);
        if (acctBankcoll == null || acctBankcoll.size() <= 0) {
            return null;
        }
        HashSet<String> shareAcctIdSet = new HashSet<String>();
        for (int i = 0; i < acctBankcoll.size(); ++i) {
            shareAcctIdSet.add(acctBankcoll.get(i).getShareAcct().getId().toString());
        }
        return shareAcctIdSet;
    }

    private static SharedAcctEntriesCollection getSharedAcctEntriesCollection(Context ctx, Set<String> companyIdSet) throws BOSException {
        Set<String> shareAcctIdSet = CapitalHelper.getShareAcctIdSet(ctx, companyIdSet);
        if (shareAcctIdSet == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("parent.bankAccount.id");
        view.getSelector().add("accountBank.id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sharedCompany.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("sharedCompany.isFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("sharedCompany.isSealUp", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("accountBank.isClosed", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", shareAcctIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SharedAcctEntriesCollection shareColl = SharedAcctEntriesFactory.getLocalInstance((Context)ctx).getSharedAcctEntriesCollection(view);
        return shareColl;
    }

    public static Set<String> getUserAcctBankIds(Context ctx, Set<String> companyIdSet) throws BOSException {
        SharedAcctEntriesCollection shareColl = CapitalHelper.getSharedAcctEntriesCollection(ctx, companyIdSet);
        if (shareColl == null || shareColl.size() <= 0) {
            return null;
        }
        HashSet<String> userAcctBankIdSet = new HashSet<String>();
        for (int i = 0; i < shareColl.size(); ++i) {
            userAcctBankIdSet.add(shareColl.get(i).getAccountBank().getId().toString());
        }
        return userAcctBankIdSet;
    }

    public static Map<String, List<String>> getShare_UserMap(Context ctx, Set<String> companyIdSet) throws BOSException {
        SharedAcctEntriesCollection shareColl = CapitalHelper.getSharedAcctEntriesCollection(ctx, companyIdSet);
        if (shareColl == null || shareColl.size() <= 0) {
            return null;
        }
        HashMap<String, List<String>> share_UserMap = new HashMap<String, List<String>>();
        for (int i = 0; i < shareColl.size(); ++i) {
            String sharedAcctBankId = shareColl.get(i).getParent().getBankAccount().getId().toString();
            String userAcctBankId = shareColl.get(i).getAccountBank().getId().toString();
            ArrayList<String> userAcctList = (ArrayList<String>)share_UserMap.get(sharedAcctBankId);
            if (userAcctList == null) {
                userAcctList = new ArrayList<String>();
                share_UserMap.put(sharedAcctBankId, userAcctList);
            }
            userAcctList.add(userAcctBankId);
        }
        return share_UserMap;
    }

    public static CompanyOrgUnitInfo getDefaultCompany(Context ctx, List<CompanyOrgUnitInfo> companyList) throws EASBizException, BOSException {
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        String companyId = user.getCU().getId().toString();
        for (CompanyOrgUnitInfo company : companyList) {
            if (!company.getId().toString().equals(companyId)) continue;
            return company;
        }
        return companyList.get(0);
    }

    private static void removeSealUpCompany(Context ctx, Set<String> idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Boolean(false)));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll != null && coll.size() > 0) {
            idSet.clear();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
        }
    }
}

