/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.AbstractFMMobileFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.MobileConfig;
import com.kingdee.eas.fm.mobile.app.datarecorder.DataRecorder;
import com.kingdee.eas.fm.mobile.app.datarecorder.PerformanceLogger;
import com.kingdee.eas.fm.mobile.process.CenterProcessor;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.ErrorMessageUtil;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class FMMobileFacadeControllerBean
extends AbstractFMMobileFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.FMMobileFacadeControllerBean");

    @Override
    protected ResultInfo _doBizProcess(Context ctx, String appName, String deviceType, String bizName, String version, String bizData) throws BOSException {
        String requestMessage = this.requestMessage(appName, deviceType, bizName, version, bizData);
        logger.debug((Object)String.format("FMMobileFacade\u5904\u7406\u79fb\u52a8\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5185\u5bb9\uff1a\u3010%s\u3011", requestMessage));
        try {
            PerformanceLogger perLog = new PerformanceLogger();
            perLog.beginDate();
            CenterProcessor centerProcessor = new CenterProcessor(appName, deviceType, bizName, version);
            ResultInfo resultInfo = centerProcessor.doProcess(ctx, bizData);
            perLog.endDate();
            if (!"configureParameter".equals(bizName)) {
                this.noteRequestAndResponse(ctx, requestMessage, resultInfo, perLog);
            }
            return resultInfo;
        }
        catch (EASBizException e) {
            String msg = this.buildLogMessage(requestMessage, e);
            logger.error((Object)msg, (Throwable)e);
            if (!"configureParameter".equals(bizName)) {
                this.noteRequestAndException(ctx, requestMessage, msg);
            }
            return ErrorMessageUtil.getResultInfo(Integer.parseInt(e.getMainCode() + e.getSubCode()), msg);
        }
    }

    private void noteRequestAndResponse(Context ctx, String requestMessage, ResultInfo resultInfo, PerformanceLogger perLog) {
        if (!MobileConfig.isOpenDebugExceptionMessage) {
            return;
        }
        DataRecorder dataRecorder = DataRecorder.getInstance();
        dataRecorder.record(ctx.getContextID() + ":" + ctx.get((Object)"appClientId"), DataRecorder.SUCCESS, requestMessage, this.toJsonString(resultInfo), perLog);
    }

    private String toJsonString(ResultInfo resultInfo) {
        JSONObject resultInfoJSONObject = JSONObject.fromObject((Object)resultInfo);
        return resultInfoJSONObject.toString();
    }

    private void noteRequestAndException(Context ctx, String requestMessage, String msg) {
        if (!MobileConfig.isOpenDebugExceptionMessage) {
            return;
        }
        DataRecorder dataRecorder = DataRecorder.getInstance();
        dataRecorder.record(ctx.getContextID() + ":" + ctx.get((Object)"appClientId"), DataRecorder.ERROR, requestMessage, msg);
    }

    private String buildLogMessage(String requestMessage, EASBizException e) {
        if (MobileConfig.isOpenDebugExceptionMessage) {
            return String.format("\u3010%s\u3011\uff1a%s", requestMessage, e.getMessage());
        }
        return e.getMessage();
    }

    private String requestMessage(String appName, String deviceType, String bizName, String version, String bizData) {
        return String.format("%s_%s_%s_%s_%s", appName, deviceType, bizName, version, bizData);
    }
}

