/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight.mock;

import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.SortableLine;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class RankingMockData {
    private static RankingMockData instance = null;
    private List<SortableLine> list = new ArrayList<SortableLine>();

    private RankingMockData() {
    }

    public static RankingMockData getInstance() {
        if (instance == null) {
            instance = new RankingMockData();
        }
        return instance;
    }

    public void build() {
    }

    public void add(SortableLine line) {
        this.list.add(line);
    }

    public List<SortableLine> getAmountYearList(final String direction) {
        Collections.sort(this.list, (Comparator)new Comparator<SortableLine>(){

            @Override
            public int compare(SortableLine o1, SortableLine o2) {
                int compareTo = o1.getAmountYear().compareTo(o2.getAmountYear());
                if (direction.equals("DESC_TOP_N")) {
                    return -1 * compareTo;
                }
                return compareTo;
            }
        });
        return this.list;
    }

    public List<SortableLine> getAmountMonthList(final String direction) {
        Collections.sort(this.list, (Comparator)new Comparator<SortableLine>(){

            @Override
            public int compare(SortableLine o1, SortableLine o2) {
                int compareTo = o1.getAmountMonth().compareTo(o2.getAmountMonth());
                if (direction.equals("DESC_TOP_N")) {
                    return -1 * compareTo;
                }
                return compareTo;
            }
        });
        return this.list;
    }

    public List<SortableLine> getBalanceList(final String direction) {
        Collections.sort(this.list, (Comparator)new Comparator<SortableLine>(){

            @Override
            public int compare(SortableLine o1, SortableLine o2) {
                int compareTo = o1.getBalance().compareTo(o2.getBalance());
                if (direction.equals("DESC_TOP_N")) {
                    return -1 * compareTo;
                }
                return compareTo;
            }
        });
        return this.list;
    }

    public BigDecimal getAmountYearTotal() {
        BigDecimal sum = new BigDecimal("0");
        for (SortableLine line : this.list) {
            sum = sum.add(line.getAmountYear());
        }
        return sum;
    }

    public BigDecimal getAmountMonthTotal() {
        BigDecimal sum = new BigDecimal("0");
        for (SortableLine line : this.list) {
            sum = sum.add(line.getAmountMonth());
        }
        return sum;
    }

    public BigDecimal getBalanceTotal() {
        BigDecimal sum = new BigDecimal("0");
        for (SortableLine line : this.list) {
            sum = sum.add(line.getBalance());
        }
        return sum;
    }
}

