/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.datarecorder;

import com.kingdee.eas.fm.mobile.app.datarecorder.DataRecordLine;
import com.kingdee.eas.fm.mobile.app.datarecorder.PerformanceLogger;
import com.kingdee.eas.fm.mobile.app.datarecorder.RecordList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataRecorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String ERROR = "ERROR";
    public static String SUCCESS = "SUCCESS";
    private static DataRecorder dataRecorder = null;
    private Map<String, RecordList> data = new HashMap<String, RecordList>();
    private int index = 0;

    private DataRecorder() {
    }

    public static DataRecorder getInstance() {
        if (dataRecorder == null) {
            dataRecorder = new DataRecorder();
        }
        return dataRecorder;
    }

    public void record(String key, String type, String request, String response) {
        this.record(key, type, request, response, null);
    }

    public void record(String key, String type, String request, String response, PerformanceLogger perLog) {
        RecordList recordList = this.getAndInitList(key);
        recordList.add(new DataRecordLine(recordList.size() + 1, type, request, response, perLog));
        this.clearData(1000);
    }

    private void clearData(int count) {
        if (++this.index == count) {
            this.index = 0;
            this.clearData();
        }
    }

    public void clearData() {
        this.data.clear();
    }

    private RecordList getAndInitList(String key) {
        RecordList recordList = this.data.get(key);
        if (recordList == null) {
            recordList = new RecordList();
            this.data.put(key, recordList);
        }
        return recordList;
    }

    public Map<String, RecordList> getDataRecorder() {
        return this.data;
    }

    public RecordList getRecordListByKey(String Key) {
        return this.data.get(Key);
    }
}

