/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundflow.AbstractGetBizBillWithTopNFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FuncGetBizBillWithTopN;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.TopNMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsorFactory;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GetBizBillWithTopNFacadeControllerBean
extends AbstractGetBizBillWithTopNFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundflow.GetBizBillWithTopNFacadeControllerBean");
    private int index = 1;

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "period");
        ValidateUtil.validateParam(bizData, "orgID");
        String period = (String)bizData.get("period");
        String orgID = (String)bizData.get("orgID");
        String flowItemID = (String)bizData.get("flowItemID");
        if (MockConfig.isOpenFundFlowMock) {
            TopNMockDataBuilder.init();
            return new FuncGetBizBillWithTopN().execute(period, orgID, flowItemID);
        }
        PeriodParsorFactory factory = new PeriodParsorFactory(bizData);
        PeriodParsor periodParsor = factory.makePeriodParsor();
        ResultInfo resultInfo = new ResultInfo();
        try {
            resultInfo.put("listData", this.buildListData(ctx, orgID, flowItemID, periodParsor));
            this.resetRate((List)resultInfo.getData().get("listData"));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private void resetRate(List<Map<String, Object>> listData) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map<String, Object> row : listData) {
            sum = sum.add((BigDecimal)row.get("descBalance"));
        }
        for (Map<String, Object> row : listData) {
            BigDecimal divide = ((BigDecimal)row.get("descBalance")).divide(sum, 2, RoundingMode.HALF_UP);
            row.put("rate", divide);
        }
    }

    private List<Map<String, Object>> buildListData(Context ctx, String orgID, String flowItemID, PeriodParsor periodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> filterParamMap = new HashMap<String, Object>();
        filterParamMap.put("parentCompanyId", orgID);
        filterParamMap.put("beginDate", DateUtils.formatDate(periodParsor.getBeginDate()));
        filterParamMap.put("endDate", DateUtils.formatDate(periodParsor.getEndDate()));
        filterParamMap.put("flowItemIdSet", this.makeSet(flowItemID));
        filterParamMap.put("topCount", "10");
        filterParamMap.put("companyPermItem", "CAPITAL_INSIGHT_USE");
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 5);
        return this.buildRows(rs);
    }

    private Set<String> makeSet(String flowItemID) {
        HashSet<String> flowItemIdSet = new HashSet<String>();
        flowItemIdSet.add(flowItemID);
        return flowItemIdSet;
    }

    private List<Map<String, Object>> buildRows(IRowSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            Date bizDate = rs.getDate("FBizDate");
            String srcCurrency = rs.getString("FCurrencyName");
            BigDecimal srcBalance = rs.getBigDecimal("FBALANCE");
            String descCurrency = rs.getString("FLocalCurrencyName");
            BigDecimal descBalance = rs.getBigDecimal("FLOCALBALANCE");
            BigDecimal rate = BigDecimal.ZERO;
            String company = rs.getString("FCompanyName");
            String openBank = rs.getString("FOpenBankName");
            String accountBank = rs.getString("FBankAccountNumber");
            String otherCompany = rs.getString("FOppUnit");
            String otherAccountBank = rs.getString("FOppAcctNumber");
            String memo = rs.getString("FDescription");
            rows.add(this.buildRow(bizDate, srcCurrency, srcBalance, descCurrency, descBalance, rate, company, openBank, accountBank, otherCompany, otherAccountBank, memo));
        }
        return rows;
    }

    private Map<String, Object> buildRow(java.util.Date bizDate, String srcCurrency, BigDecimal srcBalance, String descCurrency, BigDecimal descBalance, BigDecimal rate, String company, String openBank, String accountBank, String otherCompany, String otherAccountBank, String memo) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", this.index++);
        row.put("bizDate", bizDate == null ? null : DateUtils.formatDate(bizDate));
        row.put("srcCurrency", srcCurrency);
        row.put("srcBalance", srcBalance);
        row.put("descCurrency", descCurrency);
        row.put("descBalance", descBalance);
        row.put("rate", rate);
        row.put("company", this.buildCompany(company));
        row.put("openBank", openBank);
        row.put("accountBank", accountBank);
        row.put("otherCompany", otherCompany);
        row.put("otherAccountBank", otherAccountBank);
        row.put("memo", memo);
        return row;
    }

    private String buildCompany(String company) {
        if (StringUtil.isEmpty(company)) {
            return "\u5176\u4ed6";
        }
        return company;
    }
}

