/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundflow.AbstractGetFlowTrendFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FuncGetFlowTrend;
import com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse.TrendPeriodParsor;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsorFactory;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BillDebugUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetFlowTrendFacadeControllerBean
extends AbstractGetFlowTrendFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundflow.GetFlowTrendFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "period");
        ValidateUtil.validateParam(bizData, "orgID");
        String orgID = (String)bizData.get("orgID");
        String flowItemID = (String)bizData.get("flowItemID");
        String period = (String)bizData.get("period");
        if (MockConfig.isOpenFundFlowMock) {
            FundReverseMockDataBuilder.init();
            return new FuncGetFlowTrend().execute(period, orgID, flowItemID);
        }
        PeriodParsorFactory factory = new PeriodParsorFactory(bizData);
        TrendPeriodParsor trendPeriodParsor = factory.makeTrendPeriodParsor();
        ResultInfo resultInfo = new ResultInfo();
        try {
            resultInfo.put("trendData", this.buildTrendData(ctx, orgID, flowItemID, trendPeriodParsor));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private Map<String, Object> buildTrendData(Context ctx, String orgID, String flowItemID, TrendPeriodParsor trendPeriodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> trendData = new HashMap<String, Object>();
        logger.info((Object)"\u7b2c\u4e00\u6761\u7ebf");
        trendData.put("thisPeriod", this.buildOneLine(ctx, orgID, flowItemID, trendPeriodParsor));
        logger.info((Object)"\u7b2c\u4e8c\u6761\u7ebf");
        trendData.put("previousPeriod", this.buildOneLine(ctx, orgID, flowItemID, trendPeriodParsor.previousTrend()));
        return trendData;
    }

    private List<Map<String, Object>> buildOneLine(Context ctx, String orgID, String flowItemID, TrendPeriodParsor trendPeriodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> filterParamMap = new HashMap<String, Object>();
        filterParamMap.put("parentCompanyId", orgID);
        filterParamMap.put("flowParentItemId", flowItemID);
        filterParamMap.put("beginDate", DateUtils.formatDate(trendPeriodParsor.getBeginDate()));
        filterParamMap.put("endDate", DateUtils.formatDate(trendPeriodParsor.getEndDate()));
        filterParamMap.put("queryCycle", String.valueOf(trendPeriodParsor.getBgPeriod()));
        filterParamMap.put("companyPermItem", "CAPITAL_INSIGHT_USE");
        logger.info((Object)BillDebugUtils.showMap("FundFlowFacadeFactory.getLocalInstance(ctx).getFlowDataForMobile(filterParamMap, LiquidConstant.QUERY_MOBILE_PERIOD_FLOWITEM)", filterParamMap));
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 4);
        logger.info((Object)BillDebugUtils.showIRowSet(rs));
        return this.buildPoints(rs, trendPeriodParsor);
    }

    private List<Map<String, Object>> buildPoints(IRowSet rs, TrendPeriodParsor trendPeriodParsor) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        int index = 0;
        while (rs.next()) {
            String name = trendPeriodParsor.getName(index);
            int flowItemDirection = rs.getInt("FFlowItemDirection");
            BigDecimal amount = this.calcAmount(rs.getBigDecimal("FLocalIncomeAmount"), rs.getBigDecimal("FLocalOutcomeAmount"), flowItemDirection);
            rows.add(this.buildPoint(name, amount));
            ++index;
        }
        return rows;
    }

    private BigDecimal calcAmount(BigDecimal flowIn, BigDecimal flowOut, int flowItemDirection) {
        if (flowIn == null) {
            flowIn = BigDecimal.ZERO;
        }
        if (flowOut == null) {
            flowOut = BigDecimal.ZERO;
        }
        if (flowItemDirection == 0) {
            return flowIn.subtract(flowOut);
        }
        if (flowItemDirection == 1) {
            return flowIn;
        }
        return flowOut;
    }

    private Map<String, Object> buildPoint(String name, BigDecimal amount) {
        HashMap<String, Object> point = new HashMap<String, Object>();
        point.put("name", name);
        point.put("amount", amount);
        return point;
    }
}

