/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundflow.AbstractGetListDataFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundflow.FlowItemDirectionUtils;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FundFlowMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.GetListData;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsorFactory;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetListDataFacadeControllerBean
extends AbstractGetListDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundflow.GetListDataFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "period");
        ValidateUtil.validateParam(bizData, "orgID");
        String period = (String)bizData.get("period");
        String orgID = (String)bizData.get("orgID");
        String flowItemID = (String)bizData.get("flowItemID");
        if (MockConfig.isOpenFundFlowMock) {
            FundReverseMockDataBuilder.init();
            FundFlowMockDataBuilder.init();
            return new GetListData().execute(period, orgID, flowItemID);
        }
        PeriodParsorFactory factory = new PeriodParsorFactory(bizData);
        PeriodParsor periodParsor = factory.makePeriodParsor();
        ResultInfo resultInfo = new ResultInfo();
        try {
            resultInfo.put("dataList", this.buildRows(ctx, orgID, flowItemID, periodParsor));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    protected List<Map<String, Object>> buildRows(Context ctx, String orgID, String flowItemID, PeriodParsor periodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        filterParamMap.put("parentCompanyId", orgID);
        filterParamMap.put("flowParentItemId", flowItemID);
        filterParamMap.put("beginDate", DateUtils.formatDate(periodParsor.getBeginDate()));
        filterParamMap.put("endDate", DateUtils.formatDate(periodParsor.getEndDate()));
        filterParamMap.put("queryCycle", String.valueOf(periodParsor.getBgPeriod()));
        filterParamMap.put("companyPermItem", "CAPITAL_INSIGHT_USE");
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 2);
        List<Map<String, Object>> rows = this.buildRows(rs);
        if (StringUtil.isEmpty(flowItemID)) {
            this.calcFirstOrgRow(rows, this.getBeginningOfThePeriod(ctx, orgID, periodParsor.getBeginDate()), this.getEndOfThePeriod(ctx, orgID, periodParsor.getEndDate()));
        } else {
            this.calcFirstRow(ctx, rows, flowItemID);
        }
        return rows;
    }

    private void calcFirstOrgRow(List<Map<String, Object>> rows, BigDecimal beginningOfThePeriod, BigDecimal endOfThePeriod) {
        boolean isLeaf = false;
        String type = "ALL";
        BigDecimal inFlowSum = BigDecimal.ZERO;
        BigDecimal outFlowSum = BigDecimal.ZERO;
        BigDecimal previousPeriodSum = BigDecimal.ZERO;
        BigDecimal thisPeriodSum = BigDecimal.ZERO;
        for (Map<String, Object> row : rows) {
            inFlowSum = inFlowSum.add((BigDecimal)row.get("inFlows"));
            outFlowSum = outFlowSum.add((BigDecimal)row.get("outFlows"));
            previousPeriodSum = previousPeriodSum.add((BigDecimal)row.get("previousPeriod"));
            thisPeriodSum = thisPeriodSum.add((BigDecimal)row.get("thisPeriod"));
            this.replaceFlowItemName(row);
        }
        rows.add(0, this.buildFirstOrgRow(beginningOfThePeriod, endOfThePeriod, false, "ALL", inFlowSum, outFlowSum, previousPeriodSum, thisPeriodSum));
    }

    private void replaceFlowItemName(Map<String, Object> row) {
        String flowItemName = (String)row.get("flowItemName");
        row.put("flowItemName", flowItemName.replaceAll("\u4ea7\u751f\u7684", ""));
    }

    private BigDecimal getBeginningOfThePeriod(Context ctx, String orgID, Date date) throws EASBizException, BOSException {
        CompanyLiquidInfo companyLiquidInfo = this.accessDataWithTopLevelCompanyOrgUnit(ctx, orgID, date);
        if (companyLiquidInfo.isHaveBalance()) {
            // empty if block
        }
        return companyLiquidInfo.getLocalBalance();
    }

    private BigDecimal getEndOfThePeriod(Context ctx, String orgID, Date date) throws EASBizException, BOSException {
        CompanyLiquidInfo companyLiquidInfo = this.accessDataWithTopLevelCompanyOrgUnit(ctx, orgID, date);
        return companyLiquidInfo.getLocalBalance();
    }

    private CompanyLiquidInfo accessDataWithTopLevelCompanyOrgUnit(Context ctx, String companyID, Date date) throws BOSException, EASBizException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getCompanyBalanceAndLimtsByCompamy(companyID, date);
        CompanyLiquidInfo companyLiquidInfo = (CompanyLiquidInfo)resultMap.get(companyID);
        return companyLiquidInfo;
    }

    private void calcFirstRow(Context ctx, List<Map<String, Object>> rows, String flowItemID) throws EASBizException, BOSException {
        FundFlowItemInfo fundFlowItemInfo = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(flowItemID));
        String flowItemId = fundFlowItemInfo.getId().toString();
        String flowItemName = fundFlowItemInfo.getName();
        boolean isLeaf = false;
        String type = FlowItemDirectionUtils.getFlowItemDirection(fundFlowItemInfo.getDirection().getValue());
        BigDecimal inFlowSum = BigDecimal.ZERO;
        BigDecimal outFlowSum = BigDecimal.ZERO;
        BigDecimal previousPeriodSum = BigDecimal.ZERO;
        BigDecimal thisPeriodSum = BigDecimal.ZERO;
        for (Map<String, Object> row : rows) {
            inFlowSum = inFlowSum.add((BigDecimal)row.get("inFlows"));
            outFlowSum = outFlowSum.add((BigDecimal)row.get("outFlows"));
            previousPeriodSum = previousPeriodSum.add((BigDecimal)row.get("previousPeriod"));
            thisPeriodSum = thisPeriodSum.add((BigDecimal)row.get("thisPeriod"));
        }
        rows.add(0, this.buildRow(flowItemId, flowItemName, false, type, inFlowSum, outFlowSum, previousPeriodSum, thisPeriodSum));
    }

    private List<Map<String, Object>> buildRows(IRowSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            String flowItemId = rs.getString("FFlowItemId");
            String flowItemName = rs.getString("FFlowItemName");
            boolean isLeaf = rs.getInt("FFlowItemIsLeaf") == 1;
            String type = FlowItemDirectionUtils.getFlowItemDirection(rs.getInt("FFlowItemDirection"));
            BigDecimal inFlows = rs.getBigDecimal("FLocalIncomeAmount");
            BigDecimal outFlows = rs.getBigDecimal("FLocalOutcomeAmount");
            BigDecimal previousPeriod = FlowItemDirectionUtils.calcAmount(rs.getBigDecimal("FLocalLastYearPeriodIncoming"), rs.getBigDecimal("FLocalLastYearPeriodOutcoming"), type);
            BigDecimal thisPeriod = FlowItemDirectionUtils.calcAmount(inFlows, outFlows, type);
            rows.add(this.buildRow(flowItemId, flowItemName, isLeaf, type, inFlows, outFlows, previousPeriod, thisPeriod));
        }
        return rows;
    }

    private Map<String, Object> buildFirstOrgRow(BigDecimal beginningOfThePeriod, BigDecimal endOfThePeriod, boolean isLeaf, String type, BigDecimal inFlows, BigDecimal outFlows, BigDecimal previousPeriod, BigDecimal thisPeriod) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("beginningOfThePeriod", beginningOfThePeriod);
        row.put("endOfThePeriod", endOfThePeriod);
        row.put("isLeaf", isLeaf);
        row.put("type", type);
        row.put("thisPeriod", thisPeriod);
        row.put("previousPeriod", previousPeriod);
        row.put("inFlows", inFlows);
        row.put("outFlows", outFlows);
        return row;
    }

    private Map<String, Object> buildRow(String flowItemId, String flowItemName, boolean isLeaf, String type, BigDecimal inFlows, BigDecimal outFlows, BigDecimal previousPeriod, BigDecimal thisPeriod) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("flowItemID", flowItemId);
        row.put("flowItemName", flowItemName);
        row.put("isLeaf", isLeaf);
        row.put("type", type);
        row.put("thisPeriod", thisPeriod);
        row.put("previousPeriod", previousPeriod);
        row.put("inFlows", inFlows);
        row.put("outFlows", outFlows);
        return row;
    }
}

