/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.mock;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.DateMockUtil;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtil;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FuncGetFlowTrend {
    private static final String[] week_day = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final String[] month_week = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
    private static final String[] quarter_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private static final String[] year_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};

    public ResultInfo execute(String period, String orgID, String flowItemID) throws EASBizException {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("trendData", this.buildTrendData(orgID, period));
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private Map buildTrendData(String mainID, String period) {
        BigDecimal blance;
        OrgInfo orgInfo = FundReverseMockData.getInstance().getByOrgID(mainID);
        if (orgInfo == null) {
            BankInfo bankInfo = FundReverseMockData.getInstance().getByBankID(mainID);
            if (bankInfo == null) {
                AccountInfo accountInfo = FundReverseMockData.getInstance().getAccountID(mainID);
                blance = accountInfo.getDescBalance();
            } else {
                blance = bankInfo.getBalance();
            }
        } else {
            blance = orgInfo.getBalance();
        }
        HashMap<String, String> trendData = new HashMap<String, String>();
        trendData.put("period", period);
        if (period.equals("WEEK")) {
            this.makeWeekDay(blance, trendData);
        } else if (period.equals("MONTH")) {
            this.makeMonthWeek(blance, trendData);
        } else if (period.equals("QUARTER")) {
            this.makeQuarterMonth(blance, trendData);
        } else {
            this.makeYearMonth(blance, trendData);
        }
        return trendData;
    }

    private void makeYearMonth(BigDecimal blance, Map trendData) {
        int days = DateMockUtil.getYearMonth(new Date());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < days; ++i) {
            if (i == days - 1) {
                arrayList.add(this.buildPoint(year_month[i], blance));
                continue;
            }
            BigDecimal makeData = BigDecimalUtil.makeData(blance);
            arrayList.add(this.buildPoint(year_month[i], makeData));
        }
        trendData.put("values", arrayList);
    }

    private void makeQuarterMonth(BigDecimal blance, Map trendData) {
        int begin = DateMockUtil.getQuarterMonthBegin(new Date());
        int days = DateMockUtil.getQuarterMonthEnd(new Date());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = begin; i <= days; ++i) {
            if (i == days) {
                arrayList.add(this.buildPoint(quarter_month[i - 1], blance));
                continue;
            }
            BigDecimal makeData = BigDecimalUtil.makeData(blance);
            arrayList.add(this.buildPoint(quarter_month[i - 1], makeData));
        }
        trendData.put("values", arrayList);
    }

    private void makeMonthWeek(BigDecimal blance, Map trendData) {
        int days = DateMockUtil.getMonthWeek(new Date());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < days; ++i) {
            if (i == days - 1) {
                arrayList.add(this.buildPoint(month_week[i], blance));
                continue;
            }
            BigDecimal makeData = BigDecimalUtil.makeData(blance);
            arrayList.add(this.buildPoint(month_week[i], makeData));
        }
        trendData.put("values", arrayList);
    }

    private void makeWeekDay(BigDecimal blance, Map trendData) {
        int days = DateMockUtil.getWeekDay(new Date());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < days; ++i) {
            if (i == days - 1) {
                arrayList.add(this.buildPoint(week_day[i], blance));
                continue;
            }
            BigDecimal makeData = BigDecimalUtil.makeData(blance);
            arrayList.add(this.buildPoint(week_day[i], makeData));
        }
        trendData.put("values", arrayList);
    }

    private Object buildPoint(String name, BigDecimal value) {
        HashMap<String, Object> point = new HashMap<String, Object>();
        point.put("name", name);
        point.put("amount", value);
        return point;
    }
}

