/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.mock;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FlowItemMock;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FundFlowMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FileLoader;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class FundFlowMockDataBuilder {
    public static final int FLOW_ITEM_ID = 0;
    public static final int FLOW_ITEM_NAME = 1;
    public static final int FLOW_ITEM_TYPE = 2;
    public static final int BEGINNING_OF_THE_PERIOD = 3;
    public static final int THIS_PERIOD_YEAR = 4;
    public static final int PREVIOUS_PERIOD_YEAR = 5;
    public static final int RATE_YEAR = 6;
    public static final int PREVIOUS_PERIOD_MONTH = 7;
    public static final int THISPERIOD_MONTH = 8;
    public static final int RATE_MONTH = 9;
    private static FundFlowMockDataBuilder instance = null;
    private List<Object[]> data = new ArrayList<Object[]>();
    private static String[] ID_LIST = new String[]{"\u4e00\u3001", "\u4e8c\u3001", "\u4e09\u3001", "\u56db\u3001", "\u4e94\u3001", "\u516d\u3001", "\u4e03\u3001", "\u516b\u3001", "\u4e5d\u3001", "\u5341\u3001"};

    private FundFlowMockDataBuilder() {
    }

    public static FundFlowMockDataBuilder init() throws FMMobileException {
        try {
            if (instance == null) {
                instance = new FundFlowMockDataBuilder();
                FileLoader loader = new FileLoader();
                FundFlowMockDataBuilder.instance.data = loader.readExcelFile(FundFlowMockDataBuilder.class.getClassLoader().getResourceAsStream("com/kingdee/eas/fm/mobile/app/fundflow/mock/fundflow_mockdata.xls"));
                instance.build();
            }
            return instance;
        }
        catch (IOException e) {
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, e, new Object[]{e.getMessage()});
        }
    }

    private FundFlowMockData build() {
        FundFlowMockData mockData = FundFlowMockData.getInstance();
        FlowItemMock oldFlowItem_l1 = null;
        FlowItemMock oldFlowItem_l2 = null;
        FlowItemMock oldFlowItem_l3 = null;
        int l4idx = 0;
        String idWithL1 = null;
        for (int i = 0; i < this.data.size(); ++i) {
            FlowItemMock newFlowItem;
            Object[] row = this.data.get(i);
            String flowItemID = this.trans2String(row[0]);
            String flowItemName = row[1].toString().trim();
            String flowItemType = row[2].toString().trim();
            BigDecimal previousPeriodYear = new BigDecimal(row[5].toString().trim()).multiply(new BigDecimal("1000"));
            BigDecimal thisPeriodYear = new BigDecimal(row[4].toString().trim()).multiply(new BigDecimal("1000"));
            BigDecimal previousPeriodMonth = new BigDecimal(row[7].toString().trim()).multiply(new BigDecimal("1000"));
            BigDecimal thisPeriodMonth = new BigDecimal(row[8].toString().trim()).multiply(new BigDecimal("1000"));
            if (this.isLevel1(flowItemID)) {
                oldFlowItem_l1 = new FlowItemMock(flowItemID, flowItemName, flowItemType, previousPeriodYear, thisPeriodYear, previousPeriodMonth, thisPeriodMonth);
                mockData.addRoot(oldFlowItem_l1);
                mockData.addFlowItemMock(oldFlowItem_l1);
                l4idx = 0;
                idWithL1 = flowItemID;
                continue;
            }
            if (this.isLevel2(flowItemID)) {
                newFlowItem = new FlowItemMock(idWithL1 + flowItemID, flowItemName, flowItemType, previousPeriodYear, thisPeriodYear, previousPeriodMonth, thisPeriodMonth);
                if (oldFlowItem_l1 != null) {
                    oldFlowItem_l1.addChild(newFlowItem);
                }
                mockData.addFlowItemMock(newFlowItem);
                oldFlowItem_l2 = newFlowItem;
                l4idx = 0;
                continue;
            }
            if (this.isLevel3(flowItemID)) {
                newFlowItem = new FlowItemMock(idWithL1 + flowItemID, flowItemName, flowItemType, previousPeriodYear, thisPeriodYear, previousPeriodMonth, thisPeriodMonth);
                if (oldFlowItem_l2 != null) {
                    oldFlowItem_l2.addChild(newFlowItem);
                }
                mockData.addFlowItemMock(newFlowItem);
                oldFlowItem_l3 = newFlowItem;
                l4idx = 0;
                continue;
            }
            if (oldFlowItem_l3 == null) continue;
            newFlowItem = new FlowItemMock(oldFlowItem_l3.getFlowItemID() + "." + ++l4idx, flowItemName, flowItemType, previousPeriodYear, thisPeriodYear, previousPeriodMonth, thisPeriodMonth);
            oldFlowItem_l3.addChild(newFlowItem);
            mockData.addFlowItemMock(newFlowItem);
        }
        mockData.build();
        return mockData;
    }

    private String trans2String(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    private boolean isLevel3(String flowItemID) {
        if (StringUtil.isEmpty(flowItemID) || flowItemID.equals("0.0")) {
            return false;
        }
        return flowItemID.matches("\\d+[.]\\d+");
    }

    private boolean isLevel2(String flowItemID) {
        if (StringUtil.isEmpty(flowItemID)) {
            return false;
        }
        return flowItemID.matches("\\d+\u3001");
    }

    private boolean isLevel1(String flowItemID) {
        return Arrays.asList((Object[])ID_LIST).contains(flowItemID);
    }
}

