/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.mock;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FlowItemMock;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FundFlowMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetListData {
    private final FundFlowMockData fundFlowMockData = FundFlowMockData.getInstance();

    public ResultInfo execute(String period, String orgID, String flowItemID) throws FMMobileException {
        List<FlowItemMock> children = null;
        BigDecimal fixedRate = null;
        if (FundReverseMockData.getInstance().getTopOrg().getID().equals(orgID)) {
            fixedRate = new BigDecimal("1");
        } else {
            try {
                SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
                fixedRate = new BigDecimal(rand.nextDouble() * 0.1 + 0.3);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        ResultInfo resultInfo = new ResultInfo();
        if (this.isTopFlowItem(flowItemID)) {
            children = this.fundFlowMockData.children();
            Map<String, Object> totalRow = this.buildTotalRow(children, period, fixedRate);
            resultInfo.put("dataList", this.buildRows(totalRow, null, children, period, fixedRate));
        } else {
            if (flowItemID == null) {
                throw new FMMobileException(FMMobileException.COMMON, new Object[]{"flowItemID\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            FlowItemMock flowItemMock = this.fundFlowMockData.getChildByID(flowItemID);
            children = flowItemMock.children();
            resultInfo.put("dataList", this.buildRows(null, flowItemMock, children, period, fixedRate));
        }
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    protected List<Map<String, Object>> buildRows(Map<String, Object> totalRow, FlowItemMock father, List<FlowItemMock> children, String period, BigDecimal fixedRate) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (totalRow != null) {
            rows.add(totalRow);
        }
        if (father != null) {
            rows.add(this.buildRow(father, period, fixedRate));
        }
        for (FlowItemMock flowItemMock : children) {
            rows.add(this.buildRow(flowItemMock, period, fixedRate));
        }
        return rows;
    }

    protected Map<String, Object> buildTotalRow(List<FlowItemMock> children, String period, BigDecimal fixedRate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (period.equals("YEAR")) {
            result.put("beginningOfThePeriod", new BigDecimal("50031068010").multiply(fixedRate));
            result.put("endOfThePeriod", new BigDecimal("50877365240").multiply(fixedRate));
            result.put("isLeaf", true);
            result.put("type", "ALL");
            result.put("thisPeriod", new BigDecimal("846297230").multiply(fixedRate));
            result.put("previousPeriod", new BigDecimal("794539020").multiply(fixedRate));
            result.put("inFlows", new BigDecimal("1631433070").multiply(fixedRate));
            result.put("outFlows", new BigDecimal("785135840").multiply(fixedRate));
        } else {
            result.put("beginningOfThePeriod", new BigDecimal("50824120920").multiply(fixedRate));
            result.put("endOfThePeriod", new BigDecimal("50877365240").multiply(fixedRate));
            result.put("isLeaf", true);
            result.put("type", "ALL");
            result.put("thisPeriod", new BigDecimal("53244321.67").multiply(fixedRate));
            result.put("previousPeriod", new BigDecimal("49998254.17").multiply(fixedRate));
            result.put("inFlows", new BigDecimal("142743720").multiply(fixedRate));
            result.put("outFlows", new BigDecimal("89499398.33").multiply(fixedRate));
        }
        return result;
    }

    protected Map<String, Object> buildRow(FlowItemMock flowItemMock, String period, BigDecimal fixedRate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flowItemID", flowItemMock.getFlowItemID());
        result.put("flowItemName", flowItemMock.getFlowItemName());
        result.put("isLeaf", flowItemMock.isLeaf());
        String type = flowItemMock.getFlowItemType();
        result.put("type", type);
        if (type.equals("IN")) {
            if (period.equals("YEAR")) {
                result.put("inFlows", flowItemMock.getThisPeriodYear().multiply(fixedRate));
            } else {
                result.put("inFlows", flowItemMock.getThisPeriodMonth().multiply(fixedRate));
            }
        } else if (type.equals("OUT")) {
            if (period.equals("YEAR")) {
                result.put("outFlows", flowItemMock.getThisPeriodYear().multiply(fixedRate));
            } else {
                result.put("outFlows", flowItemMock.getThisPeriodMonth().multiply(fixedRate));
            }
        } else {
            List children = flowItemMock.children();
            if (period.equals("YEAR")) {
                result.put("inFlows", ((FlowItemMock)children.get(0)).getThisPeriodYear().multiply(fixedRate));
                result.put("outFlows", ((FlowItemMock)children.get(1)).getThisPeriodYear().multiply(fixedRate));
            } else {
                result.put("inFlows", ((FlowItemMock)children.get(0)).getThisPeriodMonth().multiply(fixedRate));
                result.put("outFlows", ((FlowItemMock)children.get(1)).getThisPeriodMonth().multiply(fixedRate));
            }
        }
        if (period.equals("YEAR")) {
            result.put("thisPeriod", flowItemMock.getThisPeriodYear().multiply(fixedRate));
            result.put("previousPeriod", flowItemMock.getPreviousPeriodYear().multiply(fixedRate));
        } else {
            result.put("thisPeriod", flowItemMock.getThisPeriodMonth().multiply(fixedRate));
            result.put("previousPeriod", flowItemMock.getPreviousPeriodMonth().multiply(fixedRate));
        }
        return result;
    }

    private boolean isTopFlowItem(String flowItemID) {
        return StringUtil.isEmpty(flowItemID);
    }
}

