/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.mock;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.TopNLine;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.TopNMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FileLoader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TopNMockDataBuilder {
    public static final int BIZ_DATE = 0;
    public static final int SRC_CURRENCY = 1;
    public static final int SRC_AMOUNT = 2;
    public static final int DEST_AMOUNT = 3;
    public static final int RATE = 4;
    public static final int COMPANY = 5;
    public static final int OPEN_BANK = 6;
    public static final int ACCOUNT_BANK_ID = 7;
    public static final int OTHER_COMPANY = 8;
    public static final int OTHER_ACCOUNT_BANK_ID = 9;
    public static final int MEMO = 10;
    private static TopNMockDataBuilder instance = null;
    private List<Object[]> data = new ArrayList<Object[]>();

    private TopNMockDataBuilder() {
    }

    public static TopNMockDataBuilder init() throws FMMobileException {
        try {
            if (instance == null) {
                instance = new TopNMockDataBuilder();
                FileLoader loader = new FileLoader();
                TopNMockDataBuilder.instance.data = loader.readExcelFile(TopNMockDataBuilder.class.getClassLoader().getResourceAsStream("com/kingdee/eas/fm/mobile/app/fundflow/mock/topN_mockdata.xls"));
                instance.build();
            }
            return instance;
        }
        catch (IOException e) {
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, e, new Object[]{e.getMessage()});
        }
    }

    private TopNMockData build() {
        TopNMockData mockData = TopNMockData.getInstance();
        for (int i = 0; i < this.data.size(); ++i) {
            Object[] row = this.data.get(i);
            String bizDate = row[0].toString().trim();
            String srcCurrency = row[1].toString().trim();
            BigDecimal srcAmount = new BigDecimal(row[2].toString().trim());
            BigDecimal destAmount = new BigDecimal(row[3].toString().trim());
            BigDecimal rate = new BigDecimal(row[4].toString().trim());
            String company = row[5].toString().trim();
            String openBank = row[6].toString().trim();
            String accountBankID = row[7].toString().trim();
            String otherCompany = row[8].toString().trim();
            String otherAccountBankID = row[9].toString().trim();
            String memo = row[10].toString().trim();
            TopNLine line = new TopNLine(bizDate, srcCurrency, srcAmount, destAmount, rate, company, openBank, accountBankID, otherCompany, otherAccountBankID, memo);
            mockData.add(line);
        }
        mockData.build();
        return mockData;
    }
}

