/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse.TrendPeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class MonthWeekParsor
implements TrendPeriodParsor {
    private final int year;
    private final int month;

    private MonthWeekParsor(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public MonthWeekParsor(Map bizData) throws EASBizException {
        if (!ValidateUtil.isValidate(bizData, "year") || !ValidateUtil.isValidate(bizData, "month")) {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.month = DateUtils.getMonth(now);
        } else {
            this.year = (Integer)bizData.get("year");
            this.month = (Integer)bizData.get("month") - 1;
        }
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, this.month, 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        return DateUtils.getLastDayWithMonth(this.year, this.month);
    }

    @Override
    public TrendPeriodParsor previousTrend() {
        return new MonthWeekParsor(this.year - 1, this.month);
    }

    @Override
    public int getBgPeriod() {
        return 6;
    }

    @Override
    public String getName(int index) {
        return String.format("\u7b2c%d\u5468", index + 1);
    }
}

