/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse.TrendPeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class QuarterMonthParsor
implements TrendPeriodParsor {
    private final int year;
    private final int quarter;

    private QuarterMonthParsor(int year, int quarter) {
        this.year = year;
        this.quarter = quarter;
    }

    public QuarterMonthParsor(Map bizData) throws EASBizException {
        if (!ValidateUtil.isValidate(bizData, "year") || !ValidateUtil.isValidate(bizData, "quarter")) {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.quarter = DateUtils.getQuarter(now) - 1;
        } else {
            this.year = (Integer)bizData.get("year");
            this.quarter = (Integer)bizData.get("quarter") - 1;
        }
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, this.getMonth(), 1);
        return cal.getTime();
    }

    private int getMonth() {
        int[] begin_month = new int[]{0, 3, 6, 9};
        return begin_month[this.quarter];
    }

    @Override
    public Date getEndDate() {
        int[] end_month = new int[]{2, 5, 8, 11};
        return DateUtils.getLastDayWithMonth(this.year, end_month[this.quarter]);
    }

    @Override
    public TrendPeriodParsor previousTrend() {
        return new QuarterMonthParsor(this.year - 1, this.quarter);
    }

    @Override
    public int getBgPeriod() {
        return 4;
    }

    @Override
    public String getName(int index) {
        return String.format("%s\u6708", MONTH[this.getMonth() + index]);
    }
}

