/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse.TrendPeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import java.util.Date;
import java.util.Map;

public class WeekDayParsor
implements TrendPeriodParsor {
    private final int year;
    private final int weekOfYear;
    private String[] WEEK = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};

    private WeekDayParsor(int year, int weekOfYear) {
        this.year = year;
        this.weekOfYear = weekOfYear;
    }

    public WeekDayParsor(Map bizData) throws EASBizException {
        if (!ValidateUtil.isValidate(bizData, "year") || !ValidateUtil.isValidate(bizData, "weekOfYear")) {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.weekOfYear = DateUtils.getWeekOfYearCountFixed(now);
        } else {
            this.year = (Integer)bizData.get("year");
            this.weekOfYear = (Integer)bizData.get("weekOfYear");
        }
    }

    @Override
    public Date getBeginDate() {
        return BgPeriodHelper.getWeekFirstDay((int)this.year, (int)this.weekOfYear);
    }

    @Override
    public Date getEndDate() {
        return BgPeriodHelper.getWeekLastDay((int)this.year, (int)this.weekOfYear);
    }

    @Override
    public TrendPeriodParsor previousTrend() {
        if (this.weekOfYear == 54 && DateUtils.getWeekOfYearCountFixed(this.year) == 54) {
            return new WeekDayParsor(this.year - 1, DateUtils.getWeekOfYearCountFixed(this.year - 1));
        }
        return new WeekDayParsor(this.year - 1, this.weekOfYear);
    }

    @Override
    public int getBgPeriod() {
        return 7;
    }

    @Override
    public String getName(int index) {
        return String.format("\u5468%s", this.WEEK[index]);
    }
}

