/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundflow.trend.periodparse.TrendPeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class YearMonthParsor
implements TrendPeriodParsor {
    private final int year;

    private YearMonthParsor(int year) {
        this.year = year;
    }

    public YearMonthParsor(Map bizData) throws EASBizException {
        if (!ValidateUtil.isValidate(bizData, "year")) {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
        } else {
            this.year = (Integer)bizData.get("year");
        }
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 0, 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 11, 31);
        return cal.getTime();
    }

    @Override
    public TrendPeriodParsor previousTrend() {
        return new YearMonthParsor(this.year - 1);
    }

    @Override
    public int getBgPeriod() {
        return 4;
    }

    @Override
    public String getName(int index) {
        return String.format("%s\u6708", MONTH[index]);
    }
}

