/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class HalfAYearParsor
implements PeriodParsor {
    private final int year;
    private final String halfYearType;

    private HalfAYearParsor(int year, String halfYearType) {
        this.year = year;
        this.halfYearType = halfYearType;
    }

    public HalfAYearParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            ValidateUtil.validateParam(bizData, "halfYearType");
            this.year = (Integer)bizData.get("year");
            this.halfYearType = (String)bizData.get("halfYearType");
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.halfYearType = DateUtils.getYearType(now);
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if ("FIRST_HALF_YEAR".equals(this.halfYearType)) {
            cal.set(this.year, 0, 1);
        } else {
            cal.set(this.year, 6, 1);
        }
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if ("FIRST_HALF_YEAR".equals(this.halfYearType)) {
            cal.set(this.year, 5, 30);
        } else {
            cal.set(this.year, 11, 31);
        }
        return cal.getTime();
    }

    @Override
    public PeriodParsor previousPeriod() {
        return new HalfAYearParsor(this.year - 1, this.halfYearType);
    }

    @Override
    public int getBgPeriod() {
        return 2;
    }
}

