/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class MonthParsor
implements PeriodParsor {
    protected final int year;
    protected final int month;

    protected MonthParsor(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public MonthParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            ValidateUtil.validateParam(bizData, "month");
            this.year = (Integer)bizData.get("year");
            this.month = (Integer)bizData.get("month") - 1;
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.month = DateUtils.getMonth(now);
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, this.month, 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        return DateUtils.getLastDayWithMonth(this.year, this.month);
    }

    @Override
    public PeriodParsor previousPeriod() {
        return new MonthParsor(this.year - 1, this.month);
    }

    @Override
    public int getBgPeriod() {
        return 4;
    }
}

