/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class QuarterParsor
implements PeriodParsor {
    protected final int year;
    protected final int quarter;

    protected QuarterParsor(int year, int quarter) {
        this.year = year;
        this.quarter = quarter;
    }

    public QuarterParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            ValidateUtil.validateParam(bizData, "quarter");
            this.year = (Integer)bizData.get("year");
            this.quarter = (Integer)bizData.get("quarter") - 1;
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.quarter = DateUtils.getQuarter(now) - 1;
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        int[] begin_month = new int[]{0, 3, 6, 9};
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, begin_month[this.quarter], 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        int[] end_month = new int[]{2, 5, 8, 11};
        return DateUtils.getLastDayWithMonth(this.year, end_month[this.quarter]);
    }

    @Override
    public PeriodParsor previousPeriod() {
        return new QuarterParsor(this.year - 1, this.quarter);
    }

    @Override
    public int getBgPeriod() {
        return 3;
    }
}

