/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import java.util.Date;
import java.util.Map;

public class WeekParsor
implements PeriodParsor {
    protected final int year;
    protected final int weekOfYear;

    protected WeekParsor(int year, int weekOfYear) {
        this.year = year;
        this.weekOfYear = weekOfYear;
    }

    public WeekParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            ValidateUtil.validateParam(bizData, "weekOfYear");
            this.year = (Integer)bizData.get("year");
            this.weekOfYear = (Integer)bizData.get("weekOfYear");
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.weekOfYear = DateUtils.getWeekOfYearCountFixed(now);
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        return BgPeriodHelper.getWeekFirstDay((int)this.year, (int)this.weekOfYear);
    }

    @Override
    public Date getEndDate() {
        return BgPeriodHelper.getWeekLastDay((int)this.year, (int)this.weekOfYear);
    }

    @Override
    public PeriodParsor previousPeriod() {
        if (this.weekOfYear == 54 && DateUtils.getWeekOfYearCountFixed(this.year) == 54) {
            return new WeekParsor(this.year - 1, DateUtils.getWeekOfYearCountFixed(this.year - 1));
        }
        return new WeekParsor(this.year - 1, this.weekOfYear);
    }

    @Override
    public int getBgPeriod() {
        return 5;
    }
}

