/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import java.io.Serializable;
import java.math.BigDecimal;

public class AccountInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String openBankName;
    private boolean isLeaf;
    private String srcCurrency;
    private String descCurrency;
    private BigDecimal srcBalance;
    private BigDecimal descBalance;
    private BigDecimal srcLimitFund;
    private BigDecimal descLimitFund;
    private BigDecimal srcAvaliableBalance;
    private BigDecimal descAvaliableBalance;
    private String accountProperty;
    private boolean isLimit;
    private BigDecimal rate;

    public AccountInfo() {
    }

    public AccountInfo(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public void init(String openBankName, String accountPrepertyName, boolean isLimit, String currencyName, BigDecimal rate, BigDecimal balance) {
        this.setOpenBankName(openBankName);
        this.setAccountProperty(accountPrepertyName);
        this.setSrcCurrency(currencyName);
        this.setDescCurrency("\u4eba\u6c11\u5e01");
        this.setRate(rate);
        this.setLeaf(true);
        if (isLimit) {
            this.setSrcBalance(balance);
            this.setSrcLimitFund(balance);
            this.setSrcAvaliableBalance(BigDecimal.ZERO);
            this.setDescBalance(this.calculatLocalBalance(currencyName, balance));
            this.setDescLimitFund(this.calculatLocalBalance(currencyName, balance));
            this.setDescAvaliableBalance(BigDecimal.ZERO);
        } else {
            this.setSrcBalance(balance);
            this.setSrcLimitFund(BigDecimal.ZERO);
            this.setSrcAvaliableBalance(balance);
            this.setDescBalance(this.calculatLocalBalance(currencyName, balance));
            this.setDescLimitFund(BigDecimal.ZERO);
            this.setDescAvaliableBalance(this.calculatLocalBalance(currencyName, balance));
        }
    }

    private BigDecimal calculatLocalBalance(String currencyName, BigDecimal balance) {
        if (currencyName.equals("\u4eba\u6c11\u5e01")) {
            return balance;
        }
        return balance.multiply(this.rate);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOpenBankName() {
        return this.openBankName;
    }

    public void setOpenBankName(String openBankName) {
        this.openBankName = openBankName;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getSrcCurrency() {
        return this.srcCurrency;
    }

    public void setSrcCurrency(String srcCurrency) {
        this.srcCurrency = srcCurrency;
    }

    public BigDecimal getSrcBalance() {
        return this.srcBalance;
    }

    public void setSrcBalance(BigDecimal srcBalance) {
        this.srcBalance = srcBalance;
    }

    public String getDescCurrency() {
        return this.descCurrency;
    }

    public void setDescCurrency(String descCurrency) {
        this.descCurrency = descCurrency;
    }

    public BigDecimal getDescBalance() {
        return this.descBalance;
    }

    public void setDescBalance(BigDecimal descBalance) {
        this.descBalance = descBalance;
    }

    public String getAccountProperty() {
        return this.accountProperty;
    }

    public void setAccountProperty(String accountProperty) {
        this.accountProperty = accountProperty;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getSrcLimitFund() {
        return this.srcLimitFund;
    }

    public void setSrcLimitFund(BigDecimal srcLimitFund) {
        this.srcLimitFund = srcLimitFund;
    }

    public BigDecimal getDescLimitFund() {
        return this.descLimitFund;
    }

    public void setDescLimitFund(BigDecimal descLimitFund) {
        this.descLimitFund = descLimitFund;
    }

    public BigDecimal getSrcAvaliableBalance() {
        return this.srcAvaliableBalance;
    }

    public void setSrcAvaliableBalance(BigDecimal srcAvaliableBalance) {
        this.srcAvaliableBalance = srcAvaliableBalance;
    }

    public BigDecimal getDescAvaliableBalance() {
        return this.descAvaliableBalance;
    }

    public void setDescAvaliableBalance(BigDecimal descAvaliableBalance) {
        this.descAvaliableBalance = descAvaliableBalance;
    }

    public boolean isLimit() {
        return this.isLimit;
    }

    public void setLimit(boolean isLimit) {
        this.isLimit = isLimit;
    }
}

