/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.fm.mobile.app.MobileConfig;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.RankingMockData;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.SortableLine;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AbstractFunc;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageMockData;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FuncGetMetroBoard
extends AbstractFunc {
    public ResultInfo execute(String userRealName) {
        OrgInfo topOrg = this.mockData.getTopOrg();
        ResultInfo result = new ResultInfo();
        result.put("companyOrgUnitID", topOrg.getID());
        result.put("companyOrgUnitName", topOrg.getName());
        result.put("userRealName", userRealName);
        result.put("balance", topOrg.getBalance());
        result.put("limitFund", topOrg.getLimitFund());
        result.put("avaliableBalance", topOrg.getAvaliableBalance());
        result.put("currencyUnitName", "\u5343\u5143");
        result.put("currencyUnitValue", 1000);
        result.put("fundReverse", this.buildFundReverse(topOrg));
        result.put("fundFlow", this.buildFundFlow());
        result.put("earlyWarning", this.buildEarlyWarning());
        result.put("ranking", this.buildRanking());
        result.put("isOpenFundFlow", MobileConfig.isOpenFundFlow);
        result.put("isOpenEarlyWarning", MobileConfig.isOpenEarlyWarning);
        result.put("isOpenRanking", true);
        result.put("lastUpdateTime", DateUtils.formatDateTime(new Date()));
        return result;
    }

    private Map<String, Object> buildFundReverse(OrgInfo topOrg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("balance", topOrg.getBalance());
        result.put("limitFund", topOrg.getLimitFund());
        result.put("avaliableBalance", topOrg.getAvaliableBalance());
        return result;
    }

    private BigDecimal buildFundFlow() {
        return new BigDecimal("43.899");
    }

    private Map<String, Object> buildEarlyWarning() {
        MessageMockData mockData = MessageMockData.getInstance();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flowOutInRate", this.buildFlowOutInRate());
        result.put("largePayment", mockData.size("LARGE_PAYMENT"));
        return result;
    }

    private Map<String, Object> buildRanking() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fundReverseRanking", this.buildFundReverseRanking());
        result.put("cashContributionRanking", this.buildCashContributionRanking());
        return result;
    }

    private List<Map<String, Object>> buildCashContributionRanking() {
        RankingMockData instance = RankingMockData.getInstance();
        List<SortableLine> amountYearList = instance.getAmountYearList("DESC_TOP_N");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.add(this.buildOrgUnit(amountYearList.get(0).getOrgName()));
        result.add(this.buildOrgUnit(amountYearList.get(1).getOrgName()));
        result.add(this.buildOrgUnit(amountYearList.get(2).getOrgName()));
        return result;
    }

    private List<Map<String, Object>> buildFundReverseRanking() {
        RankingMockData instance = RankingMockData.getInstance();
        List<SortableLine> balanceList = instance.getBalanceList("DESC_TOP_N");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.add(this.buildOrgUnit(balanceList.get(0).getOrgName()));
        result.add(this.buildOrgUnit(balanceList.get(1).getOrgName()));
        result.add(this.buildOrgUnit(balanceList.get(2).getOrgName()));
        return result;
    }

    private Map<String, Object> buildOrgUnit(String orgName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orgName", orgName);
        return result;
    }

    private Map<String, Object> buildFlowOutInRate() {
        MessageMockData mockData = MessageMockData.getInstance();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RED", mockData.size("FLOW_OUT_IN_RATE_RED"));
        result.put("YELLOW", mockData.size("FLOW_OUT_IN_RATE_YELLOW"));
        return result;
    }
}

