/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AbstractFunc;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.DateMockUtil;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FuncGetReverseTrend
extends AbstractFunc {
    private static final String[] week_day = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final String[] month_week = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
    private static final String[] quarter_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private static final String[] year_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private Map bizData;
    private BigDecimal limitFund;
    private BigDecimal avaliableBalance;

    public ResultInfo execute(Map bizData) throws EASBizException {
        ValidateUtil.validateParam(bizData, "mainID");
        this.bizData = bizData;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("trendDataCollection", this.buildTrendDataCollection());
        return resultInfo;
    }

    private List buildTrendDataCollection() throws EASBizException {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        arrayList.add(this.buildTrendData("WEEK_DAY"));
        arrayList.add(this.buildTrendData("MONTH_WEEK"));
        arrayList.add(this.buildTrendData("QUARTER_MONTH"));
        arrayList.add(this.buildTrendData("YEAR_MONTH"));
        return arrayList;
    }

    private Map buildTrendData(String dateSolution) throws EASBizException {
        BigDecimal blance = this.getBalance();
        HashMap<String, String> trendData = new HashMap<String, String>();
        trendData.put("dateSolution", dateSolution);
        if (dateSolution.equals("WEEK_DAY")) {
            this.makeWeekDay(blance, trendData);
        } else if (dateSolution.equals("MONTH_WEEK")) {
            this.makeMonthWeek(blance, trendData);
        } else if (dateSolution.equals("QUARTER_MONTH")) {
            this.makeQuarterMonth(blance, trendData);
        } else {
            this.makeYearMonth(blance, trendData);
        }
        return trendData;
    }

    private BigDecimal getBalance() throws EASBizException {
        String mainID = (String)this.bizData.get("mainID");
        OrgInfo orgInfo = FundReverseMockData.getInstance().getByOrgID(mainID);
        if (orgInfo != null) {
            this.limitFund = orgInfo.getLimitFund();
            this.avaliableBalance = orgInfo.getAvaliableBalance();
            return orgInfo.getBalance();
        }
        BankInfo bankInfo = FundReverseMockData.getInstance().getByBankID(mainID);
        if (bankInfo != null) {
            ValidateUtil.validateParam(this.bizData, "superID");
            this.limitFund = bankInfo.getLimitFund();
            this.avaliableBalance = bankInfo.getAvaliableBalance();
            return bankInfo.getBalance();
        }
        AccountInfo accountInfo = FundReverseMockData.getInstance().getAccountID(mainID);
        this.limitFund = accountInfo.getDescLimitFund();
        this.avaliableBalance = accountInfo.getDescAvaliableBalance();
        return accountInfo.getDescBalance();
    }

    private void makeYearMonth(BigDecimal blance, Map trendData) {
        int count = DateMockUtil.getYearMonth(new Date());
        BigDecimal balanceSum = new BigDecimal("0");
        BigDecimal limitFundSum = new BigDecimal("0");
        BigDecimal avaliableBalanceSum = new BigDecimal("0");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            BigDecimal makeAvaliableBalance;
            BigDecimal makeLimitFund;
            BigDecimal makeBalance;
            if (i == count - 1) {
                makeBalance = blance;
                makeLimitFund = this.limitFund;
                makeAvaliableBalance = this.avaliableBalance;
                balanceSum = balanceSum.add(makeBalance);
                limitFundSum = limitFundSum.add(makeLimitFund);
                avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
                arrayList.add(this.buildPoint(year_month[i], makeBalance, makeLimitFund, makeAvaliableBalance));
                continue;
            }
            makeBalance = BigDecimalUtil.makeData(blance);
            makeLimitFund = BigDecimalUtil.makeData(this.limitFund);
            makeAvaliableBalance = BigDecimalUtil.makeData(this.avaliableBalance);
            balanceSum = balanceSum.add(makeBalance);
            limitFundSum = limitFundSum.add(makeLimitFund);
            avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
            arrayList.add(this.buildPoint(year_month[i], makeBalance, makeLimitFund, makeAvaliableBalance));
        }
        trendData.put("balanceAverage", balanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("limitFundAverage", limitFundSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("avaliableBalanceAverage", avaliableBalanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("values", arrayList);
    }

    private void makeQuarterMonth(BigDecimal blance, Map trendData) {
        int begin = DateMockUtil.getQuarterMonthBegin(new Date());
        int end = DateMockUtil.getQuarterMonthEnd(new Date());
        BigDecimal balanceSum = new BigDecimal("0");
        BigDecimal limitFundSum = new BigDecimal("0");
        BigDecimal avaliableBalanceSum = new BigDecimal("0");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = begin; i <= end; ++i) {
            BigDecimal makeAvaliableBalance;
            BigDecimal makeLimitFund;
            BigDecimal makeBalance;
            if (i == end) {
                makeBalance = blance;
                makeLimitFund = this.limitFund;
                makeAvaliableBalance = this.avaliableBalance;
                balanceSum = balanceSum.add(makeBalance);
                limitFundSum = limitFundSum.add(makeLimitFund);
                avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
                arrayList.add(this.buildPoint(quarter_month[i - 1], makeBalance, makeLimitFund, makeAvaliableBalance));
                continue;
            }
            makeBalance = BigDecimalUtil.makeData(blance);
            makeLimitFund = BigDecimalUtil.makeData(this.limitFund);
            makeAvaliableBalance = BigDecimalUtil.makeData(this.avaliableBalance);
            balanceSum = balanceSum.add(makeBalance);
            limitFundSum = limitFundSum.add(makeLimitFund);
            avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
            arrayList.add(this.buildPoint(quarter_month[i - 1], makeBalance, makeLimitFund, makeAvaliableBalance));
        }
        int count = end - begin + 1;
        trendData.put("balanceAverage", balanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("limitFundAverage", limitFundSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("avaliableBalanceAverage", avaliableBalanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("values", arrayList);
    }

    private void makeMonthWeek(BigDecimal blance, Map trendData) {
        int count = DateMockUtil.getMonthWeek(new Date());
        BigDecimal balanceSum = new BigDecimal("0");
        BigDecimal limitFundSum = new BigDecimal("0");
        BigDecimal avaliableBalanceSum = new BigDecimal("0");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            BigDecimal makeAvaliableBalance;
            BigDecimal makeLimitFund;
            BigDecimal makeBalance;
            if (i == count - 1) {
                makeBalance = blance;
                makeLimitFund = this.limitFund;
                makeAvaliableBalance = this.avaliableBalance;
                balanceSum = balanceSum.add(makeBalance);
                limitFundSum = limitFundSum.add(makeLimitFund);
                avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
                arrayList.add(this.buildPoint(month_week[i], makeBalance, makeLimitFund, makeAvaliableBalance));
                continue;
            }
            makeBalance = BigDecimalUtil.makeData(blance);
            makeLimitFund = BigDecimalUtil.makeData(this.limitFund);
            makeAvaliableBalance = BigDecimalUtil.makeData(this.avaliableBalance);
            balanceSum = balanceSum.add(makeBalance);
            limitFundSum = limitFundSum.add(makeLimitFund);
            avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
            arrayList.add(this.buildPoint(month_week[i], makeBalance, makeLimitFund, makeAvaliableBalance));
        }
        trendData.put("balanceAverage", balanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("limitFundAverage", limitFundSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("avaliableBalanceAverage", avaliableBalanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("values", arrayList);
    }

    private void makeWeekDay(BigDecimal blance, Map trendData) {
        int count = DateMockUtil.getWeekDay(new Date());
        BigDecimal balanceSum = new BigDecimal("0");
        BigDecimal limitFundSum = new BigDecimal("0");
        BigDecimal avaliableBalanceSum = new BigDecimal("0");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            BigDecimal makeAvaliableBalance;
            BigDecimal makeLimitFund;
            BigDecimal makeBalance;
            if (i == count - 1) {
                makeBalance = blance;
                makeLimitFund = this.limitFund;
                makeAvaliableBalance = this.avaliableBalance;
                balanceSum = balanceSum.add(makeBalance);
                limitFundSum = limitFundSum.add(makeLimitFund);
                avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
                arrayList.add(this.buildPoint(week_day[i], makeBalance, makeLimitFund, makeAvaliableBalance));
                continue;
            }
            makeBalance = BigDecimalUtil.makeData(blance);
            makeLimitFund = BigDecimalUtil.makeData(this.limitFund);
            makeAvaliableBalance = BigDecimalUtil.makeData(this.avaliableBalance);
            balanceSum = balanceSum.add(makeBalance);
            limitFundSum = limitFundSum.add(makeLimitFund);
            avaliableBalanceSum = avaliableBalanceSum.add(makeAvaliableBalance);
            arrayList.add(this.buildPoint(week_day[i], makeBalance, makeLimitFund, makeAvaliableBalance));
        }
        trendData.put("balanceAverage", balanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("limitFundAverage", limitFundSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("avaliableBalanceAverage", avaliableBalanceSum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
        trendData.put("values", arrayList);
    }

    private Object buildPoint(String name, BigDecimal balance, BigDecimal limitFund, BigDecimal avaliableBalance) {
        HashMap<String, Object> point = new HashMap<String, Object>();
        point.put("name", name);
        point.put("balance", balance);
        point.put("limitFund", limitFund);
        point.put("avaliableBalance", avaliableBalance);
        return point;
    }
}

