/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FileLoader;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class FundReverseMockDataBuilder {
    public static final int ORG_L1 = 0;
    public static final int ORG_L2 = 1;
    public static final int ORG_L3 = 2;
    public static final int BANK = 3;
    public static final int OPENBANK = 4;
    public static final int ACCOUNT = 5;
    public static final int ACCOUNT_PREPERTY = 6;
    public static final int ISLIMIT = 7;
    public static final int CURRENCY = 8;
    public static final int RATE = 9;
    public static final int BALANCE = 10;
    private static FundReverseMockDataBuilder instance = null;
    private List<Object[]> data = new ArrayList<Object[]>();

    private FundReverseMockDataBuilder() {
    }

    public static FundReverseMockDataBuilder init() throws FMMobileException {
        try {
            if (instance == null) {
                instance = new FundReverseMockDataBuilder();
                FileLoader loader = new FileLoader();
                FundReverseMockDataBuilder.instance.data = loader.readExcelFile(FundReverseMockDataBuilder.class.getClassLoader().getResourceAsStream("com/kingdee/eas/fm/mobile/app/fundreverse/mock/mock_data.xls"));
                instance.build();
            }
            return instance;
        }
        catch (IOException e) {
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, e, new Object[]{e.getMessage()});
        }
    }

    private FundReverseMockData build() {
        FundReverseMockData mockData = FundReverseMockData.getInstance();
        for (int i = 0; i < this.data.size(); ++i) {
            Object[] row = this.data.get(i);
            String org1Name = (String)row[0];
            String org2Name = (String)row[1];
            String org3Name = (String)row[2];
            String bankName = (String)row[3];
            String openBankName = (String)row[4];
            String accountName = (String)row[5];
            String accountPrepertyName = (String)row[6];
            String isLimitName = (String)row[7];
            String currencyName = (String)row[8];
            BigDecimal rate = new BigDecimal(row[9].toString());
            BigDecimal balance = new BigDecimal(row[10].toString());
            OrgInfo org1 = mockData.getOrgL1ByName(i, 0, org1Name);
            OrgInfo org2 = org1.getSubOrgByName(i, 1, org2Name);
            OrgInfo org3 = org2.getSubOrgByName(i, 2, org3Name);
            BankInfo bank = org3.getSubBankByName(i, 3, bankName);
            AccountInfo account = bank.getSubAccountByName(i + "_" + 5, accountName);
            account.init(openBankName, accountPrepertyName, isLimitName.equals("\u662f"), currencyName, rate, balance);
            mockData.addOrg(org1);
            mockData.addOrg(org2);
            mockData.addOrg(org3);
            mockData.addBank(bank);
            mockData.addAccount(account);
        }
        mockData.build();
        return mockData;
    }
}

