/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BigDecimalMockUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;

public class OrgInfo {
    private String id;
    private String name;
    private boolean isLeaf;
    private BigDecimal balance;
    private BigDecimal limitFund;
    private BigDecimal avaliableBalance;
    private BigDecimal concentration = new BigDecimal("0");
    private Map<String, OrgInfo> mapOrgByID = new TreeMap<String, OrgInfo>();
    private Map<String, OrgInfo> mapOrgByName = new TreeMap<String, OrgInfo>();
    private Map<String, BankInfo> mapBankByID = new TreeMap<String, BankInfo>();
    private Map<String, BankInfo> mapBankByName = new TreeMap<String, BankInfo>();
    private int level;

    public OrgInfo(int row, int level, String name) {
        String id = row + "_" + level;
        this.level = level;
        this.id = id;
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getLimitFund() {
        return this.limitFund;
    }

    public void setLimitFund(BigDecimal limitFund) {
        this.limitFund = limitFund;
    }

    public BigDecimal getAvaliableBalance() {
        return this.avaliableBalance;
    }

    public void setAvaliableBalance(BigDecimal avaliableBalance) {
        this.avaliableBalance = avaliableBalance;
    }

    public BigDecimal getConcentration() {
        return this.concentration;
    }

    public void setConcentration(BigDecimal concentration) {
        this.concentration = concentration;
    }

    public BankInfo[] getChildrenByBank() {
        return this.mapBankByName.values().toArray(new BankInfo[0]);
    }

    public OrgInfo[] getChildrenByOrg() {
        return this.mapOrgByName.values().toArray(new OrgInfo[0]);
    }

    public OrgInfo getSubOrgByName(int row, int level, String orgName) {
        String id = row + "_" + level;
        OrgInfo orgInfo = this.mapOrgByName.get(orgName);
        if (orgInfo == null) {
            orgInfo = new OrgInfo(row, level, orgName);
            this.mapOrgByID.put(id, orgInfo);
            this.mapOrgByName.put(orgName, orgInfo);
        }
        return orgInfo;
    }

    public BankInfo getSubBankByName(int row, int level, String bankName) {
        String id = row + "_" + level;
        BankInfo bankInfo = this.mapBankByName.get(bankName);
        if (bankInfo == null) {
            bankInfo = new BankInfo(row, level, bankName);
            this.mapBankByID.put(id, bankInfo);
            this.mapBankByName.put(bankName, bankInfo);
        }
        return bankInfo;
    }

    public OrgInfo getByOrgID(String mainID) {
        if (this.mapOrgByID.containsKey(mainID)) {
            return this.mapOrgByID.get(mainID);
        }
        for (OrgInfo orgInfo : this.mapOrgByID.values()) {
            OrgInfo searchResult = orgInfo.getByOrgID(mainID);
            if (searchResult == null) continue;
            return searchResult;
        }
        return null;
    }

    public BigDecimal calculateBalance() {
        BigDecimal result = new BigDecimal("0");
        if (this.level == 0 || this.level == 1) {
            result = this.calculateSubOrgBalance();
            this.concentration = BigDecimalMockUtil.makeConcentration(result);
        } else if (this.level == 2) {
            result = this.calculateSubBankBalance();
        }
        this.balance = result;
        return result;
    }

    private BigDecimal calculateSubBankBalance() {
        BigDecimal sum = new BigDecimal("0");
        for (BankInfo bankInfo : this.mapBankByID.values()) {
            sum = sum.add(bankInfo.calculateBalance());
        }
        return sum;
    }

    private BigDecimal calculateSubOrgBalance() {
        BigDecimal sum = new BigDecimal("0");
        for (OrgInfo orgInfo : this.mapOrgByID.values()) {
            sum = sum.add(orgInfo.calculateBalance());
        }
        return sum;
    }

    public BigDecimal calculateLimitFund() {
        BigDecimal result = new BigDecimal("0");
        if (this.level == 0 || this.level == 1) {
            result = this.calculateSubOrgLimitFund();
        } else if (this.level == 2) {
            result = this.calculateSubBankLimitFund();
        }
        this.limitFund = result;
        this.avaliableBalance = this.balance.subtract(this.limitFund);
        return result;
    }

    private BigDecimal calculateSubBankLimitFund() {
        BigDecimal sum = new BigDecimal("0");
        for (BankInfo bankInfo : this.mapBankByID.values()) {
            sum = sum.add(bankInfo.calculateLimitFund());
        }
        return sum;
    }

    private BigDecimal calculateSubOrgLimitFund() {
        BigDecimal sum = new BigDecimal("0");
        for (OrgInfo orgInfo : this.mapOrgByID.values()) {
            sum = sum.add(orgInfo.calculateLimitFund());
        }
        return sum;
    }
}

