/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock.listdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.listdata.ListDataGetterMock;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AbstractListDataGetter;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BankListDataGetterMock
extends AbstractListDataGetter
implements ListDataGetterMock {
    private FundReverseMockData mockData;
    private String mainID;

    @Override
    public ResultInfo doGet(Context ctx, String superID, String mainID) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public ResultInfo doGet(FundReverseMockData mockData, String superID, String mainID) throws EASBizException, BOSException {
        if (superID == null) {
            throw new FMMobileException(FMMobileException.COMMON, new Object[]{"superID\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        this.mainID = mainID;
        this.mockData = mockData;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData());
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map> buildListData() {
        BankInfo bankInfo = this.mockData.getByBankID(this.mainID);
        ArrayList<Map> listData = new ArrayList<Map>();
        listData.add(this.buildTitleRow(bankInfo));
        listData.addAll(this.buildRows(bankInfo));
        return listData;
    }

    private Map buildTitleRow(BankInfo bankInfo) {
        return this.buildBankRow(bankInfo.getID(), bankInfo.getName(), bankInfo.isLeaf(), bankInfo.getBalance(), bankInfo.getLimitFund(), bankInfo.getAvaliableBalance());
    }

    private List<Map> buildRows(BankInfo bankInfo) {
        AccountInfo[] accounts;
        ArrayList<Map> rows = new ArrayList<Map>();
        for (AccountInfo accountInfo : accounts = bankInfo.getChildrenByAccount()) {
            String objID = accountInfo.getID();
            String objName = String.format("%s(%s)-%s", accountInfo.getOpenBankName(), accountInfo.getSrcCurrency(), StringUtil.last(accountInfo.getName(), 4));
            String accountNumber = accountInfo.getName();
            String openBankID = accountInfo.getOpenBankName();
            String openBankName = accountInfo.getOpenBankName();
            boolean isLeaf = accountInfo.isLeaf();
            String srcCurrency = accountInfo.getSrcCurrency();
            String descCurrency = accountInfo.getDescCurrency();
            BigDecimal srcBalance = accountInfo.getSrcBalance();
            BigDecimal descBalance = accountInfo.getDescBalance();
            BigDecimal srcLimitFund = accountInfo.getSrcLimitFund();
            BigDecimal descLimitFund = accountInfo.getDescLimitFund();
            BigDecimal srcAvaliableBalance = accountInfo.getSrcAvaliableBalance();
            BigDecimal descAvaliableBalance = accountInfo.getDescAvaliableBalance();
            String accountProperty = accountInfo.getAccountProperty();
            boolean isLimit = accountInfo.isLimit();
            Map<String, Object> row = this.buildAccountBankRow(objID, objName, accountNumber, openBankID, openBankName, "account", isLeaf, srcCurrency, descCurrency, srcBalance, descBalance, srcLimitFund, descLimitFund, srcAvaliableBalance, descAvaliableBalance, accountProperty, isLimit);
            rows.add(row);
        }
        return rows;
    }
}

