/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock.listdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockData;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.listdata.ListDataGetterMock;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AbstractListDataGetter;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrgUnitListDataGetterMock
extends AbstractListDataGetter
implements ListDataGetterMock {
    private FundReverseMockData mockData;
    private String mainID;

    @Override
    public ResultInfo doGet(Context ctx, String superID, String mainID) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public ResultInfo doGet(FundReverseMockData mockData, String superID, String mainID) throws EASBizException, BOSException {
        this.mockData = mockData;
        this.mainID = mainID;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData());
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map> buildListData() {
        OrgInfo mainOrgInfo = this.mockData.getByOrgID(this.mainID);
        ArrayList<Map> listData = new ArrayList<Map>();
        listData.add(this.buildTitleRow(mainOrgInfo));
        listData.addAll(this.buildRows(mainOrgInfo));
        return listData;
    }

    private Map buildTitleRow(OrgInfo mainOrgInfo) {
        return this.buildOrgUnitRow(mainOrgInfo.getID(), mainOrgInfo.getName(), mainOrgInfo.isLeaf(), mainOrgInfo.getBalance(), mainOrgInfo.getLimitFund(), mainOrgInfo.getAvaliableBalance(), mainOrgInfo.getConcentration());
    }

    private List<Map> buildRows(OrgInfo mainOrgInfo) {
        if (mainOrgInfo.getLevel() == 2) {
            return this.buildBankRows(mainOrgInfo);
        }
        return this.buildSubOrgRows(mainOrgInfo);
    }

    private List<Map> buildBankRows(OrgInfo mainOrgInfo) {
        BankInfo[] banks;
        ArrayList<Map> rows = new ArrayList<Map>();
        for (BankInfo bankInfo : banks = mainOrgInfo.getChildrenByBank()) {
            Map<String, Object> row = this.buildBankRow(bankInfo.getID(), bankInfo.getName(), bankInfo.isLeaf(), bankInfo.getBalance(), bankInfo.getLimitFund(), bankInfo.getAvaliableBalance());
            rows.add(row);
        }
        return rows;
    }

    private List<Map> buildSubOrgRows(OrgInfo mainOrgInfo) {
        OrgInfo[] orgs;
        ArrayList<Map> rows = new ArrayList<Map>();
        for (OrgInfo orgInfo : orgs = mainOrgInfo.getChildrenByOrg()) {
            Map<String, Object> row = this.buildOrgUnitRow(orgInfo.getID(), orgInfo.getName(), orgInfo.isLeaf(), orgInfo.getBalance(), orgInfo.getLimitFund(), orgInfo.getAvaliableBalance(), orgInfo.getConcentration());
            rows.add(row);
        }
        return rows;
    }
}

