/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AbstractListDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.BankNumberComparator;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.CompanyNumberComparator;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.CashBankUtil;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class OrgUnitListDataGetter
extends AbstractListDataGetter {
    private Context ctx;
    private String superID;
    private String mainID;

    @Override
    public ResultInfo doGet(Context ctx, String superID, String mainID) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.superID = superID;
        this.mainID = mainID;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData());
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map> buildListData() throws BOSException, EASBizException {
        CompanyLiquidInfo companyLiquidInfo = this.accessDataWithTopLevelCompanyOrgUnit(this.ctx, this.mainID);
        ArrayList<Map> listData = new ArrayList<Map>();
        listData.add(this.buildTitleRow(companyLiquidInfo));
        listData.addAll(this.buildRows(companyLiquidInfo));
        return listData;
    }

    private CompanyLiquidInfo accessDataWithTopLevelCompanyOrgUnit(Context ctx, String companyID) throws BOSException, EASBizException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getCompanyBalanceAndLimtsByCompamy(companyID, new Date());
        CompanyLiquidInfo companyLiquidInfo = (CompanyLiquidInfo)resultMap.get(companyID);
        return companyLiquidInfo;
    }

    private Map buildTitleRow(CompanyLiquidInfo companyLiquidInfo) throws EASBizException, BOSException {
        String objID = companyLiquidInfo.getCompanyid();
        String objName = companyLiquidInfo.getCompanyName();
        boolean isLeaf = companyLiquidInfo.isLeaf();
        BigDecimal balance = companyLiquidInfo.getLocalBalance();
        BigDecimal limitFund = companyLiquidInfo.getLocalLimitAmount();
        BigDecimal avaliableBalance = companyLiquidInfo.getLocalAvaliableBalance();
        BigDecimal concentration = this.getConcentration(companyLiquidInfo.getCompanyid());
        return this.buildOrgUnitRow(objID, objName, isLeaf, balance, limitFund, avaliableBalance, concentration);
    }

    private BigDecimal getConcentration(String companyID) throws EASBizException, BOSException {
        Map fundConceration = MobileLiquidFacadeFactory.getLocalInstance((Context)this.ctx).getFundConceration(companyID, new Date());
        BigDecimal motherBalance = (BigDecimal)fundConceration.get("motherBalance");
        BigDecimal subBalance = (BigDecimal)fundConceration.get("subBalance");
        BigDecimal otherBalance = (BigDecimal)fundConceration.get("otherBalance");
        BigDecimal in = motherBalance.add(subBalance);
        BigDecimal all = motherBalance.add(subBalance.add(otherBalance));
        if (BigDecimalUtils.isNullOrZero(in) || BigDecimalUtils.isNullOrZero(all)) {
            return null;
        }
        return in.divide(all, RoundingMode.HALF_UP);
    }

    private List<Map> buildRows(CompanyLiquidInfo companyLiquidInfo) throws BOSException, EASBizException {
        if (companyLiquidInfo.isLeaf()) {
            return this.buildBankRows(companyLiquidInfo);
        }
        return this.buildSubOrgRows(companyLiquidInfo);
    }

    private List<Map> buildSubOrgRows(CompanyLiquidInfo companyLiquidInfo) throws BOSException, EASBizException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)this.ctx).getAllCompanyBalanceAndLimtsByCompamy(companyLiquidInfo.getCompanyid(), new Date());
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new CompanyNumberComparator());
        sortSet.addAll(resultMap.values());
        ArrayList<Map> rows = new ArrayList<Map>();
        for (CompanyLiquidInfo subCompanyLiquidInfo : sortSet) {
            String objID = subCompanyLiquidInfo.getCompanyid();
            String objName = subCompanyLiquidInfo.getCompanyName();
            boolean isLeaf = BigDecimalUtils.isNullOrZero(subCompanyLiquidInfo.getLocalBalance());
            BigDecimal balance = subCompanyLiquidInfo.getLocalBalance();
            BigDecimal limitFund = subCompanyLiquidInfo.getLocalLimitAmount();
            BigDecimal avaliableBalance = subCompanyLiquidInfo.getLocalAvaliableBalance();
            BigDecimal concentration = this.getConcentration(subCompanyLiquidInfo.getCompanyid());
            rows.add(this.buildOrgUnitRow(objID, objName, isLeaf, balance, limitFund, avaliableBalance, concentration));
        }
        return rows;
    }

    private List<Map> buildBankRows(CompanyLiquidInfo companyLiquidInfo) throws BOSException, EASBizException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)this.ctx).getAllBankBalanceAndLimtsByCompamy(companyLiquidInfo.getCompanyid(), new Date());
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new BankNumberComparator());
        sortSet.addAll(resultMap.values());
        ArrayList<Map> rows = new ArrayList<Map>();
        for (CompanyLiquidInfo companyLiquidInfoWithSubBankInfo : sortSet) {
            String objID = companyLiquidInfoWithSubBankInfo.getBankId();
            String objName = CashBankUtil.getObjectName(companyLiquidInfoWithSubBankInfo);
            boolean isLeaf = false;
            BigDecimal balance = companyLiquidInfoWithSubBankInfo.getLocalBalance();
            BigDecimal limitFund = companyLiquidInfoWithSubBankInfo.getLocalLimitAmount();
            BigDecimal avaliableBalance = companyLiquidInfoWithSubBankInfo.getLocalAvaliableBalance();
            rows.add(this.buildBankRow(objID, objName, false, balance, limitFund, avaliableBalance));
        }
        return rows;
    }
}

