/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.capitalinsight.common.CompanyUtil;
import com.kingdee.eas.fm.mobile.app.message.AbstractMessageBuilderFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.message.DataOfBuildedFactory;
import com.kingdee.eas.fm.mobile.app.message.DataOfBuildedInfo;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageBuilderType;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageFactory;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageInfo;
import com.kingdee.eas.fm.mobile.model.MonetaryUnit;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.MonetaryUnitUtil;
import com.kingdee.eas.fm.mobile.util.SQLScriptUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.fm.mobile.util.XuntHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MessageBuilderFacadeControllerBean
extends AbstractMessageBuilderFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.message.MessageBuilderFacadeControllerBean");
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.mobile.FmMobile";

    private void sendToPubacc(Context ctx, boolean isSendToPubacc, String pubaccConfigName, String requestBuilderType) throws EASBizException, BOSException {
        if (isSendToPubacc) {
            try {
                XuntHelper xuntHelper = new XuntHelper(ctx, pubaccConfigName, requestBuilderType);
                MobileMessageCollection mobileMessageCollection = xuntHelper.sendMessage();
                xuntHelper.modifyStatus(mobileMessageCollection);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void _buildFlowOutInRateMessage(Context ctx, boolean isSendToPubacc, String pubaccConfigName) throws BOSException, EASBizException {
        XuntHelper.modifyOldStatus(ctx, "FLOW_OUT_IN_RATE");
        try {
            this.readFlowOutInRateMessageAndSave(ctx);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        this.sendToPubacc(ctx, isSendToPubacc, pubaccConfigName, "FLOW_OUT_IN_RATE");
    }

    private void readFlowOutInRateMessageAndSave(Context ctx) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        filterParamMap.put("beginDate", DateUtils.formatDate(DateUtils.getPrevTwoMonth()));
        filterParamMap.put("endDate", DateUtils.formatDate(new Date()));
        filterParamMap.put("isOrgPermission", "false");
        filterParamMap.put("parentCompanyId", CompanyUtil.getTopLevelCompany(ctx).getId().toString());
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 6);
        this.buildMessagesAndSave(ctx, rs);
    }

    private void buildMessagesAndSave(Context ctx, IRowSet rs) throws SQLException, EASBizException, BOSException {
        while (rs.next()) {
            BigDecimal flowIn = rs.getBigDecimal("FLocalIncomeAmount");
            BigDecimal flowOut = rs.getBigDecimal("FLocalOutcomeAmount");
            BigDecimal flowOutInRate = BigDecimalUtils.calcRate(flowOut, flowIn);
            MobileMessageBuilderType flowOutInRateType = this.calcBuilderType(flowOutInRate);
            if (flowOutInRateType == null) continue;
            MobileMessageInfo msgInfo = new MobileMessageInfo();
            String msg = this.buildMessage(ctx, rs.getString("FCompanyName"), flowOutInRate);
            msgInfo.setTitle("\u6d41\u5165\u6d41\u51fa\u6bd4\u9884\u8b66");
            msgInfo.setDetail(msg);
            msgInfo.setImgText(this.buildImgText(flowOutInRate));
            msgInfo.setSender("System");
            msgInfo.setCompany(this.createCompanyOrgUnitInfo(rs.getString("FCompanyId")));
            msgInfo.setBuilderType(flowOutInRateType);
            MobileMessageFactory.getLocalInstance(ctx).save((CoreBaseInfo)msgInfo);
        }
    }

    private String buildImgText(BigDecimal flowOutInRate) {
        if (flowOutInRate == null) {
            return "\u6ca1\u6709\u6d41\u5165!";
        }
        return this.flowOutInRateFormat(flowOutInRate).toString() + " %";
    }

    private String buildMessage(Context ctx, String companyName, BigDecimal flowOutInRate) {
        if (flowOutInRate == null) {
            return String.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"FLOW_OUT_IN_RATE_MESSAGE_MAX", (Locale)ctx.getLocale()), companyName);
        }
        return String.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"FLOW_OUT_IN_RATE_MESSAGE", (Locale)ctx.getLocale()), companyName, this.flowOutInRateFormat(flowOutInRate));
    }

    private BigDecimal flowOutInRateFormat(BigDecimal flowOutInRate) {
        return flowOutInRate.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
    }

    private MobileMessageBuilderType calcBuilderType(BigDecimal flowOutInRate) {
        if (flowOutInRate == null || flowOutInRate.compareTo(new BigDecimal("1.0")) > 0) {
            return MobileMessageBuilderType.FLOW_OUT_IN_RATE_RED;
        }
        if (flowOutInRate.compareTo(new BigDecimal("0.8")) > 0) {
            return MobileMessageBuilderType.FLOW_OUT_IN_RATE_YELLOW;
        }
        return null;
    }

    private CompanyOrgUnitInfo createCompanyOrgUnitInfo(String companyID) {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        return company;
    }

    @Override
    protected void _buildLargePaymentMessage(Context ctx, boolean isSendToPubacc, String pubaccConfigName) throws BOSException, EASBizException {
        XuntHelper.modifyOldStatus(ctx, "LARGE_PAYMENT");
        IRowSet rs = this.getJournalCollectionWithUnbuilder(ctx);
        try {
            this.buildLargePaymentMessage(ctx, rs);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        this.sendToPubacc(ctx, isSendToPubacc, pubaccConfigName, "LARGE_PAYMENT");
    }

    private void buildLargePaymentMessage(Context ctx, IRowSet rs) throws EASBizException, BOSException, SQLException {
        while (rs.next()) {
            if (!this.isLargePayment(ctx, rs)) continue;
            this.transformLargePaymentMessageAndSave(ctx, rs);
        }
    }

    private boolean isLargePayment(Context ctx, IRowSet rs) throws EASBizException, BOSException, SQLException {
        return this.isBussinessAndOut(rs) && this.isLargeAmount(ctx, rs, new BigDecimal("100000"));
    }

    private boolean isBussinessAndOut(IRowSet rs) throws SQLException {
        return 0 == rs.getInt("fproperty") && 2 == rs.getInt("fdirection");
    }

    private boolean isLargeAmount(Context ctx, IRowSet rs, BigDecimal amount) throws EASBizException, BOSException, SQLException {
        String cu_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        CompanyOrgUnitInfo org = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        BigDecimal exRate = LiquidFacadeHelper.getExRateInfo((Context)ctx, (String)rs.getString("currencyid"), (CompanyOrgUnitInfo)org, (Date)new Date());
        return rs.getBigDecimal("flowitementriesamount").multiply(exRate).compareTo(amount) >= 0;
    }

    private IRowSet getJournalCollectionWithUnbuilder(Context ctx) throws BOSException {
        String sql = SQLScriptUtils.SQL_lARGEPAYMENT;
        logger.info((Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(DateUtils.getPrevTwoMonth().getTime())});
        return rs;
    }

    private void transformLargePaymentMessageAndSave(Context ctx, IRowSet rs) throws EASBizException, BOSException, SQLException {
        MobileMessageInfo msgInfo = new MobileMessageInfo();
        MonetaryUnit monetaryUnit = MonetaryUnitUtil.getMonetaryUnit(ctx);
        BigDecimal amountFormat = rs.getBigDecimal("flowitementriesamount").divide(monetaryUnit.getValue(), 3, RoundingMode.HALF_UP);
        String msg = String.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"LARGE_PAYMENT_MESSAGE", (Locale)ctx.getLocale()), rs.getDate("fbizDate"), rs.getString("companyname"), rs.getString("fundflowitemname"), rs.getString("currencyname"), amountFormat, monetaryUnit.getName(), this.getDescription(rs));
        msgInfo.setTitle("\u5927\u989d\u652f\u4ed8\u9884\u8b66");
        msgInfo.setDetail(msg);
        msgInfo.setImgText(amountFormat.toString() + "(" + monetaryUnit.getName() + ")");
        msgInfo.setSender("System");
        msgInfo.setCompany(this.createCompanyOrgUnitInfo(rs.getString("companyid")));
        msgInfo.setBuilderType(MobileMessageBuilderType.LARGE_PAYMENT);
        MobileMessageFactory.getLocalInstance(ctx).save((CoreBaseInfo)msgInfo);
        DataOfBuildedInfo dataOfBuildedInfo = new DataOfBuildedInfo();
        dataOfBuildedInfo.setMainData(rs.getString("fid"));
        dataOfBuildedInfo.setAssistData1(rs.getString("flowitementriesid"));
        dataOfBuildedInfo.setMessage(msgInfo);
        DataOfBuildedFactory.getLocalInstance(ctx).save((CoreBaseInfo)dataOfBuildedInfo);
    }

    private String getDescription(IRowSet rs) throws SQLException {
        String description = rs.getString("fdescription");
        return StringUtil.isEmpty(description) ? "\u65e0" : description;
    }
}

