/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageFactory;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageFlag;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageInfo;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationFactory;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationInfo;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageStatus;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.PermissionCompanyTreeUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MobileMessageHelper {
    final Context ctx;
    final String userID;

    public MobileMessageHelper(Context ctx) {
        this.ctx = ctx;
        this.userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
    }

    public void buildMobileMessageRelation() throws BOSException, EASBizException {
        this.buildMobileMessageRelation(null);
    }

    public void buildMobileMessageRelation(String builderType) throws BOSException, EASBizException {
        MobileMessageCollection msgColl = this.getMessageListByCompany(builderType);
        this.writeMobileMessageRelation(msgColl);
    }

    private MobileMessageCollection getMessageListByCompany(String builderType) throws BOSException, EASBizException {
        Set<String> companyWithPermissionIDs = this.transIDs(PermissionCompanyTreeUtil.getCompanyTreeWithPermission((Context)this.ctx));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        view.setSelector(selectors);
        view.setFilter(this.buildCreateMessageListFilterInfo(this.userID, companyWithPermissionIDs, DateUtils.getPrevTwoMonth(), builderType));
        MobileMessageCollection msgColl = MobileMessageFactory.getLocalInstance(this.ctx).getMobileMessageCollection(view);
        return msgColl;
    }

    private Set<String> transIDs(CompanyOrgUnitCollection companyTreeWithPermission) {
        HashSet<String> result = new HashSet<String>();
        for (CompanyOrgUnitInfo companyOrgUnitInfo : companyTreeWithPermission) {
            result.add(companyOrgUnitInfo.getId().toString());
        }
        return result;
    }

    private FilterInfo buildCreateMessageListFilterInfo(String userID, Set<String> companyWithPermissionIDs, Date previousTime, String builderType) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("createTime", (Object)previousTime, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)String.format("select FMessageID from T_FMM_MobileMessageRelation where fuserid='%s'", userID), CompareType.NOTINNER));
        if (builderType != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("builderType", (Object)(builderType + "%"), CompareType.LIKE));
        }
        FilterInfo orgFilterInfo = new FilterInfo();
        orgFilterInfo.getFilterItems().add(new FilterItemInfo("company.id", companyWithPermissionIDs, CompareType.INCLUDE));
        filterInfo.mergeFilter(orgFilterInfo, "and");
        return filterInfo;
    }

    private void writeMobileMessageRelation(MobileMessageCollection msgColl) throws EASBizException, BOSException {
        CoreBaseCollection resultColl = new CoreBaseCollection();
        Iterator it = msgColl.iterator();
        while (it.hasNext()) {
            MobileMessageInfo msgInfo = (MobileMessageInfo)it.next();
            MobileMessageRelationInfo mobileMessageRelationInfo = new MobileMessageRelationInfo();
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)this.userID));
            mobileMessageRelationInfo.setUser(user);
            mobileMessageRelationInfo.setMessage(msgInfo);
            mobileMessageRelationInfo.setStatus(MobileMessageStatus.UNREAD);
            mobileMessageRelationInfo.setFlag(MobileMessageFlag.UNFOLLOW);
            msgInfo.getRelations().add(mobileMessageRelationInfo);
            resultColl.add((CoreBaseInfo)mobileMessageRelationInfo);
        }
        MobileMessageRelationFactory.getLocalInstance(this.ctx).saveBatchData(resultColl);
    }

    public MobileMessageRelationCollection getMobileMessageRelationCollection() throws BOSException {
        return this.getMobileMessageRelationCollection(null);
    }

    public MobileMessageRelationCollection getMobileMessageRelationCollection(String builderType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("message.*");
        view.setSelector(selectors);
        view.setFilter(this.buildGetMessageListFilterInfo(this.userID, builderType));
        MobileMessageRelationCollection msgColl = MobileMessageRelationFactory.getLocalInstance(this.ctx).getMobileMessageRelationCollection(view);
        return msgColl;
    }

    private FilterInfo buildGetMessageListFilterInfo(String userID, String builderType) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userID));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"DELETE", CompareType.NOTEQUALS));
        if (builderType != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("message.builderType", (Object)(builderType + "%"), CompareType.LIKE));
        }
        return filterInfo;
    }

    public MobileMessageRelationCollection getUnreadMobileMessageRelationCollection() throws BOSException {
        return this.getUnreadMobileMessageRelationCollection(null);
    }

    public MobileMessageRelationCollection getUnreadMobileMessageRelationCollection(String builderType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("message.*");
        view.setSelector(selectors);
        view.setFilter(this.buildUnreadGetMessageListFilterInfo(this.userID, builderType));
        MobileMessageRelationCollection msgColl = MobileMessageRelationFactory.getLocalInstance(this.ctx).getMobileMessageRelationCollection(view);
        return msgColl;
    }

    private FilterInfo buildUnreadGetMessageListFilterInfo(String userID, String builderType) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userID));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"UNREAD"));
        if (builderType != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("message.builderType", (Object)(builderType + "%"), CompareType.LIKE));
        }
        return filterInfo;
    }
}

