/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message.mock;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageInfoMock;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageMockData;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageMockDataBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageMockUtil {
    public static ResultInfo getMessageList() throws EASBizException {
        MessageMockDataBuilder.init();
        List<MessageInfoMock> messageList = MessageMockData.getInstance().getMessages();
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("messageList", MessageMockUtil.buildMessageList(messageList));
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private static List buildMessageList(List<MessageInfoMock> messageList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (MessageInfoMock messageInfoMock : messageList) {
            result.add(MessageMockUtil.buildMessageInfo(messageInfoMock));
        }
        return result;
    }

    private static Map<String, Object> buildMessageInfo(MessageInfoMock messageInfoMock) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("messageID", messageInfoMock.getMessageID());
        result.put("type", messageInfoMock.getType());
        result.put("detail", messageInfoMock.getDetail());
        result.put("senderName", messageInfoMock.getSenderName());
        result.put("date", DateUtils.formatDate(messageInfoMock.getDate()));
        result.put("readFlag", messageInfoMock.isReadFlag());
        return result;
    }

    public static void deleteMessageList(Map bizData) throws EASBizException {
        MessageMockDataBuilder.init();
        ValidateUtil.validateParam(bizData, "messageIDs");
        String messageIDs = (String)bizData.get("messageIDs");
        MessageMockData.getInstance().deleteMessages(messageIDs);
    }

    public static void readMessageList(Map bizData) throws EASBizException {
        MessageMockDataBuilder.init();
        ValidateUtil.validateParam(bizData, "messageIDs");
        String messageIDs = (String)bizData.get("messageIDs");
        MessageMockData.getInstance().readMessages(messageIDs);
    }

    public static void unreadMessageList(Map bizData) throws EASBizException {
        MessageMockDataBuilder.init();
        ValidateUtil.validateParam(bizData, "messageIDs");
        String messageIDs = (String)bizData.get("messageIDs");
        MessageMockData.getInstance().unreadMessages(messageIDs);
    }
}

