/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.mobile.util.AccountCurrencyComponentUtil;

public class BOSTypeUtil {
    private static final String ACCOUNT_BANK_BOS_TYPE = "FB326E5E";
    private static final String BANK_BOS_TYPE = "0C5D4387";
    private static final String FULL_ORG_UNIT_BOS_TYPE = "CCE7AED4";
    private static final String ORG_UNIT_BOS_TYPE = "9127AC92";
    private static final String CASH_BANK_BOS_TYPE = "CASH_BANK_BOS_TYPE";
    private static final String ACCOUNT_BOS_TYPE = "ACCOUNT_BOS_TYPE";
    private static final String ACCOUNT_VIEW_BOS_TYPE = "9DA99826";
    private static final String CURRENCY_BOS_TYPE = "DEB58FDC";

    public static final String getBOSType(String bosUuid) {
        if ("cash0000".equals(bosUuid)) {
            return CASH_BANK_BOS_TYPE;
        }
        AccountCurrencyComponentUtil accountCurrencyComponentUtil = new AccountCurrencyComponentUtil(bosUuid);
        if (accountCurrencyComponentUtil.isRight()) {
            String accountBOSType = BOSTypeUtil.getBOSType(accountCurrencyComponentUtil.getAccountID());
            String currencyBOSType = BOSTypeUtil.getBOSType(accountCurrencyComponentUtil.getCurrencyID());
            if ((ACCOUNT_BANK_BOS_TYPE.equals(accountBOSType) || ACCOUNT_VIEW_BOS_TYPE.equals(accountBOSType)) && CURRENCY_BOS_TYPE.equals(currencyBOSType)) {
                return ACCOUNT_BOS_TYPE;
            }
        }
        return BOSUuid.read((String)bosUuid).getType().toString();
    }

    public static final boolean isOrgUnit(String bosUuid) {
        String bosType = BOSTypeUtil.getBOSType(bosUuid);
        return FULL_ORG_UNIT_BOS_TYPE.equals(bosType) || ORG_UNIT_BOS_TYPE.equals(bosType);
    }

    public static final boolean isBank(String bosUuid) {
        String bosType = BOSTypeUtil.getBOSType(bosUuid);
        return BANK_BOS_TYPE.equals(bosType) || CASH_BANK_BOS_TYPE.equals(bosType);
    }

    public static final boolean isAccount(String bosUuid) {
        String bosType = BOSTypeUtil.getBOSType(bosUuid);
        return ACCOUNT_BOS_TYPE.equals(bosType);
    }
}

