/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillSatusEnum;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.app.service.IClaimSaveService;
import com.kingdee.eas.fm.nc.app.service.ServiceHandler;
import org.apache.log4j.Logger;

public class ClaimSaveService
implements IClaimSaveService {
    private static Logger logger = Logger.getLogger((String)ClaimSaveService.class.getName());
    protected Context ctx;
    protected ClaimBillInfo info;
    protected ServiceHandler serviceHandler;
    protected static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, ClaimBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeSave() throws EASBizException, BOSException {
        this.verifyBillStatus();
        this.serviceHandler.verifyHead(this.ctx, this.info);
        this.serviceHandler.verifyEntry(this.ctx, this.info);
        this.serviceHandler.verifyAmount(this.ctx, this.info);
        this.serviceHandler.defaultData(this.ctx, this.info);
    }

    protected void verifyBillStatus() throws NCException {
        if (this.info.getBillStatus() != ClaimBillSatusEnum.SAVE) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)this.ctx, (String)NC_RESOURCE, (String)"ClaimBillStatus_NOT_Save")});
        }
        this.info.setBillStatus(ClaimBillSatusEnum.SAVE);
    }

    @Override
    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        this.serviceHandler.reverseNoticeBill(this.ctx, this.info);
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getNumber(), (String)"nc_claimBill_save");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
    }
}

