/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import java.util.Date;

public class ChequeBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("company.*");
        selectors.add("applyRec.applyCompany.*");
        selectors.add("applyRec.*");
        selectors.add("oppAccount.*");
        selectors.add("bankAcct.*");
        selectors.add("turnInAcctBank.*");
        selectors.add("oppAccount.*");
        selectors.add("ntType.*");
        selectors.add("oppAccount.*");
        selectors.add(new SelectorItemInfo("actualBankAcct.account.id"));
        selectors.add(new SelectorItemInfo("actualBankAcct.account.number"));
        selectors.add(new SelectorItemInfo("actualBankAcct.account.name"));
        selectors.add(new SelectorItemInfo("actualBankAcct.id"));
        selectors.add(new SelectorItemInfo("actualBankAcct.name"));
        selectors.add(new SelectorItemInfo("actualBankAcct.number"));
        selectors.add(new SelectorItemInfo("actualBankAcct.bankAccountNumber"));
        return selectors;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        ChequeInfo bill = ChequeFactory.getLocalInstance(ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)), this.getSelector());
        if (bill.isIsOwnReceive()) {
            JournalInfo cjournalInfo = this.createCreditJournal(ctx, bill);
            journalCollection.add(cjournalInfo);
            if (bill.getTurnInAcctBank() != null) {
                JournalInfo bdjournalInfo = this.createDebitBankJournal(ctx, bill);
                journalCollection.add(bdjournalInfo);
            }
            if (bill.getOppAccount() != null && bill.getOppAccount().isIsCash()) {
                JournalInfo cdjournalInfo = this.createDebitCashJournal(ctx, bill);
                journalCollection.add(cdjournalInfo);
            }
        } else {
            JournalInfo journalInfo = this.createCreditJournal(ctx, bill);
            journalCollection.add(journalInfo);
        }
        return journalCollection;
    }

    private JournalInfo createCreditJournal(Context ctx, ChequeInfo bill) throws BOSException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(bill.getActualBankAcct() != null ? bill.getActualBankAcct() : bill.getBankAcct());
        journalInfo.setAccountView(bill.getActualBankAcct() != null ? bill.getActualBankAcct().getAccount() : bill.getBankAcct().getAccount());
        journalInfo.setCreditAmount(bill.getAmount());
        return journalInfo;
    }

    private JournalInfo createDebitBankJournal(Context ctx, ChequeInfo bill) throws BOSException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setAccountBank(bill.getTurnInAcctBank());
        journalInfo.setAccountView(bill.getTurnInAcctBank().getAccount());
        journalInfo.setDebitAmount(bill.getAmount());
        journalInfo.setType(JournalTypeEnum.BANK);
        return journalInfo;
    }

    private JournalInfo createDebitCashJournal(Context ctx, ChequeInfo bill) throws BOSException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setAccountView(bill.getOppAccount());
        journalInfo.setOppAccountView(bill.getActualBankAcct() != null ? bill.getActualBankAcct().getAccount() : bill.getBankAcct().getAccount());
        journalInfo.setDebitAmount(bill.getAmount());
        journalInfo.setType(JournalTypeEnum.CASH);
        return journalInfo;
    }

    private JournalInfo createBaseJouranl(Context ctx, ChequeInfo bill) throws BOSException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setId(BOSUuid.create((BOSObjectType)journalInfo.getBOSType()));
        journalInfo.setCompany(bill.getApplyRec().getApplyCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(bill.getId().toString());
        journalInfo.setBizDate(DateUtil.getDayBegin((Date)bill.getIssueDate()));
        journalInfo.setCreateDate(DateUtil.getDayBegin((Date)bill.getIssueDate()));
        journalInfo.setBillType(BillTypeEnum.Cheque);
        journalInfo.setBillNumber(bill.getNumber());
        journalInfo.setTicketNumber(bill.getNumber());
        journalInfo.setSettlementNumber(bill.getNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)bill.getNtType().getId().toString()));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = bill.getSettleType();
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        journalInfo.setSettlementType(type);
        journalInfo.setCurrency(bill.getCurrency());
        journalInfo.setDescription(bill.getUsage());
        if (bill.getOppAccount() != null) {
            journalInfo.setOppAccountView(bill.getOppAccount());
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }
}

