/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class DiscountBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        DiscountBillInfo info = this.getInfo(ctx, billId);
        if (FMHelper.isEmpty((CoreBaseInfo)info.getInnerAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerAcct().getCompany()) || !info.getInnerAcct().getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
            return new SubsidiaryLedgerCollection();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.DISCOUNTBILL);
        subInfo.setApplyUnit(info.getInnerAcct().getApplyUnit());
        subInfo.setCompany(info.getInnerAcct().getCompany());
        subInfo.setInnerAccount(info.getInnerAcct());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNoteBillNumber());
        subInfo.setDate(info.getDiscountDate());
        subInfo.setCpCurrency(info.getCurrency());
        if (info.getPayablebill() != null) {
            subInfo.setDebitAmount(Constants.ZERO);
            subInfo.setCreditAmount(info.getActDiscountInt());
            subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"456_DiscountBillFromPayable", (Locale)ctx.getLocale()));
        } else {
            subInfo.setDebitAmount(info.getActRecvAmount());
            subInfo.setCreditAmount(Constants.ZERO);
            subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"379_DiscountBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        }
        subInfo.setExchangeRate(info.getExRate());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(subInfo);
        return coll;
    }

    private DiscountBillInfo getInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("innerAcct.*");
        IDiscountBill iDiscountBill = DiscountBillFactory.getLocalInstance(ctx);
        return iDiscountBill.getDiscountBillInfo((IObjectPK)pk, sic);
    }
}

