/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.ORMEngine;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BookMessageInfo;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class NTBookHelper {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";

    public static void bookJournal(Context ctx, String billId, String bookBuilder) throws BOSException, EASBizException {
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        BookMessageInfo bookMsg = bookNotifyFacade.book(bookBuilder, billId);
        if (bookMsg.isSuccess()) {
            NTBookHelper.Disposer4BookJournal(ctx, billId, true);
        }
    }

    public static void autoBookJournalforRec(Context ctx, String billId, CompanyOrgUnitInfo companyInfo, String bookBuilder, boolean isReceiving) throws BOSException, EASBizException {
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        int cs001 = contextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        boolean nt015 = NTHelper.getParam4Boolean(ctx, "NT015", companyInfo);
        if (cs001 != 0 || !nt015 || !isReceiving) {
            // empty if block
        }
    }

    public static void autoBookJournal(Context ctx, String billId, CompanyOrgUnitInfo companyInfo, String bookBuilder) throws BOSException, EASBizException {
        NTBookHelper.autoBookJournalforRec(ctx, billId, companyInfo, bookBuilder, false);
    }

    public static void autoAntiBookJournal(Context ctx, String billId, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (NTBookHelper.getJournalInfo(ctx, billId) != null && !NTHelper.getParam4Boolean(ctx, "NT015", companyInfo)) {
            throw new NTException(NTException.HAVEJOURNAL);
        }
        NTBookHelper.antiBookJouranl(ctx, billId);
    }

    public static void antiBookJouranl(Context ctx, String billId) throws BOSException, EASBizException {
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookNotifyFacade.antiBook(billId);
        NTBookHelper.Disposer4BookJournal(ctx, billId, false);
    }

    private static void Disposer4BookJournal(Context ctx, String billId, boolean isBook) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(BOSUuid.read((String)billId).getType());
        if (!NTBookHelper.isHasCashierProperty(bo)) {
            return;
        }
        if (isBook) {
            DbUtil.execute((Context)ctx, (String)("update " + bo.getTable().getName() + " set FCashierId=? where FID=?"), (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), billId});
        } else {
            DbUtil.execute((Context)ctx, (String)("update " + bo.getTable().getName() + " set FCashierId=null where FID=?"), (Object[])new Object[]{billId});
        }
    }

    private static boolean isHasCashierProperty(EntityObjectInfo bo) {
        boolean flag = false;
        for (PropertyInfo propInfo : bo.getProperties()) {
            if (!propInfo.getName().equals("cashier")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean bookOppositeJournal(Context ctx, ReceivableBillInfo receivableInfo, ReturnBillInfo returnInfo) throws BOSException, EASBizException {
        JournalInfo jnlInfo;
        ArrayList<String> bookBillId = new ArrayList<String>();
        bookBillId.add(receivableInfo.getId().toString());
        if (receivableInfo.getDiscountBill() != null) {
            bookBillId.add(receivableInfo.getDiscountBill().getId().toString());
        }
        JournalCollection coll = new JournalCollection();
        for (int i = 0; i < bookBillId.size(); ++i) {
            String id = (String)bookBillId.get(i);
            JournalInfo jnlInfo2 = NTBookHelper.getJournalInfo4Book(ctx, id, returnInfo);
            if (jnlInfo2 == null) continue;
            coll.add(jnlInfo2);
        }
        if (receivableInfo.getEndorseBill() != null && (jnlInfo = NTBookHelper.getJournalInfo4Book(ctx, receivableInfo.getEndorseBill().getId().toString(), receivableInfo.getBillAmt().multiply(Constants.ONE.subtract(FMHelper.getBigDecimal((Object)receivableInfo.getEndorseBill().getFeeRate()))), returnInfo)) != null) {
            coll.add(jnlInfo);
        }
        if (coll.size() == 0) {
            return false;
        }
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        BookMessageInfo bookMsg = bookNotifyFacade.bookBatch(coll);
        if (bookMsg.isSuccess()) {
            NTBookHelper.Disposer4BookJournal(ctx, returnInfo.getId().toString(), true);
            return true;
        }
        return false;
    }

    private static JournalInfo getJournalInfo4Book(Context ctx, String billId, ReturnBillInfo returnInfo) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)billId)) {
            return null;
        }
        JournalInfo oldJnlInfo = NTBookHelper.getJournalInfo(ctx, billId);
        if (oldJnlInfo == null) {
            return null;
        }
        JournalInfo jnlInfo = (JournalInfo)oldJnlInfo.clone();
        jnlInfo.setBizDate(new Date());
        jnlInfo.setCreateDate(NTBookHelper.getBookJournalDate(ctx, returnInfo.getReturnDate()));
        jnlInfo.setId(null);
        jnlInfo.setCreator(null);
        jnlInfo.setCreateTime(null);
        jnlInfo.setLastUpdateUser(null);
        jnlInfo.setLastUpdateTime(null);
        BigDecimal creditAmt = jnlInfo.getCreditAmount();
        BigDecimal debitAmt = jnlInfo.getDebitAmount();
        jnlInfo.setCreditAmount(debitAmt);
        jnlInfo.setDebitAmount(creditAmt);
        boolean isDebit = jnlInfo.isIsDebit();
        jnlInfo.setIsDebit(!isDebit);
        jnlInfo.setBillId(returnInfo.getId().toString());
        jnlInfo.setDescription(NTBookHelper.getJournalDesc(ctx, returnInfo));
        return jnlInfo;
    }

    private static JournalInfo getJournalInfo4Book(Context ctx, String billId, BigDecimal bookAmt, ReturnBillInfo returnInfo) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)billId)) {
            return null;
        }
        JournalInfo oldJnlInfo = NTBookHelper.getJournalInfo(ctx, billId);
        if (oldJnlInfo == null) {
            return null;
        }
        JournalInfo jnlInfo = (JournalInfo)oldJnlInfo.clone();
        jnlInfo.setBizDate(new Date());
        jnlInfo.setCreateDate(NTBookHelper.getBookJournalDate(ctx, returnInfo.getReturnDate()));
        jnlInfo.setId(null);
        jnlInfo.setCreator(null);
        jnlInfo.setCreateTime(null);
        jnlInfo.setLastUpdateUser(null);
        jnlInfo.setLastUpdateTime(null);
        boolean isDebit = jnlInfo.isIsDebit();
        jnlInfo.setIsDebit(!isDebit);
        if (jnlInfo.isIsDebit()) {
            jnlInfo.setDebitAmount(bookAmt);
            jnlInfo.setCreditAmount(Constants.ZERO);
        } else {
            jnlInfo.setCreditAmount(bookAmt);
            jnlInfo.setDebitAmount(Constants.ZERO);
        }
        jnlInfo.setBillId(returnInfo.getId().toString());
        jnlInfo.setDescription(NTBookHelper.getJournalDesc(ctx, returnInfo));
        return jnlInfo;
    }

    private static String getJournalDesc(Context ctx, ReturnBillInfo returnInfo) {
        String desc = "";
        if (returnInfo.getSrcBillState() == 1) {
            desc = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"381_NTBookHelper", (Locale)ctx.getLocale());
        } else if (returnInfo.getSrcBillState() == 7) {
            desc = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"382_NTBookHelper", (Locale)ctx.getLocale());
        } else if (returnInfo.getSrcBillState() == 3) {
            desc = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"383_NTBookHelper", (Locale)ctx.getLocale());
        }
        return desc;
    }

    private static JournalInfo getJournalInfo(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        JournalInfo jnlInfo = null;
        if (coll.size() > 0) {
            jnlInfo = coll.get(0);
        }
        return jnlInfo;
    }

    private static Date getBookJournalDate(Context ctx, Date billDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Date myDate = DateTimeUtils.truncateDate((Date)billDate);
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        if (currPeriodInfo != null && myDate.before(currPeriodInfo.getBeginDate())) {
            return currPeriodInfo.getBeginDate();
        }
        return myDate;
    }

    private static boolean isCHCompany(Context ctx) throws EASBizException, BOSException {
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        return BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(companyId);
    }

    public static void bookSubsidiary(Context ctx, String billId, String bookBuilder) throws EASBizException, BOSException {
        if (!NTBookHelper.isCHCompany(ctx)) {
            return;
        }
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(billId, bookBuilder);
    }

    public static void antiBookSubsidiary(Context ctx, String billId) throws BOSException, EASBizException {
        if (!NTBookHelper.isCHCompany(ctx)) {
            return;
        }
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(billId);
    }

    public static void bookOppositeSubsidiary(Context ctx, String billId, String returnBillId, Date returnDate, String desc) throws BOSException, EASBizException {
        if (!NTBookHelper.isCHCompany(ctx)) {
            return;
        }
        SubsidiaryLedgerInfo oldSubInfo = NTBookHelper.getSubsidiaryLedgerInfo(ctx, billId);
        if (oldSubInfo == null) {
            return;
        }
        SubsidiaryLedgerInfo subInfo = (SubsidiaryLedgerInfo)oldSubInfo.clone();
        if (subInfo != null) {
            subInfo.setDate(returnDate);
            subInfo.setId(null);
            subInfo.setCreateTime(null);
            BigDecimal creditAmt = subInfo.getCreditAmount();
            BigDecimal debitAmt = subInfo.getDebitAmount();
            subInfo.setCreditAmount(debitAmt);
            subInfo.setDebitAmount(creditAmt);
            subInfo.setBillId(BOSUuid.read((String)returnBillId));
            subInfo.setDescription(desc);
            subInfo.setIsDownLoad(false);
            SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
            coll.add(subInfo);
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(coll);
        }
    }

    public static void bookOppositeSubsidiary(Context ctx, String billId, String returnBillId, Date returnDate, String desc, BigDecimal debitAmount, BigDecimal creditAmount) throws BOSException, EASBizException {
        if (!NTBookHelper.isCHCompany(ctx)) {
            return;
        }
        SubsidiaryLedgerInfo oldSubInfo = NTBookHelper.getSubsidiaryLedgerInfo(ctx, billId);
        if (oldSubInfo == null) {
            return;
        }
        SubsidiaryLedgerInfo subInfo = (SubsidiaryLedgerInfo)oldSubInfo.clone();
        if (subInfo != null) {
            subInfo.setDate(returnDate);
            subInfo.setId(null);
            subInfo.setCreateTime(null);
            subInfo.setCreditAmount(creditAmount);
            subInfo.setDebitAmount(debitAmount);
            subInfo.setBillId(BOSUuid.read((String)returnBillId));
            subInfo.setDescription(desc);
            SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
            coll.add(subInfo);
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(coll);
        }
    }

    public static SubsidiaryLedgerInfo getSubsidiaryLedgerInfo(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        SubsidiaryLedgerInfo subInfo = null;
        int i = 0;
        if (i < coll.size()) {
            subInfo = coll.get(i);
        }
        return subInfo;
    }

    public static boolean checkIsBook(Context ctx, Date date) throws BOSException, EASBizException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, null);
        return clearingHouse.getSettleDate().compareTo(date) > 0;
    }

    public static SubsidiaryLedgerCollection getLastSubsidiaryLedgerInfo(Context ctx, String billId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection subsiColl = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        SubsidiaryLedgerCollection bookColl = new SubsidiaryLedgerCollection();
        if (subsiColl == null || subsiColl.size() == 0) {
            throw new BOSException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"384_NTBookHelper", (Locale)ctx.getLocale()));
        }
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, null);
        for (int i = 0; i < subsiColl.size(); ++i) {
            if (NTBookHelper.checkIsBook(ctx, clearingHouse, subsiColl.get(i).getDate())) continue;
            bookColl.add(subsiColl.get(i));
        }
        return bookColl;
    }

    public static SubsidiaryLedgerInfo getLastBookSubsidiaryLedgerInfo(Context ctx, String billId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection subsiColl = null;
        SubsidiaryLedgerInfo lastSubInfo = null;
        subsiColl = ctx != null ? SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view) : SubsidiaryLedgerFactory.getRemoteInstance().getSubsidiaryLedgerCollection(view);
        if (subsiColl.size() > 0) {
            lastSubInfo = subsiColl.get(0);
            Timestamp first = subsiColl.get(0).getCreateTime();
            Timestamp second = null;
            for (int i = 1; i < subsiColl.size(); ++i) {
                second = subsiColl.get(i).getCreateTime();
                if (!second.after((Date)first)) continue;
                first = second;
                lastSubInfo = subsiColl.get(i);
            }
        }
        return lastSubInfo;
    }

    public static boolean checkIsBook(Context ctx, BankInfo clearingHouse, Date date) throws BOSException, EASBizException {
        return clearingHouse != null && clearingHouse.getSettleDate().compareTo(date) > 0;
    }

    public static void autoBookJournalForConfirm(Context ctx, String billId, CompanyOrgUnitInfo companyInfo, String bookBuilder) throws BOSException, EASBizException {
        boolean isCreateToreceivBill = false;
        ArrayList recvBillIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(billId, new ReceivableBillInfo().getBOSType().toString());
        isCreateToreceivBill = recvBillIdList.size() > 0;
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        int val = contextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        if (val == 0 && NTHelper.getParam4Boolean(ctx, "NT015", companyInfo) && !isCreateToreceivBill) {
            NTBookHelper.bookJournal(ctx, billId, bookBuilder);
        }
    }

    public static void bookMoreSubsidiary(Context ctx, String billId, String providerName) throws BOSException, EASBizException {
        ISubsidiaryBookProvider provider = null;
        try {
            provider = (ISubsidiaryBookProvider)Class.forName(providerName).newInstance();
        }
        catch (InstantiationException e) {
            SysUtil.abort();
        }
        catch (IllegalAccessException e) {
            SysUtil.abort();
        }
        catch (ClassNotFoundException e) {
            SysUtil.abort();
        }
        if (provider != null) {
            SubsidiaryLedgerCollection coll = provider.getCollection(ctx, billId);
            SubsidiaryLedgerInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = (SubsidiaryLedgerInfo)coll.getObject(i);
                info.setDate(DateTimeUtils.truncateDate((Date)info.getDate()));
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                info.setSeq(i);
                info.setIsCreateInnerEReceipt(false);
                NTBookHelper.verifyBookSubsidiaryLedger(ctx, info);
            }
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)coll);
        }
    }

    public static void antiLastBookSubsidiaryLedgerInfo(Context ctx, String billId) throws BOSException, EASBizException {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection subsiColl = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        SubsidiaryLedgerInfo lastSubInfoOne = subsiColl.get(0);
        SubsidiaryLedgerInfo lastSubInfoTwo = null;
        DateFormat format = Constants.FORMAT_TIME;
        String first = format.format(new Date(lastSubInfoOne.getCreateTime().getTime()));
        Timestamp firstDate = lastSubInfoOne.getCreateTime();
        String second = "";
        Timestamp secondDate = null;
        for (i = 1; i < subsiColl.size(); ++i) {
            secondDate = subsiColl.get(i).getCreateTime();
            if (!secondDate.after((Date)firstDate)) continue;
            firstDate = secondDate;
            lastSubInfoOne = subsiColl.get(i);
            first = format.format(new Date(lastSubInfoOne.getCreateTime().getTime()));
        }
        for (i = 1; i < subsiColl.size(); ++i) {
            second = format.format(new Date(subsiColl.get(i).getCreateTime().getTime()));
            if (!first.equals(second) || lastSubInfoOne.getId().equals((Object)subsiColl.get(i).getId())) continue;
            lastSubInfoTwo = subsiColl.get(i);
        }
        if (lastSubInfoTwo != null) {
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(lastSubInfoTwo.getId().toString()));
        }
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(lastSubInfoOne.getId().toString()));
    }

    private static void verifyBookSubsidiaryLedger(Context ctx, SubsidiaryLedgerInfo sub) throws EASBizException, BOSException {
        BigDecimal creditAmount;
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, (String)sub.getCompany().getId().toString());
        if (!clearingHouse.isUsed()) {
            throw new FSException(FSException.CLEARINGHOUSENOTUSED);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"applyUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"innerAccount");
        if (!sub.getDate().after(clearingHouse.getSettleDate())) {
            sub.setDate(DateTimeUtils.truncateDate((Date)clearingHouse.getSettleDate()));
        }
        BigDecimal debitAmount = sub.getDebitAmount();
        if (debitAmount == null) {
            sub.setDebitAmount(SysConstant.BIGZERO);
        }
        if ((creditAmount = sub.getCreditAmount()) == null) {
            sub.setCreditAmount(SysConstant.BIGZERO);
        }
        sub.setLocalAmount(SysConstant.BIGZERO);
        if (sub.getDebitAmount().equals(SysConstant.BIGZERO) && sub.getCreditAmount().equals(SysConstant.BIGZERO)) {
            throw new FSException(FSException.AMOUNTALLZERO);
        }
    }

    public static SubsidiaryLedgerCollection filterSubsidiaryLedgerCollection(SubsidiaryLedgerCollection coll, Date date) {
        SubsidiaryLedgerCollection filterColl = new SubsidiaryLedgerCollection();
        DateFormat format = Constants.FORMAT_DAY;
        String currentDate = format.format(new Date());
        String bookDate = null;
        for (int i = 0; i < coll.size(); ++i) {
            bookDate = format.format(coll.get(i).getDate());
            if (!currentDate.equals(bookDate)) continue;
            filterColl.add(coll.get(i));
        }
        return filterColl;
    }

    public static void antiBookSubsidiaryByCurrentyDay(Context ctx, SubsidiaryLedgerCollection coll) throws BOSException, EASBizException {
        ISubsidiaryLedger iSub = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK[] pks = null;
        SubsidiaryLedgerCollection collByDay = NTBookHelper.filterSubsidiaryLedgerCollection(coll, new Date());
        if (collByDay.size() > 0) {
            pks = new ObjectUuidPK[collByDay.size()];
            ObjectUuidPK pk = null;
            for (int i = 0; i < collByDay.size(); ++i) {
                pks[i] = pk = new ObjectUuidPK(collByDay.get(i).getId().toString());
            }
        }
        iSub.delete(pks);
    }

    public static boolean checkLastIsBook(Context ctx, String billId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection subsiColl = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        if (subsiColl == null || subsiColl.size() == 0) {
            throw new BOSException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"384_NTBookHelper", (Locale)ctx.getLocale()));
        }
        SubsidiaryLedgerInfo lastSubInfo = subsiColl.get(0);
        Date first = subsiColl.get(0).getDate();
        Date second = null;
        for (int i = 1; i < subsiColl.size(); ++i) {
            second = subsiColl.get(i).getDate();
            if (!second.after(first)) continue;
            first = second;
            lastSubInfo = subsiColl.get(i);
        }
        return NTBookHelper.checkIsBook(ctx, lastSubInfo.getDate());
    }

    public static int getBooksCount(Context ctx, String billId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection subsiColl = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        int count = 0;
        SubsidiaryLedgerInfo lastSubInfoOne = subsiColl.get(0);
        DateFormat format = Constants.FORMAT_TIME;
        String first = format.format(new Date(lastSubInfoOne.getCreateTime().getTime()));
        String second = null;
        for (int i = 0; i < subsiColl.size(); ++i) {
            ++count;
            first = format.format(new Date(subsiColl.get(i).getCreateTime().getTime()));
            for (int j = i + 1; j < subsiColl.size(); ++j) {
                second = format.format(new Date(subsiColl.get(j).getCreateTime().getTime()));
                if (!first.equals(second) || subsiColl.get(i).getId().equals((Object)subsiColl.get(j).getId())) continue;
                --count;
            }
        }
        return count;
    }
}

